
/* Garmin GPS35PC commands */
#define GPS35_SW2BIN_CMD "$PGRMO,,S\r\n" 
#define GPS35_SW2NMEA_CMD "\020\015\004\002\015\000\000\0340\020\003"
#define GPS35_GETEPH_CMD "\020\015\004\002\016\000\000\0341\020\003"

/* Special characters in data stream.  
 * Also used to identify data stream state.  */
#define DAT 0x01
#define ETX 0x03  /* ASCII ETX */
#define DLE 0x10  /* ASCII DLE */

/* Record types. */
#define POS_REC 0x28 /* Position Record Identifier */
#define RCV_REC 0x29 /* Receiver Record Identifier */
#define EPH_REC 0x2a /* Ephemeris recond (currently not implemented) */

#define RCV_REC_LEN 226

/* Output formats */
#define FORMAT_GPS25PM 1
#define FORMAT_RINEX 2

/*
 * These structures adapted from Garmin manual. Note that the following
 * architecture is assumed: short = 16 bits, int = 32 bits, double = 16 bits
 * char = 8 bits
 */


/* Receiver channel record */
typedef struct {
   unsigned int cycles;   /* 32 bits Number of accululated cycles */
   double pr;             /* 64 bits Pseudorange (meters)        */
   unsigned short phase;  /* 16 bits Phase angle 0-2047 represents full cycle */
   char slip;             /*  8 bits 0 = no cycle slip detected, 1 = slip */
   unsigned char snr;     /*  8 bits Signal/Noise ratio (dB??) */
   unsigned char prn;     /*  8 bits PRN-1 (0-31). Add 1 to get PRN */
   unsigned char valid;   /*  8 bits 0 = invalid data, 1 = valid data */
} garmin_ch_type;

typedef struct {
   double tow;        /* 64 bits Time of Week */
   short wn;          /* 16 bits Week Number  */
   garmin_ch_type sv[12];
} garmin_rcv_type;

typedef struct {
   float alt;   /* ellipsoid altitude in meters */
   float epe;   /* estimated position error in meters */
   float eph;   /* horizontal position error in meters */
   float epv;   /* vertical position error in meters */
   short   fix;   /* 0=nofix, 1=nofix, 2=2D fix, 3=3D fix, 4=2Ddiff, 5=3Ddiff */
   double tow; /* GPS time of week */
   /* note lat and lon seem to be mixed up in the Garmin 25LP manual (Rev C) */
   double lat;     /* Latidude in radians  */
   double lon;     /* Longitude in radians */
   float lon_vel;  /* Longitude velocity in meters/sec */
   float lat_vel;  /* Latidude velocity in meters/sec */
   float alt_vel;  /* Altidude velocity in meters/sec */
} garmin_pvt_type;


void garmin_eph_record (unsigned char *buf, eph_type *eph);
void garmin_skip_to_next_record (FILE *fp);
int  garmin_get_data_byte (FILE *fp);
void garmin_rcv_record (unsigned char *buf, garmin_rcv_type *);
void garmin_pvt_record (unsigned char *buf, garmin_pvt_type *);
