program fjf582;

var
  OK: Boolean = True;

procedure Check (a, b: SizeType; c: Char; n: Integer);
begin
  if a <> b then
    begin
      WriteLn ('failed ', c, ' ', n);
      OK := False
    end
end;

{ The n in `Integer (n)' etc. must be a compile-time constant, so we
  can't make it a `for' loop counter or so. So we use a macro here . }
{$define TEST(n)
begin
  var i: packed array [1 .. $4000] of Integer (n);
  var c: packed array [1 .. $4000] of Cardinal (n);
  var w: packed array [1 .. $4000] of Word (n);
  var b: packed array [1 .. $4000] of Boolean (n);
  Check (SizeOf (i), $800 * n, 'i', n);
  Check (SizeOf (c), $800 * n, 'c', n);
  Check (SizeOf (w), $800 * n, 'w', n);
  Check (SizeOf (b), $800 * n, 'b', n)
end}

begin
  TEST (1);
  TEST (2);
  TEST (3);
  TEST (4);
  TEST (5);
  TEST (6);
  TEST (7);
  TEST (8);
  TEST (9);
  TEST (10);
  TEST (11);
  TEST (12);
  TEST (13);
  TEST (14);
  TEST (15);
  TEST (16);
  TEST (17);
  TEST (18);
  TEST (19);
  TEST (20);
  TEST (21);
  TEST (22);
  TEST (23);
  TEST (24);
  TEST (25);
  TEST (26);
  TEST (27);
  TEST (28);
  TEST (29);
  TEST (30);
  TEST (31);
  TEST (32);
  TEST (33);
  TEST (34);
  TEST (35);
  TEST (36);
  TEST (37);
  TEST (38);
  TEST (39);
  TEST (40);
  TEST (41);
  TEST (42);
  TEST (43);
  TEST (44);
  TEST (45);
  TEST (46);
  TEST (47);
  TEST (48);
  TEST (49);
  TEST (50);
  TEST (51);
  TEST (52);
  TEST (53);
  TEST (54);
  TEST (55);
  TEST (56);
  TEST (57);
  TEST (58);
  TEST (59);
  TEST (60);
  TEST (61);
  TEST (62);
  TEST (63);
  TEST (64);
  if OK then WriteLn ('OK')
end.
