#!/usr/bin/perl
use strict;
use warnings;

# this is hardcoded; change it if needed
use lib "src/lib";
use Gitolite::Test;

# VREFs - part 2
# ----------------------------------------------------------------------

try "plan 74";

put "../gitolite-admin/conf/gitolite.conf", "
    \@gfoo = foo
    \@lead = u1
    \@senior_devs = u2 u3
    \@junior_devs = u4 u5 u6
    repo  \@gfoo

        RW+                                 =   \@all

        RW+ VREF/COUNT/2/NO_SIGNOFF         =   \@lead
        -   VREF/COUNT/2/NO_SIGNOFF         =   \@all

        -   VREF/COUNT/10/NEWFILES          =   \@junior_devs

        -   VREF/FILETYPE/AUTOGENERATED     =   \@all
";

try "
    ADMIN_PUSH vr2a
    cd ..
    # setup
    ls -al foo;                 !ok;    /cannot access foo: No such file or directory/
    CLONE u1 foo;               ok;     /Cloning into/
                                        /You appear to have cloned an empty/
    cd foo;                     ok
    ls -Al;                     ok;     /\.git/

    # u1 push 15 new files
    tc a b c d e f g h i j k l m n o
                                ok;     /d8c0392/
    PUSH u1 master;             ok;     /new branch.*master -. master/

    # u2 push 2 new 10 old without signoff
    tc a b c d e f g h i j u2a u2b
                                ok;     /6787ac9/
    PUSH u2;                    ok;     /d8c0392..6787ac9.*master -. master/

    # u2 fail to push 3 new files without signoff
    tc u2c u2d u2e;             ok;     /a74562b/
    PUSH u2;                    !ok;    /W VREF/COUNT/2/NO_SIGNOFF foo u2 DENIED by VREF/COUNT/2/NO_SIGNOFF/
                                        /top commit message should include the text .3 new files signed-off by: tester.example.com./
                                        /hook declined/
                                        /remote rejected/
    # u2 push 15 new files with signoff
    tc u2f u2g u2h u2i u2j u2k u2l u2m u2n u2o u2p u2q
                                ok;     /8dd31aa/
    git commit --allow-empty -m '15 new files signed-off by: tester\@example.com'
                                ok;     /.master 6126489. 15 new files signed-off by: tester.example.com/
    PUSH u2;                    ok;     /6787ac9..6126489.*master -. master/

    # u4 push 2 new 10 old files without signoff
    tc u4a u4b a b c d e f g h i j
                                ok;     /76c5593/
    PUSH u4;                    ok;     /6126489..76c5593.*master -. master/

    # u4 fail push 3 new files withoug signoff
    tc u4c u4d u4e;             ok;     /2a84398/
    PUSH u4;                    !ok;    /W VREF/COUNT/2/NO_SIGNOFF foo u4 DENIED by VREF/COUNT/2/NO_SIGNOFF/
                                        /top commit message should include the text .3 new files signed-off by: tester.example.com./
                                        /hook declined/
                                        /remote rejected/

    # u4 push 10 new 5 old with signoff
    tc u4f u4g u4h u4i u4j u4k u4l a b c d e
                                ok;     /09b646a/
    git commit --allow-empty -m '10 new files signed-off by: tester\@example.com'
                                ok;     /.master 47f84b0. 10 new files signed-off by: tester.example.com/
    PUSH u4;                    ok;     /76c5593..47f84b0.*master -. master/

    # u4 fail push 11 new files even with signoff
    tc u4ab u4ac u4ad u4ae u4af u4ag u4ah u4ai u4aj u4ak u4al
                                ok;     /90e7344/
    git commit --allow-empty -m '11 new files signed-off by: tester\@example.com'
                                ok;     /.master 1f36537. 11 new files signed-off by: tester.example.com/
    PUSH u4;                    !ok;    /W VREF/COUNT/10/NEWFILES foo u4 DENIED by VREF/COUNT/10/NEWFILES/
                                        /too many new files in this push/
                                        /hook declined/
                                        /remote rejected/

    # test AUTOGENERATED vref
    glt fetch u1 origin;        ok;
    reset-h origin/master;      ok;
    tc not-really.java;         ok;     /0f88b2e/
    PUSH u4;                    ok;     /47f84b0..0f88b2e.*master -. master/
";

put "|cat >> not-really.java", "
    Generated by the protocol buffer compiler.  DO NOT EDIT
";

try "
    commit -am pbc;             ok;     /b2df6ef/
    PUSH u4;                    !ok;    /W VREF/FILETYPE/AUTOGENERATED foo u4 DENIED by VREF/FILETYPE/AUTOGENERATED/
                                        /hook declined/
                                        /remote rejected/
";
