/*
 * ogg.h - header of ogg.c
 * Copyright 2002, 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Taken from ogginfo of Michael Smith <msmith@labyrinth.net.au>.
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ogg/ogg.h>
#include <vorbis/codec.h>

#define CHUNK 4500

#ifdef _WIN32
#define INT64FORMAT "%I64d"
#else
#define INT64FORMAT "%Ld"
#endif

typedef struct _stream_processor {
  void (*process_page) (struct _stream_processor *, ogg_page *);
  void (*process_end) (struct _stream_processor *);
  int isillegal;
  int shownillegal;
  int isnew;
  long seqno;
  int lostseq;

  int start;
  int end;

  int num;
  char *type;

  ogg_uint32_t serial;		/* must be 32 bit unsigned */
  ogg_stream_state os;
  void *data;
} stream_processor;

typedef struct {
  stream_processor *streams;
  int allocated;
  int used;

  int in_headers;
} stream_set;

typedef struct {
  vorbis_info vi;
  vorbis_comment vc;

  long bytes;
  ogg_int64_t lastgranulepos;

  int doneheaders;
} misc_vorbis_info;

extern int get_ogg_info (FILE * file, int *act_sec, int *act_bitrate, int *act_nominal, char **act_artist,
			 char **act_title);
