/*
 * asf.c - asf information functions for GINI
 * Copyright 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Taken from asfinfo of Arpad Gereoffy <mplayer-users@mplayerhq.hu>.
 *
 * Authors:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <stdio.h>
//#include <stdlib.h> 

#include "avi.h"
#include "asf.h"

ASF_header_t asfh;
ASF_obj_header_t objh;
ASF_file_header_t fileh;
ASF_stream_header_t streamh;
unsigned char buffer[8192];

int i;
int a_sec;

int get_asf_info (FILE * file, int *act_sec, int *act_bitrate, int *act_nominal,
		  char **act_artist, char **act_title)
{

fread(&asfh,sizeof(asfh),1,file);
//printf("[%s] %d  (subchunks: %d)\n",chunk_type(asfh.objh.guid),(int) asfh.objh.size,asfh.cno);
//printf("\n!!!!! %d !!!!!!\n",sizeof(objh));
while(fread(&objh,sizeof(objh),1,file)>0){
  int pos=ftell(file);
//  printf("0x%08X  [%s] %d\n",pos-sizeof(objh), chunk_type(objh.guid),(int) objh.size);
  switch(*((unsigned int*)&objh.guid)){
    case 0xB7DC0791: // guid_stream_header
      fread(&streamh,sizeof(streamh),1,file);
/*      printf("stream type: %s\n",chunk_type(streamh.type));
      printf("stream concealment: %s\n",chunk_type(streamh.concealment));
      printf("type: %d bytes,  stream: %d bytes  ID: %d\n",(int)streamh.type_size,(int)streamh.stream_size,(int)streamh.stream_no);
      printf("FILEPOS=0x%X\n",ftell(f));*/
      // type-specific data:
      fread(buffer,streamh.type_size,1,file);
      switch(*((unsigned int*)&streamh.type)){
      case 0xF8699E40:  // guid_audio_stream
//        print_wave_header((WAVEFORMATEX*)buffer);
        break;
      case 0xBC19EFC0:  // guid_video_stream
//        print_video_header((BITMAPINFOHEADER*)&buffer[4+4+1+2]);
        break;
      }
      // stream-specific data:
      fread(buffer,streamh.stream_size,1,file);
      break;
//    case 0xD6E229D1: return "guid_header_2_0";
    case 0x8CABDCA1: // guid_file_header
      fread(&fileh,sizeof(fileh),1,file);
//      printf("packets: %d  flags: %d  pack_size: %d  frame_size: %d ets: %d duration: %d\n",(int)fileh.packets,(int)fileh.flags,(int)fileh.packetsize,(int)fileh.frame_size,(int)fileh.end_timestamp,(int)fileh.duration);
/*    printf("creat %llu expdate %d duration %llu ets %llu\n",
    fileh.creat_time,
    (int)fileh.expdate,
    fileh.duration,
    fileh.end_timestamp);*/
		a_sec=fileh.creat_time/10000000;
      break;
/*    case 0x75b22636: // guid_data_chunk
      { int endp=pos+objh.size-sizeof(objh);
        unsigned char* packet=malloc((int)fileh.packetsize);
        int fpos;
        fseek(f,26,SEEK_CUR);
        while((fpos=ftell(f))<endp){
          fread(packet,(int)fileh.packetsize,1,f);
          if(packet[0]==0x82){
            unsigned char flags=packet[3];
            unsigned char* p=&packet[5];
            unsigned long time;
            unsigned short duration;
            int segs=1;
            int seg;
            int padding=0;
            if(flags&8){
              padding=p[0];++p;
            } else
            if(flags&16){
              padding=p[0]|(p[1]<<8);p+=2;
            }
            time=*((unsigned long*)p);p+=4;
            duration=*((unsigned short*)p);p+=2;
            if(flags&1){
              segs=p[0]-0x80;++p;
            }
            printf("%08X:  flag=%02X  segs=%d  pad=%d  time=%d  dur=%d\n",
              fpos,flags,segs,padding,time,duration);
            for(seg=0;seg<segs;seg++){
              ASF_segmhdr_t* sh=(ASF_segmhdr_t*)p;
              int len=0;
              p+=sizeof(ASF_segmhdr_t);
              if(sh->flag&8) p+=8;// else
              if(sh->flag&1) ++p;
              if(flags&1){
                len=*((unsigned short*)p);p+=2;
              }
              printf("  seg #%d: streamno=%d  seq=%d  flag=%02X  len=%d\n",seg,sh->streamno&0x7F,sh->seq,sh->flag,len);
              p+=len;
            }
          } else
            printf("%08X:  UNKNOWN  %02X %02X %02X %02X %02X...\n",fpos,packet[0],packet[1],packet[2],packet[3],packet[4]);
        }
      }
      break;*/

//    case 0x33000890: return "guid_index_chunk";

  }
  fseek(file,pos+objh.size-sizeof(objh),SEEK_SET);
}

	
	rewind(file);

  *act_sec = a_sec;
  *act_bitrate = 0;
  *act_nominal = 0;

  return 0;
}
