/*
 ============================================================================
 Name		: BenchmarkAppView.cpp
 Author	  : Konstantin Knizhnik
 Copyright   : GigaBASE is freeware
 Description : Application view implementation
 ============================================================================
 */

// INCLUDE FILES
#include <coemain.h>
#include "BenchmarkAppView.h"

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CBenchmarkAppView::NewL()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CBenchmarkAppView* CBenchmarkAppView::NewL(const TRect& aRect)
	{
	CBenchmarkAppView* self = CBenchmarkAppView::NewLC(aRect);
	CleanupStack::Pop(self);
	return self;
	}

// -----------------------------------------------------------------------------
// CBenchmarkAppView::NewLC()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CBenchmarkAppView* CBenchmarkAppView::NewLC(const TRect& aRect)
	{
	CBenchmarkAppView* self = new (ELeave) CBenchmarkAppView;
	CleanupStack::PushL(self);
	self->ConstructL(aRect);
	return self;
	}

// -----------------------------------------------------------------------------
// CBenchmarkAppView::ConstructL()
// Symbian 2nd phase constructor can leave.
// -----------------------------------------------------------------------------
//
void CBenchmarkAppView::ConstructL(const TRect& aRect)
	{
	// Create a window for this application view
	CreateWindowL();

	// Set the windows size
	SetRect(aRect);

	// Activate the window, which makes it ready to be drawn
	ActivateL();
	}

// -----------------------------------------------------------------------------
// CBenchmarkAppView::CBenchmarkAppView()
// C++ default constructor can NOT contain any code, that might leave.
// -----------------------------------------------------------------------------
//
CBenchmarkAppView::CBenchmarkAppView()
	{
	// No implementation required
	}

// -----------------------------------------------------------------------------
// CBenchmarkAppView::~CBenchmarkAppView()
// Destructor.
// -----------------------------------------------------------------------------
//
CBenchmarkAppView::~CBenchmarkAppView()
	{
	// No implementation required
	}

// -----------------------------------------------------------------------------
// CBenchmarkAppView::Draw()
// Draws the display.
// -----------------------------------------------------------------------------
//
void CBenchmarkAppView::Draw(const TRect& /*aRect*/) const
	{
	// Get the standard graphics context
	CWindowGc& gc = SystemGc();

	// Gets the control's extent
	TRect drawRect(Rect());

	// Clears the screen
	gc.Clear(drawRect);

	}

// -----------------------------------------------------------------------------
// CBenchmarkAppView::SizeChanged()
// Called by framework when the view size is changed.
// -----------------------------------------------------------------------------
//
void CBenchmarkAppView::SizeChanged()
	{
	DrawNow();
	}

// -----------------------------------------------------------------------------
// CBenchmarkAppView::HandlePointerEventL()
// Called by framework to handle pointer touch events.
// Note: although this method is compatible with earlier SDKs, 
// it will not be called in SDKs without Touch support.
// -----------------------------------------------------------------------------
//
void CBenchmarkAppView::HandlePointerEventL(const TPointerEvent& aPointerEvent)
	{

	// Call base class HandlePointerEventL()
	CCoeControl::HandlePointerEventL(aPointerEvent);
	}

// End of File
