/*
 * Public Release 3
 * 
 * $Id: krt_rtread_sioc.c,v 1.5 1999/02/17 23:31:12 cwr Exp $
 */
/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996,1997,1998,1999 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP, UC Berkeley's routing
 * daemon	 (routed), and DCN's HELLO routing Protocol.
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


#define       INCLUDE_ROUTE
#define       INCLUDE_IOCTL
#define       INCLUDE_IF
#include <stropts.h>
#include "include.h"
#ifdef        PROTO_INET
#include "inet.h"
#endif        /* PROTO_INET */
#ifdef        PROTO_ISO
#include "iso.h"
#endif        /* PROTO_ISO */
#include "krt.h"
#include "krt_var.h"


/* Use the ioctl() system call to read the routing table(s) */
/*ARGSUSED*/
int
krt_rtread __PF1(tp, task *)
{
    size_t size, alloc_size;
    caddr_t kbuf;
    rt_parms rtparms;
    struct strioctl ioc;
    struct rtrecord *krt;
    if_addr *ifap;

    trace_only_tp(tp,
                TRC_NL_BEFORE,
                ("krt_rtread: Initial routes read from kernel (via socket ioctl)"));

    bzero((caddr_t) &rtparms, sizeof (rtparms));
    rtparms.rtp_n_gw = 1;

    ioc.ic_cmd = SIOCGRTSIZ;
    ioc.ic_timout = 0;
    ioc.ic_len = 0;
    ioc.ic_dp = 0;
    if ((alloc_size = ioctl(tp->task_socket, I_STR, &ioc)) < 0) {
      trace_log_tp(tp,
                   0,
                   LOG_ERR,
                   ("krt_rtread: ioctl for routing table estimate: %m"));
      return errno;
    }
    if (alloc_size < 0) {
      errno = EINVAL;
      trace_log_tp(tp,
                   0,
                   LOG_ERR,
                   ("krt_rtread: routing table estimate: %m"));
      return errno;
    }
    if (alloc_size == 0) {
      goto end;
    }
    trace_tp(tp,
           TR_STATE,
           0,
           ("krt_rtread: routing table estimates %d entries needed",
            alloc_size));
    size = ROUNDUP(alloc_size * sizeof(struct rtrecord), task_pagesize);
    kbuf = (caddr_t) task_block_malloc(size);
    ioc.ic_cmd = SIOCGRTTAB;
    ioc.ic_timout = 0;
    ioc.ic_len = size;
    ioc.ic_dp = (char *)kbuf;
    if ((alloc_size = ioctl(tp->task_socket, I_STR, &ioc)) < 0) {
      trace_log_tp(tp,
                   0,
                   LOG_ERR,
                   ("krt_rtread: routing table retrieve: %d, %m", size));
      task_block_reclaim(size, kbuf);
      return errno;
    }

    krt = (struct rtrecord *) kbuf;
    for ( ; alloc_size ; alloc_size--, krt++ ) {

      {
          struct sockaddr_in *addr;

          addr = (struct sockaddr_in *) &krt->rt_dst;
          addr->sin_family = AF_INET;
          addr->sin_port = 0;
          bzero((caddr_t) addr->sin_zero, sizeof (addr->sin_zero));

          addr = (struct sockaddr_in *) &krt->rt_gateway;
          addr->sin_family = AF_INET;
          addr->sin_port = 0;
          bzero((caddr_t) addr->sin_zero, sizeof (addr->sin_zero));
      }

     rtparms.rtp_dest = sock2gated(&krt->rt_dst, unix_socksize(&krt->rt_dst));

      rtparms.rtp_router = sock2gated(&krt->rt_gateway, unix_socksize(&krt->rt_gateway));
      rtparms.rtp_state = krt_flags_to_state((flag_t) krt->rt_flags);
      if (BIT_TEST(krt->rt_flags, RTF_HOST)) {
          rtparms.rtp_dest_mask = sockhostmask(rtparms.rtp_dest);
      } else if ((ifap = if_withdstaddr(rtparms.rtp_dest))
              || (ifap = inet_ifwithnet(rtparms.rtp_dest))) {
          rtparms.rtp_dest_mask = ifap->ifa_netmask;
      } else {
          rtparms.rtp_dest_mask = inet_mask_natural(rtparms.rtp_dest);
      }
      krt_rtread_add(tp,
                     &rtparms,
                     (flag_t) krt->rt_flags,
                     FALSE,
                     "REMNANT");

    }
    task_block_reclaim(size, kbuf);
end:

    return 0;
}
