/*
  setup.h
  
  for GalaXa
  
  by Bill Kendrick
  kendrick@zippy.sonoma.edu
  http://zippy.sonoma.edu/kendrick/
  
  April 6, 1998 - April 20, 1998
  */


#define BETTER_GRAPHICS
#define USE_BACKBUFFER


/* Speed: */

#define FRAMERATE 20000


/* Size defines: */

#define WIDTH 320
#define HEIGHT 400

#define MAX_COLORS 512


/* Objects: */

#define OBJ_0 0        /* objects 0-9 are digits 0-9 */
#define OBJ_TITLE 10
#define OBJ_BULLET 11
#define OBJ_ALIENBULLET 12
#define OBJ_SHIP_0 13  /* objects 13-20 are ship0 */
#define OBJ_SHIP_1 21  /* objects 21-28 are ship1 */
#define OBJ_ALIEN_0 29 /* objects 29-37 are alien0 */
#define OBJ_ALIEN_1 38 /* objects 38-46 are alien1 */
#define OBJ_ALIEN_2 47 /* objects 47-55 are alien2 */
#define OBJ_ALIEN_3 56 /* objects 56-64 are alien3 */
#define OBJ_ALIEN_4 65 /* objects 65-73 are alien4 */
#define OBJ_ALIEN_5 74 /* objects 74-82 are alien5 */
#define OBJ_GIANT_0 83
#define OBJ_GIANT_1 84
#define OBJ_TRACTORBEAM 85
#define OBJ_CREDITS 86
#define OBJ_ASTEROID_A 87 /* objects 87-91 are asteroid-a */
#define OBJ_ASTEROID_B 92 /* objects 92-96 are asteroid-b */
#define OBJ_EXPLODE 97    /* objects 97-101 are explosion */
#define OBJ_PLANET_0 102  /* objects 102-105 are planets */
#define NUM_OBJECTS 106

#define NUM_EXPLODE_SHAPES OBJ_PLANET_0 - OBJ_EXPLODE
#define NUM_PLANET_SHAPES NUM_OBJECTS - OBJ_PLANET_0

static char * object_names[NUM_OBJECTS] =
{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
 "galaxa", "bullet", "alienbullet",
 "ship_0_0", "ship_0_1", "ship_0_2", "ship_0_3",
 "ship_0_4", "ship_0_5", "ship_0_6", "ship_0_7",
 "ship_1_0", "ship_1_1", "ship_1_2", "ship_1_3",
 "ship_1_4", "ship_1_5", "ship_1_6", "ship_1_7",
 "alien_0_0", "alien_0_1", "alien_0_2", "alien_0_3",
 "alien_0_4", "alien_0_5", "alien_0_6", "alien_0_7", "alien_0_0b",
 "alien_1_0", "alien_1_1", "alien_1_2", "alien_1_3",
 "alien_1_4", "alien_1_5", "alien_1_6", "alien_1_7", "alien_1_0b",
 "alien_2_0", "alien_2_1", "alien_2_2", "alien_2_3",
 "alien_2_4", "alien_2_5", "alien_2_6", "alien_2_7", "alien_2_0b",
 "alien_3_0", "alien_3_1", "alien_3_2", "alien_3_3",
 "alien_3_4", "alien_3_5", "alien_3_6", "alien_3_7", "alien_3_0b",
 "alien_4_0", "alien_4_1", "alien_4_2", "alien_4_3",
 "alien_4_4", "alien_4_5", "alien_4_6", "alien_4_7", "alien_4_0b",
 "alien_5_0", "alien_5_1", "alien_5_2", "alien_5_3",
 "alien_5_4", "alien_5_5", "alien_5_6", "alien_5_7", "alien_5_0b",
 "giant0", "giant1",
 "tractorbeam",
 "credits",
 "asteroid_a0", "asteroid_a1", "asteroid_a2", "asteroid_a3", "asteroid_a4",
 "asteroid_b0", "asteroid_b1", "asteroid_b2", "asteroid_b3", "asteroid_b4",
 "explode0", "explode1", "explode2", "explode3", "explode4",
 "planet0", "planet1", "planet2", "planet3"
};


#define SND_INTRO 0
#define SND_TRACTORBEAM 1
#define SND_CAPTURE 2
#define SND_SHOT 3
#define SND_KILL 4
#define SND_BUZZ 5
#define SND_FLASH 6
#define SND_NEXTLEVEL 7
#define SND_HURT 8
#define SND_FIREWORKS 9
#define SND_WELCOME 10
#define NUM_SOUNDS 11

static char * sounds[] = {
  "sounds/intro.au", "sounds/tractorbeam.au", "sounds/capture.au",
  "sounds/shot.au", "sounds/kill.au", "sounds/buzz.au",
  "sounds/flash.au", "sounds/nextlevel.au", "sounds/hurt.au",
  "sounds/fireworks.au", "sounds/welcome.au"
};


typedef struct color_type {
  unsigned int red;
  unsigned int green;
  unsigned int blue;
  unsigned long pixel;
  int owner;
} color_type;


#define NUM_EXPLOSION_COLORS 3

static char * explosioncolors[] = {"red", "orange", "yellow"};


/* X-Window Globals: */

char server[512];
Display * display;
Colormap colormap;
Window window, root;
Pixmap backbuffer;
GC whitegc, blackgc, greygc;
GC explosiongcs[NUM_EXPLOSION_COLORS];
int screen, black, white, num_seen_colors, good_depth;
color_type color_list[MAX_COLORS];
Visual * temp_visual;
XFontStruct * font;
int fh;


/* Globals: */

FILE * sound_fs;
Pixmap object_pixmap[NUM_OBJECTS],
  object_mask[NUM_OBJECTS];
GC object_gc[NUM_OBJECTS];
Pixmap backbuffer, background;
int greymode;
int object_width[NUM_OBJECTS], object_height[NUM_OBJECTS];
int xms[8], yms[8];


/* setup prototypes: */

int setup(int argc, char * argv[]);
void Xsetup(void);
void shutdown(void);
GC CreateGC(unsigned long fore);
int SetUpVisual(Display *display, int screen, Visual **visual, int *depth);
void drawshape(int x, int y, int shape, Drawable d);
void color_clear(void);
int color_seen(unsigned int red, unsigned int green, unsigned int blue);
int color_add(unsigned int red, unsigned int green, unsigned int blue,
	      unsigned long pixel, int owner);
void updatebackbuffer(void);
void copybackgroundtobackbuffer(void);
void loadobject(int i);
unsigned long AllocNamedColor(Display *display, Colormap colormap,
                              char* colorname, unsigned long default_color);
