
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

#include "runtime.h"


/* cpu_time_4()-- CPU_TIME() kind 4 */

#define cpu_time_4 prefix(cpu_time_4)

void cpu_time_4(float *time) {
struct rusage ru;

    *time = (getrusage(RUSAGE_SELF, &ru) < 0)
	? -1.0
	: ru.ru_utime.tv_sec + ru.ru_stime.tv_sec
	+ 1.0e-6*(ru.ru_utime.tv_usec + ru.ru_stime.tv_usec);
}


/* cpu_time_8()-- CPU_TIME() kind 8 */

#define cpu_time_8 prefix(cpu_time_8)

void cpu_time_8(double *time) {
struct rusage ru;
   
    *time = (getrusage(RUSAGE_SELF, &ru) < 0)
	? -1.0
	: ru.ru_utime.tv_sec + ru.ru_stime.tv_sec
	+ 1.0e-6*(ru.ru_utime.tv_usec + ru.ru_stime.tv_usec);
}


#if HAVE_REAL_10

#define cpu_time_10 prefix(cpu_time_10)

void cpu_time_10(char *time) {
struct rusage ru;
double t, *p;
   
    t = (getrusage(RUSAGE_SELF, &ru) < 0)
	? -1.0
	: ru.ru_utime.tv_sec + ru.ru_stime.tv_sec
	+ 1.0e-6*(ru.ru_utime.tv_usec + ru.ru_stime.tv_usec);

    p = &t;

    asm("mov %1, %" EAX "\n"
	"fldl  ( %" EAX ")\n"
	"mov %0, %" EAX "\n"
	"fstpt ( %" EAX ")\n" : "=m" (time) : "m" (p) : EAX );
}

#endif
