
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


/* Implement the SELECT statement for character variables. */

#include "runtime.h"


typedef struct {
    G95_DINT low_len;   char *low;
    G95_DINT high_len;  char *high;  

    G95_DINT target;
} select_struct;


typedef struct {
    G95_DINT label, len;
    char *pointer;
} label_struct;



/* select_string()-- Given a selector string and a table of
 * select_struct structures, return the table index to jump to.
 * Returns -1 if no match. */

#define select_string prefix(select_string)

G95_DINT select_string(select_struct *table, G95_DINT table_len,
		       char *selector, G95_DINT selector_len) {
G95_DINT i, low, high, mid, target;
select_struct *t;

    target = -1;
    if (table_len == 0)
	return target;

    /* Record the default address if present */

    if (table->low == NULL && table->high == NULL) {
	target = table->target;

	table++;
	table_len--;
	if (table_len == 0)
	    return target;
    }

    /* Try the high and low bounds if present. */

    if (table->low == NULL) {
	if (compare_string(table->high, table->high_len,
			   selector, selector_len) >= 0)
	    return table->target;

	table++;
	table_len--;
	if (table_len == 0)
	    return target;
    }

    t = table + table_len - 1;

    if (t->high == NULL) {
	if (compare_string(t->low, t->low_len,
			   selector, selector_len) <= 0)
	    return t->target;

	table_len--;
	if (table_len == 0)
	    return target;
    }

    /* At this point, the only table entries are bounded entries.  Find
     * the right entry with a binary chop. */

    low = -1;
    high = table_len;

    while(low+1 < high) {
	mid = (low + high) / 2;

	t = table + mid;
	i = compare_string(t->low, t->low_len, selector, selector_len);

	if (i == 0)
	    return t->target;

	if (i < 0)
	    low = mid;
	else
	    high = mid;
    }

    /* The string now lies between the low indexes of the now-adjacent
     * high and low entries.  Because it is less than the low entry of
     * 'high', it can't be that one.  If low is still -1, then no
     * entries match.  Otherwise, we have to check the high entry of
     * 'low'. */

    if (low == -1)
	return target;

    t = table + low;
    if (compare_string(selector, selector_len,
		       t->high, t->high_len) <= 0)
	return t->target;

    return target;
}



/* select_label()-- Select a label. */

#define select_label prefix(select_label)

char *select_label(G95_DINT label, label_struct *p) {
char message[100];

    for(;;) {
	if (p->label == 0) {
	    st_sprintf(message, "Label %d not found", label);
	    runtime_error(message);
	}

	if (p->label == label)
	    break;

	p++;
    }

    if (p->len != -1) {
	ioparm->format = p->pointer;
	ioparm->format_len = p->len;
	return NULL;
    }

    return p->pointer;
}
