
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the transfer() intrinsic.  There are two possibilities
 * here: transfer1 is for a scalar source, while transfer2 is from an
 * array source. */

#include "runtime.h"
#include <string.h>


#define transfer1 prefix(transfer1)

g95_array_descriptor *transfer1(char *source, g95_array_descriptor *mold,
				G95_DINT *size, G95_DINT *source_size) {
g95_array_descriptor *r;
G95_AINT s;

    if (size != NULL)
	s = *size;
    else
	s = (*source_size + mold->element_size - 1) / mold->element_size;

    r = temp_array(1, mold->element_size, s);
    memcpy(r->base, source, *source_size);

    return r;
}


#define transfer2 prefix(transfer2)

g95_array_descriptor *transfer2(g95_array_descriptor *source,
				g95_array_descriptor *mold, G95_DINT *size) {
G95_AINT n, s, extent, x[G95_MAX_DIMENSIONS];
g95_array_descriptor *r;
char *p, *q;
int i;

    if (size != NULL)
	s = *size;
    else {
	s = source->element_size;

	for(i=0; i<source->rank; i++) {
	    extent = source->info[i].ubound - source->info[i].lbound;
	    if (extent < 0)
		extent = 0;

	    s *= extent;
	}

	s = (s + mold->element_size - 1) / mold->element_size;
    }

    r = temp_array(1, mold->element_size, s);
    if (s == 0)
	return r;

    n = mold->element_size * s;   /* Size of destination buffer */

    for(i=0; i<source->rank; i++)
	x[i] = source->info[i].lbound;

    p = r->base;

    /* Copy source bytes into the destination.  The source might not be
     * contiguous, and we don't have to worry about association. */

    for(;;) {
	q = source->base;
	for(i=0; i<source->rank; i++)
	    q += source->info[i].mult * x[i];

	if (n > source->element_size) {
	    memcpy(p, q, source->element_size);
	    n -= source->element_size;
	} else {
	    memcpy(p, q, n);
	    break;    /* Dest array is full */
	}

	if (bump_element(source, x))
	    break;
    }

    return r;
}
