
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include "runtime.h"

#define scan prefix(scan)


/* scan_forward()-- Scan in the forward direction */

static int scan_forward(char *string, G95_DINT string_len, char *set,
			G95_DINT set_len) {
char c, *p, *q;
G95_DINT i, j;

    p = string;
    for(i=1; i<=string_len; i++) {
	c = *p++;

	q = set;
	for(j=0; j<set_len; j++)
	    if (c == *q++)
		return i;
    }

    return 0;
}


/* scan_backward()-- Scan in the backwards direction */

static int scan_backward(char *string, G95_DINT string_len,
			 char *set,    G95_DINT set_len) {
char c, *p, *q;
G95_DINT i, j;

    p = string + string_len - 1;
    for(i=string_len; i>0; i--) {
	c = *p--;

	q = set;
	for(j=0; j<set_len; j++)
	    if (c == *q++)
		return i;
    }

    return 0;
}


/* scan()-- Implement the SCAN intrinsic */

#define scan_1 prefix(scan_1)

int scan_1(char *string, char *set, G95_DINT *back, G95_DINT string_len,
	   G95_DINT set_len) {

    return (back == NULL || !(*back))
	? scan_forward(string,  string_len, set, set_len)
	: scan_backward(string, string_len, set, set_len);
}
