
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by David Miles

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

#include <windows.h>
#include "runtime.h"


/* dump_num()-- Function to dump a decimal number with a fixed number
 * of digits into a buffer. */

static void dump_num(int n, int digits, char *buffer) {

    buffer += digits;

    while(digits > 0) {
	buffer--;
	*buffer = '0' + (n % 10);

	n = n / 10;
	digits--;
    }
}


/* date_and_time()-- DATE_AND_TIME intrinsic */

#define date_and_time prefix(date_and_time)

void date_and_time(char *date, char *time, char *zone, 
		   g95_array_descriptor *values,
		   G95_DINT date_len, G95_DINT time_len, G95_DINT zone_len) {
char date0[8], time0[10], zone0[5];
TIME_ZONE_INFORMATION tz;
SYSTEMTIME now;
int bias, i, m;
char *p;

    GetLocalTime(&now);

    switch(GetTimeZoneInformation(&tz)) {
    case TIME_ZONE_ID_STANDARD: bias = -(tz.Bias + tz.StandardBias); break;
    case TIME_ZONE_ID_DAYLIGHT: bias = -(tz.Bias + tz.DaylightBias); break;
    default:                    bias = -tz.Bias;                     break;
    }

    /* Date */

    m = now.wYear*10000 + now.wMonth*100 + now.wDay;
    dump_num(m, 8, date0);

    /* Time */

    m = now.wHour*10000 + now.wMinute*100 + now.wSecond;
    dump_num(m, 6, time0);

    time0[6] = '.';

    dump_num(now.wMilliseconds, 3, time0+7);

    if (bias >= 0) {
	zone0[0] = '+';
	m = bias;
    } else {
	zone0[0] = '-';
	m = -bias;
    }

    m = 100*(m / 60) + (m % 60);
    dump_num(m, 4, zone0+1);

    /* Dump values */

    if (date != NULL) copy_string(date, date_len, date0, 8);
    if (time != NULL) copy_string(time, time_len, time0, 10);
    if (zone != NULL) copy_string(zone, zone_len, zone0, 5);

    if (values != NULL)
	for(i=1; i<=8; i++) {
	    switch(i) {
	    case 1:  m = now.wYear;               break;
	    case 2:  m = now.wMonth;              break;
	    case 3:  m = now.wDay;                break;
	    case 4:  m = bias;                    break;
	    case 5:  m = now.wHour;               break;
	    case 6:  m = now.wMinute;             break;
	    case 7:  m = now.wSecond;             break;
	    case 8:  m = now.wMilliseconds;       break;
	    }

	    p = values->offset + i*values->info[0].mult;
	    set_integer(m, p, values->element_size);
	}
}
