
## Some of the code here is transliterated from the x87 glibc code
## originally written by J.T. Conklin and Ulrich Drepper.



#if HAVE_REAL_10 == 3

#define PARM1	%rdi
#define PARM2	%rsi
#define PARM3	%rdx
#define REGAX	%rax
#define REGDX	%rdx
#define SP	%rsp
#define IMAG	16

#define SIGNX_AL   movsx %al, %rax
#define SIGNX_AX   movsx %ax, %rax

#define HALF       half(%rip)
#define INFINITY   infinity(%rip)

#else

#define PARM1	4(%esp)
#define PARM2	8(%esp)
#define PARM3   12(%esp)
#define REGAX	%eax
#define REGDX	%edx
#define SP	%esp
#define IMAG	12

## The apple assembler is so old on some platforms that the "movsx"
## instruction isn't there.

#define SIGNX_AL   movsbl %al, %eax
#define SIGNX_AX   movswl %ax, %eax

#define HALF half
#define INFINITY infinity	

#endif


#if defined(__APPLE__) || HAVE_REAL_10 == 2
#define PUBLIC(x) .globl __ ## x ;  __ ## x:
#else
#define PUBLIC(x) .globl _ ## x	; .type _ ## x , @function ;  _ ## x:
#endif


.text

half:		.long	0x3f000000      # Single precision 0.5.
infinity:	.long	0x7f800000      # Single precision infinity.

	
## mag-- Compute the magnitude of the complex number on the TOS.
## Pops the original numbers and leaves the result on TOS.  We use the formula:
## |(r,c)| = max(r,c) sqrt(1 + (min(r,c)/max(r,c))^2), making exceptions
## for zeros and infinities.

mag:	fabs			# |r| . c
	fxam
	fstsw
	andb	$0x47, %ah
	cmpb	$0x05, %ah
	jnz	0f		# Not +infinity

	fxch	%st(1)
	fstp	%st
	ret

0:	fxch	%st(1)		# c . |r|
	fabs			# |c| . |r|
	fxam
	fstsw
	andb	$0x47, %ah
	cmpb	$0x05, %ah
	jnz	1f		# Not +infinity

	fxch	%st(1)
	fstp	%st
	ret

1:	fcom	%st(1)		# |c| . |r|
	fstsw
	testb	$01, %ah
	jnz	2f
	fxch	%st(1)

2:	fxam			# min(|c|, |r|) . max(|c|, |r|)
	fstsw
	andb	$0x45, %ah
	cmpb	$0x40, %ah
	jnz	3f

## min == 0, so mag == max.  This test is necessary to deal with the
## (0.0, 0.0) case.

	fstp	%st
	ret

## Do the general magnitude calculation

3:	fdiv	%st(1)		# min/max . max
	fmul	%st		# (min/max)^2 . max
	fld1			# 1 . (min/max)^2 . max
	faddp	%st(1)		# 1+(min/max)^2 . max
	fsqrt			# sqrt(1+(min/max)^2) . max
	fmulp	%st(1)		# max*sqrt(1+(min/max)^2)
	ret			# mag


PUBLIC(g95_abs_z10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	fldt	IMAG(REGDX)
	jmp	mag


PUBLIC(g95_acos_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)                 # x
	fld	%st                     # x . x
	fmul	%st(0)                  # x^2 . x
	fld1                            # 1 . x^2 . x
	fsubp                           # 1-x^2 . x
	fsqrt                           # sqrt(1-x^2) . x
	fxch	%st(1)                  # x . sqrt(1-x^2)
	fpatan                          # atan(sqrt(1-x^2) / x)
	ret


## Because the values are returned in %st, all of these are the same subroutine

PUBLIC(g95_aint4_10)
PUBLIC(g95_aint8_10)
PUBLIC(g95_aint10_10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	sub	$8, SP
	fnstcw	4(SP)
	movw	$0xf7f, (SP)
	fldcw	(SP)
	frndint
	fldcw	4(SP)
	add	$8, SP
	ret


PUBLIC(g95_aint10_8)
	mov	PARM1, REGDX
	fldl	(REGDX)
	sub	$8, SP
	fnstcw	4(SP)
	movw	$0xf7f, (SP)
	fldcw	(SP)
	frndint
	fldcw	4(SP)
	add	$8, SP
	ret
		

PUBLIC(g95_aint10_4)
	mov	PARM1, REGDX
	flds	(REGDX)
	sub	$8, SP
	fnstcw	4(SP)
	movw	$0xf7f, (SP)
	fldcw	(SP)
	frndint
	fldcw	4(SP)
	add	$8, SP
	ret


PUBLIC(g95_anint4_10)
PUBLIC(g95_anint8_10)
PUBLIC(g95_anint10_10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	jmp 0f


PUBLIC(g95_anint10_8)
	mov	PARM1, REGDX
	fldl	(REGDX)
	jmp 0f


PUBLIC(g95_anint10_4)
	mov	PARM1, REGDX
	flds	(REGDX)       # x

0:	sub	$8, SP
	fnstcw	4(SP)
	movw	$0xf7f, (SP)

	fldcw   (SP)          # x
	fxam
	fnstsw  %ax
	flds	HALF          # 0.5 . x
	test    $0x02, %ah
	je      1f
	fchs                  # -0.5 . x

1:	faddp                 # x +/- 0.5
	frndint
	fldcw   4(SP)
	add     $8, SP
	ret


PUBLIC(g95_asin_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)         # x
	fld	%st             # x . x
        fmul	%st(0)          # x^2 . x
        fld1                    # 1 . x^2 . x
        fsubp                   # 1 - x^2 . x
        fsqrt                   # sqrt(1 - x^2) . x
        fpatan                  # atan(x / sqrt(1 - x^2))
        ret
	
	
PUBLIC(g95_atan_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	fld1
	fpatan
	ret


PUBLIC(g95_atan2_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	mov	PARM2, REGDX
	fldt	(REGDX)
	fpatan
	ret


PUBLIC(g95_ceiling_1_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	sub	$8, SP
	fnstcw	4(SP)
	movw	$0xb7f, (SP)
	fldcw	(SP)
	frndint
	fldcw	4(SP)
	fistp	(SP)
	mov	(SP), %al
	SIGNX_AL
	add	$8, SP
	ret


PUBLIC(g95_ceiling_2_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	sub	$8, SP
	fnstcw	4(SP)
	movw	$0xb7f, (SP)
	fldcw	(SP)
	frndint
	fldcw	4(SP)
	fistp	(SP)
	mov	(SP), %ax
	SIGNX_AX
	add	$8, SP
	ret


PUBLIC(g95_ceiling_4_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	sub	$8, SP
	fnstcw	4(SP)
	movw	$0xb7f, (SP)
	fldcw	(SP)
	frndint
	fldcw	4(SP)
	fistpl	(SP)
	movl	(SP), %eax
	add	$8, SP
	ret


PUBLIC(g95_ceiling_8_r10)
	mov	PARM1, REGDX
	fldt    (REGDX)
	sub     $8, SP
	fnstcw  4(SP)
	movw    $0xb7f, (SP)
	fldcw   (SP)
	frndint
	fldcw   4(SP)
	fistpll (SP)
	movl    (SP), %eax
	movl    4(SP), %edx
	add     $8, SP
	ret
	

# exp_10: Compute e^x = 2^(x * log2(e)), of the TOS.

exp_10:	fxam                            # Is NaN or +-Inf? 
	fstsw   %ax
	movb    $0x45, %ch
	andb    %ah, %ch
	cmpb    $0x05, %ch
	je      1f                      # Is +-Inf, jump. 
	fldl2e
	fmulp                           # x * log2(e)
	fld     %st
	frndint                         # int(x * log2(e))
	fsubr   %st,%st(1)              # fract(x * log2(e))
	fxch
	f2xm1                           # 2^(fract(x * log2(e))) - 1
	fld1
	faddp                           # 2^(fract(x * log2(e)))
	fscale                          # e^x
	fstp    %st(1)
	ret

1:	test    $0x02, %ah              # Test sign. 
	jz      2f                      # If positive, jump. 
	fstp    %st
	fldz                            # Set result to 0. 
2:	ret



# expm1_10: Compute e^x - 1 of the TOS.  Slightly modified from glibc.

expm1_10:
	fxam                            # Is NaN or +-Inf?
	fstsw   %ax
	movb    $0x45, %al
	andb    %ah, %al
	cmpb    $0x05, %al
	je      1f                      # Is +-Inf, jump. 

	sub	$8, SP
	fnstcw	4(SP)
	movw	$0x37f, (SP)
	fldcw	(SP)

	fldl2e
	fmulp                           # x * log2(e)
	fld     %st
	frndint                         # int(x * log2(e))
	fsubr   %st,%st(1)              # fract(x * log2(e))
	fxch	%st(1)
	f2xm1                           # 2^(fract(x * log2(e))) - 1
	fscale                          # e^x
	fxch	%st(1)
        fld1
        fscale
	fld1
	fsubp	%st(1)
        fstp    %st(1)
        fsubrp  %st, %st(1)

	fldcw	4(SP)
	add	$8, SP
	ret

1:	test    $0x02, %ah              # Test sign. 
	jz      2f                      # If positive, jump. 
	fstp    %st
	fld1                            # Set result to -1
	fchs
2:	ret




# Hyperbolic cosine:

# |x| in [0     , ln2/2 )  cosh(x) = 1 + E^2 / (2 exp(x)) where E = exp(x)-1
# |x| in [ln2/2 ,    22 )  cosh(x) = 0.5 * (exp(x) + 1/exp(x))
# |x| in [    22, 11356 )  cosh(x) = 0.5 * exp(x)
# |x| in [ 11356, 11358 )  cosh(x) = (0.5 * exp(x/2)) * exp(x/2)
# |x| >= 11358             cosh(x) = +Inf
	
cosh_10:
	fabs
	fxam
	fstsw	%ax

	movb	$0x45, %al
	andb	%ah, %al
	cmpb	$0x05, %al
	jne	0f
	ret

# Finite x
0:	sub	$16, SP

	fldln2			# ln2
	fmuls	HALF		# 0.5*ln2

	fcomp	%st(1)
	fstsw	%ax
	testb	$0x41, %ah
	jz	1f

	movl	$22, (SP)
	ficoml	(SP)
	fstsw	%ax
	testb	$0x41, %ah
	jnz	2f

	movl	$11356, (SP)
	ficoml	(SP)
	fstsw	%ax
	testb	$0x41, %ah
	jnz	3f

	movl	$11358, (SP)
	ficoml	(SP)
	fstsw	%ax
	testb	$0x41, %ah
	jnz	4f

# Load infinity

	fstp	%st
	flds	INFINITY
	jmp	5f

# Case 1: 1 + E^2 / (2 exp(x))

1:	fld	%st		# x . x
	call	expm1_10	# E . x
	fmul	%st		# E^2 . x
	fxch	%st(1)		# x . E^2
	call	exp_10		# exp(x) . E^2
	fadd	%st		# 2 exp(x) . E^2
	fdivrp	%st(1)		# E^2 / (2*exp(x))
	fld1			# 1 . E^2 / (2*exp(x))
	faddp	%st(1)		# 1 + E^2 / (2*exp(x))
	jmp	5f

# Case 2:  cosh(x) = 0.5 * (exp(x) + 1 / exp(x))
	
2:	call	exp_10		# exp(x)
	fld	%st		# exp(x) . exp(x)
	fld1			# 1 . exp(x) . exp(x)
	fdivp	%st(1)		# 1/exp(x) . exp(x)
	faddp	%st(1)		# 1/exp(x) + exp(x)
	fmuls	HALF		# cosh(x)
	jmp	5f

# Case 3:  cosh(x) = 0.5 * exp(x)
	
3:	call	exp_10		# exp(x)
	fmuls	HALF		# 0.5*exp(x)
	jmp	5f

# Case 4:  cosh(x) = (0.5*exp(0.5*x)) * exp(0.5*x)

4:	fmuls	HALF		# 0.5*x
	call	exp_10		# exp(0.5*x)
	fld	%st		# exp(0.5*x) . exp(0.5*x)
	fmuls	HALF		# 0.5*exp(0.5*x) . exp(0.5*x)
	fmulp	%st(1)		# (0.5*exp(0.5*x))*(exp(0.5*x))

5:	add	$16, SP
	ret


# sinh()-- Compute sinh(x).
#  |x| in [0,        24] sinh(x) = 0.5*(E + E/(E+1)) where E = exp(x) - 1.
#  |x| in (24,    11356] sinh(x) = sign(x) * 0.5*exp(|x|)
#  |x| in (11356, 11358] sinh(x) = sign(x) * (0.5*exp(|x|/2)) * exp(|x|/2)
#  |x| > 11358           sinh(x) = sign(x) * Inf

sinh_10:fxam
	fstsw	%ax

	movb	$0x45, %al
	andb	%ah, %al
	cmpb	$0x05, %al
	jne	0f
	ret

0:	fabs		     # |x|
	sub	$16, SP
	mov	%ah, %cl     # Bit 2 of cl holds the sign bit of x

	movl	$24, (SP)
	ficoml	(SP)
	fstsw	%ax
	testb	$0x41, %ah
	jnz	1f

	movl	$11356, (SP)
	ficoml	(SP)
	fstsw	%ax
	testb	$0x41, %ah
	jnz	2f

	movl	$11358, (SP)
	ficoml	(SP)
	fstsw	%ax
	testb	$0x41, %ah
	jnz	3f

# Load infinity

	fstp	%st
	flds	INFINITY
	jmp	4f

# Case 1: Small x, straightforward calculation.

1:	call	expm1_10	# E

	fld	%st		# E . E
	fld1			# 1 . E . E
	faddp	%st(1)		# E+1 . E

	fdivr	%st(1)		# E/(E+1) . E
	faddp	%st(1)		# E + E/(E+1) = 2 sinh(x)

	fmuls	HALF		# sinh(x)
	jmp	4f

# Case 2: e^(-x) insignificant, e^x doesn't overflow
	
2:	call	exp_10		# e^x
	fmuls	HALF		# 0.5 * e^x
	jmp	4f

# Case 3: e^x overflows, get tricky.

3:	fmuls	HALF		# 0.5*x
	call	exp_10		# exp(0.5*x)
	fld	%st		# exp(0.5*x) . exp(0.5*x)
	fmuls	HALF		# 0.5*exp(0.5*x) . exp(0.5*x)
	fmulp	%st(1)		# (0.5*exp(0.5*x)) * exp(0.5*x)

# Clean up stack, flip the sign of the result if necessary

4:	add	$16, SP
	andb	$2, %cl
	jz	5f

	fchs
5:	ret


PUBLIC(g95_cos_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	fcos
	fnstsw	%ax
	testl	$0x400,%eax
	jnz	1f
	ret

.align 4
1:	fldpi
	fadd	%st(0)
	fxch	%st(1)
2:	fprem1
	fnstsw	%ax
	testl	$0x400,%eax
	jnz	2b
	fstp	%st(1)
	fcos
	ret


PUBLIC(g95_cos_z10)
	mov	PARM2, REGDX
	fldt	IMAG(REGDX)	# c
	fld	%st(0)		# c . c

	call	sinh_10		# sinh(c) . c
	fchs			# -sinh(c) . c

	fxch	%st(1)		# c . -sinh(c)
	call	cosh_10		# cosh(c) . -sinh(c)

	fldt	(REGDX)		# r . cosh(c) . -sinh(c)

# Compute sin(r) and cos(r)
	fsincos
	fnstsw  %ax
	testl   $0x400, %eax
	jz	3f

.align 4
1:	fldpi
	fadd    %st(0)
	fxch    %st(1)
2:	fprem1
	fnstsw  %ax
	testl   $0x400, %eax
	jnz     2b
	fstp    %st(1)
	fsincos

3:	mov	PARM1, REGDX	# cos(r) . sin(r) . cosh(c) . -sinh(c)
	fxch	%st(3)		# -sinh(c) . sin(r) . cosh(c) . cos(r)

	fmulp	%st(1)          # -sinh(c)*sin(r) . cosh(c) . cos(r)
	fstpt	IMAG(REGDX)	# cosh(c) . cos(r)
	fmulp	%st(1)		# cosh(c) * cos(r)
	fstpt	(REGDX)
	ret


PUBLIC(g95_cosh_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	jmp	cosh_10

	
PUBLIC(g95_exp_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	jmp	exp_10



PUBLIC(g95_exp_z10)
	mov	PARM2, REGDX
	fldt	(REGDX)		# r
	call	exp_10		# exp(r)
	fldt	IMAG(REGDX)	# c . exp(r)

	fsincos
	fnstsw	%ax
	testl	$0x400, %eax
	jz	3f

.align 4
1:	fldpi
	fadd	%st(0)
	fxch	%st(1)
2:	fprem1
	fnstsw	%ax
	testl	$0x400, %eax
	jnz	2b
	fstp	%st(1)
	fsincos

3:	mov	PARM1, REGDX	# cos(c) . sin(c) . exp(r)
	fmul	%st(2)		# cos(c)*exp(r) . sin(c) . exp(r)
	fstpt	(REGDX)		# sin(c) . exp(r)
	fmulp	%st(1)		# sin(x)*exp(r)
	fstpt	IMAG(REGDX)
	ret


	
PUBLIC(g95_floor_1_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	sub	$8, SP
	fnstcw	4(SP)
	movw	$0x77f, (SP)
	fldcw	(SP)
	frndint
	fldcw	4(SP)
	fistp	(SP)
	mov	(SP), %al
	SIGNX_AL
	add	$8, SP
	ret


PUBLIC(g95_floor_2_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	sub	$8, SP
	fnstcw	4(SP)
	movw	$0x77f, (SP)
	fldcw	(SP)
	frndint
	fldcw	4(SP)
	fistp	(SP)
	mov	(SP), %ax
	SIGNX_AX
	add	$8, SP
	ret


PUBLIC(g95_floor_4_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	sub	$8, SP
	fnstcw	4(SP)
	movw	$0x77f, (SP)
	fldcw	(SP)
	frndint
	fldcw	4(SP)
	fistpl	(SP)
	movl	(SP), %eax
	add	$8, SP
	ret


PUBLIC(g95_floor_8_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	sub	$8, SP
	fnstcw	4(SP)
	movw	$0x77f, (SP)
	fldcw	(SP)
	frndint
	fldcw	4(SP)
	fistpll	(SP)
	movl	(SP), %eax
	movl	4(SP), %edx
	add	$8, SP
	ret


PUBLIC(g95_log_r10)
	mov	PARM1, REGDX
	fldln2
	fldt	(REGDX)
	fyl2x
	ret	


PUBLIC(g95_log_z10)
	mov	PARM2, REGDX
	fldt	IMAG(REGDX)	# c
	fldt	(REGDX)		# r . c
	mov	PARM1, REGDX
	fld	%st(1)		# c . r . c
	fld	%st(1)		# r . c . r . c
	fpatan			# atan2(c/r) . r . c
	fstpt	IMAG(REGDX)	# r . c

	call	mag		# mag
	fldln2			# ln2 . mag
	fxch	%st(1)		# mag . ln2
	fyl2x			# ln(mag)
	fstpt	(REGDX)
	ret


PUBLIC(g95_log10_r10)
	mov	PARM1, REGDX
        fldlg2
	fldt	(REGDX)
	fyl2x
	ret


PUBLIC(g95_mod_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)		# A
	mov	PARM2, REGDX
	fldt	(REGDX)		# P . A

	sub	$8, SP
	fnstcw	4(SP)
	movw	$0xf7f, (SP)
	fldcw	(SP)

	fld	%st(1)		# A . P . A
	fdiv	%st(1)		# A/P . P . A
	frndint			# int(A/P) . P . A
	fmulp   %st(1)		# int(A/P)*P . A
	fsubrp	%st(1)		# A - int(A/P)*P
			
	fldcw	4(SP)
	add	$8, SP
	ret			

	
PUBLIC(g95_modulo_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)		# A
	mov	PARM2, REGDX
	fldt	(REGDX)		# P . A

	sub	$8, SP
	fnstcw	4(SP)
	movw	$0x77f, (SP)
	fld	%st(1)		# A . P . A
	fdiv	%st(1)		# A/P . P . A
	fldcw	(SP)
	frndint			# floor(A/P) . P . A
	fldcw	4(SP)

	fmulp   %st(1)		# floor(A/P)*P . A
	fsubrp	%st(1)		# A - floor(A/P)*P
	add	$8, SP
	ret			


PUBLIC(g95_nint_1_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)

	sub	$8, SP
	fnstcw  4(SP)
	movw	$0xf7f, (SP)
	fldcw	(SP)
	flds	HALF
	fxch	%st(1)
	fxam
	fnstsw	%ax
	test	$0x200, %eax
	je	0f
	fxch	%st(1)
	fchs

0:	faddp
	frndint
	fldcw	4(SP)

	fistp	(SP)
	movb	(SP), %al
	SIGNX_AL
	add	$8, SP
	ret

	
PUBLIC(g95_nint_2_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)

	sub	$8, SP
	fnstcw	4(SP)
	movw	$0xf7f, (SP)
	fldcw	(SP)
	flds	HALF
	fxch	%st(1)
	fxam
	fnstsw	%ax
	test	$0x200, %eax
	je	0f
	fxch	%st(1)
	fchs

0:	faddp
	frndint
	fldcw	4(SP)

	fistp	(SP)
	movw	(SP), %ax
	SIGNX_AX
	add	$8, SP
	ret


PUBLIC(g95_nint_4_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)

	sub	$8, SP
	fnstcw	4(SP)
	movw	$0xf7f, (SP)
	fldcw	(SP)
	flds	HALF
	fxch	%st(1)
	fxam
	fnstsw	%ax
	test	$0x200, %eax
	je	0f
	fxch	%st(1)
	fchs

0:	faddp
	frndint
	fldcw	4(SP)

	fistpl	(SP)
	movl	(SP), %eax
	add	$8, SP
	ret

	
PUBLIC(g95_nint_8_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)

	sub	$8, SP
	fnstcw	4(SP)
	movw	$0xf7f, (SP)
	fldcw	(SP)
	flds	HALF	
	fxch	%st(1)
	fxam
	fnstsw	%ax
	test	$0x200, %eax
	je	0f
	fxch	%st(1)
	fchs

0:	faddp
	frndint
	fldcw	4(SP)

	fistpll	(SP)
	movl	(SP), %eax
	movl	4(SP), %edx
	add	$8, SP
	ret


PUBLIC(g95_sin_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	fsin
	fnstsw  %ax
	testl	$0x400, %eax
	jnz	1f
	ret

.align 4
1:	fldpi
	fadd	%st(0)
	fxch	%st(1)
2:	fprem1
	fnstsw	%ax
	testl	$0x400, %eax
	jnz	2b
	fstp	%st(1)
	fsin
	ret


PUBLIC(g95_sin_z10)
	mov	PARM2, REGDX
	fldt	IMAG(REGDX)	# c
	fld	%st(0)		# c . c
	call	sinh_10		# sinh(c) . c
	fxch	%st(1)		# c . sinh(c)
	call	cosh_10		# cosh(c) . sinh(c)
	fldt	(REGDX)         # r . cosh(c) . sinh(c)

## Compute sin(r) and cos(r)
	fsincos
	fnstsw  %ax
	testl	$0x400, %eax
	jz	3f

.align 4
1:	fldpi
	fadd    %st(0)
	fxch    %st(1)
2:	fprem1
	fnstsw  %ax
	testl   $0x400, %eax
	jnz     2b
	fstp    %st(1)
	fsincos

3:	mov	PARM1, REGDX	# cos(r) . sin(r) . cosh(c) . sinh(c)
	fxch	%st(1)		# sin(r) . cos(r) . cosh(c) . sinh(c)
	fxch	%st(3)		# sinh(c) . cos(r) . cosh(c) . sin(r)

	fmulp	%st(1)		# sinh(c)*cos(r) . cosh(c) . sin(r)
	fstpt	IMAG(REGDX)	# cosh(c) . sin(r)
	fmulp	%st(1)		# cosh(c) * sin(r)
	fstpt	(REGDX)
	ret
	

PUBLIC(g95_sinh_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)
	jmp	sinh_10


	
PUBLIC(g95_sqrt_r10)
	mov     PARM1, REGDX
	fldt    (REGDX)
	fsqrt
	ret


## Ironically, the complex square root is one of the most complicated
## subroutines in this file, while real square root is one of the
## simplest.

PUBLIC(g95_sqrt_z10)
	mov	PARM2, REGDX
	fldt	IMAG(REGDX)	# c
	fldt	(REGDX)		# r . c

# Calculate the magnitude of (r, c)

	fld	%st(1)		# c . r . c
	fld	%st(1)		# r . c . r . c
	call	mag		# mag . r . c

	mov	PARM1, REGDX
	fxam
	fstsw
	andb	$0x45, %ah
	cmpb	$0x40, %ah
	jnz	0f

## Magnitude == 0, result is zero.  There is no fstt instruction, so
## 80-bit stores have to be popped.

	fldz			# 0 . 0 . r . c
	fstpt	(REGDX)		# 0 . r . c
	fstpt	IMAG(REGDX)	# r . c

	fstp	%st             # c
	fstp	%st             #
	ret

0:	fldz			# 0 . mag . r . c
	fcomp	%st(2)		# mag . r . c
	fstsw

	andb	$0x41, %ah
	jz	1f

## r > 0 branch:  r' = sqrt(0.5*(mag+r)), c' = 0.5*c/r'

	faddp	%st(1)		# mag+r . c
	fmuls	HALF		# 0.5*(mag+r) . c
	fsqrt			# sqrt(0.5*(mag+r)) = r' . c
	fxch	%st(1)		# c . r'
	fmuls	HALF		# 0.5*c . r'
	fdiv	%st(1)		# c' . r'
	fstpt	IMAG(REGDX)	# r'
	fstpt	(REGDX)
	ret

## r <= 0 branch:
##   c' = sqrt(0.5*(mag-r))
##   if (sign(c))
##     c' = -c'
##   r' = 0.5 * c / c'

1:	fsubp	%st(1)		# mag-r . c
	fmuls	HALF		# 0.5*(mag-r) . c
	fsqrt			# sqrt(0.5*(mag-r)) = c' . c
	fxch	%st(1)		# c . c'
	fxam
	fstsw
	fxch	%st(1)		# c' . c
	testb	$0x02, %ah
	jz	2f
	fchs			# c' . c
2:	fxch	%st(1)		# c . c'
	fmuls	HALF		# 0.5*c . c'
	fdiv	%st(1)		# r' . c'
	fstpt	(REGDX)		# c'
	fstpt	IMAG(REGDX)
	ret


PUBLIC(g95_tan_r10)
	mov	PARM1, REGDX
        fldt    (REGDX)
	fptan
	fnstsw  %ax
	testl   $0x400, %eax
	jnz     1f
	fstp    %st(0)
	ret

1:	fldpi
	fadd    %st(0)
	fxch    %st(1)

2:	fprem1
	fstsw   %ax
	testl   $0x400, %eax
	jnz     2b

	fstp    %st(1)
	fptan
	fstp    %st
	ret



# Hyperbolic tangent:

# Use tanh(-x) = -tanh(-x) to get a nonegative x.

# x in [ 0,       2^(-39) )   tanh(x) = x
# x in [ 2^(-39),       1 )   tanh(x) = -E/(E+2)     where E = exp(-2x) - 1
# x in [ 1,            23 )   tanh(x) = 1 - 2/(E+2)  where E = exp(2x) - 1
# x > 23                      tanh(x) = 1

PUBLIC(g95_tanh_r10)
	mov	PARM1, REGDX
	fldt	(REGDX)

	fxam
	fstsw	%ax

	movb	$0x45, %al
	andb	%ah, %al
	cmpb	$0x05, %al
	jne	0f
	ret			# x = NaN

0:	fabs			# |x|
	mov	%ah, %ch	# Bit 2 of ch holds the sign bit of x
	sub	$16, SP

	movl	$0, (SP)
	movl	$0x80000000, 4(SP)
	movw	$0x3fd8, 8(SP)  # 2^(-39) \approx 1.8e-12

	fldt	(SP)
	fcomp	%st(1)
	fstsw	%ax
	testb	$0x41, %ah
	jz	3f
	
	fld1
	fcomp	%st(1)
	fstsw	%ax
	testb	$0x41, %ah
	jz	1f

	movl	$23, (SP)
	ficoml	(SP)
	fstsw	%ax
	testb	$0x41, %ah
	jnz	2f

# Case 4: tanh(x) = 1, a fast calculation

	fstp	%st
	fld1
	jmp	3f

# Case 2: tanh(x) = -E/(E+2) where E = exp(-2x) - 1

1:	fadd	%st		# 2*x
	fchs			# -2*x
	call	expm1_10	# E
	fld	%st		# E . E
	fld1			# 1 . E . E
	fxch	%st(1)		# E . 1 . E
	fadd	%st(1)		# E+1 . 1 . E
	faddp	%st(1)		# E+2 . E
	fdivrp	%st(1)		# E/(E+2)
	fchs			# -E/(E+2)
	jmp	3f

# Case 3: tanh(x) = 1 - 2/(E+2) where E = exp(2x) - 1

2:	fadd	%st		# 2x
	call	expm1_10	# E
	fld1			# 1 . E
	fadd	%st		# 2 . E
	fxch	%st(1)		# E . 2
	fadd	%st(1)		# E+2 . 2
	fdivrp	%st(1)		# 2/(E+2)

	fld1			# 1 . 2/(E+2)
	fsubp	%st(1)		# 1 - 2/(E+2)

# Fix the stack and the sign if necessary.

3:	add	$16, SP
	andb	$2, %ch
	jz	4f

	fchs
4:	ret




# Exponentiation, compute x^y.  The basic algorithm is to examine x and y
# for special values.  If all else fails, we actually have to compute
# something.  The two major paths involve real exponents which can be
# integral or strictly integral exponents.

## Examine y:
##   If y == +/- 0
##     if x == 0, x^y = 1
##     else x^y = 0
##   If y == NaN,     x^y = binary NaN
##   If y = +/- Inf
##     If x == NaN,   x^y = binary NaN
##     If |x| = 1,    x^y = 1
##     If (|x| < 1) ^ sign(y) == 1  x^y = Inf
##     else x^y = +0

## Examine x (y is a finite nonzero number):
##   If x == +0       x^y = +0
##   If x == -0
##      If y is an odd integer   x^y = -0
##      else x^y = +0
##   If x == +Inf
##      if y > 0   x^y = +Inf
##      else       x^y = +0
##   If x == -Inf
##      If nonintegral y
##         If y > 0    x^y = +Inf
##         else        x^y = +0
##      else if y<0 and y odd    x^y = -0
##      else if y<0 and y even   x^y = +0
##      else if y>0 and y odd    x^y = -Inf
##      else    y>0 and y even   x^y = +Inf

## If no special case has been detected, then compute x^y using square
## and multiply if y is integral, or log/exp for the general case.

## check_x: See if x/y satisfies a special case.  x is on the TOS.
##
## CL bits
##     0   Low bit of y   (if bit 1 of CL is 0)
##     1   Set iff y is non-integral
##
## CH bits
##     0   Sign bit of y
##
## If the carry is set on exit, then x has been replaced with the result
## of the exponentiation.

check_x:
	fxam
	fstsw	%ax
	andb	$0x47, %ah

	cmpb	$0x40, %ah	# +0.0
	je	1f

	cmpb	$0x42, %ah	# -0.0
	je	2f

	cmpb	$0x05, %ah	# +Inf
	je	3f

	cmpb	$0x07, %ah	# -Inf
	je	5f

	clc
	ret

# x == +0.0, the result is already on the stack

1:	stc
	ret

# x == -0.0

2:	cmp	$1, %cl
	je	1b
	
	fchs
	stc
	ret

# x == +Inf

3:	fstp	%st(0)
	test	$1, %ch
	je	4f

	fldz
	stc
	ret

4:	flds	INFINITY
	stc
	ret

# x == -Inf

5:	test	$0x02, %cl
	je	7f

	fchs
	test	$1, %ch
	je	6f

	fstp	%st(0)
	fldz
6:	stc
	ret

# Nasty case of x == -Inf and an integral y

7:	test	$1, %ch
	jne	9f		# Negative y

	fchs
	test	$0x01, %cl
	je	8f
	fchs

8:	stc
	ret

9:	fstp	%st(0)
	fldz

	test	$0x01, %cl
	je	0f
	fchs

0:	stc
	ret

	
# integer_power-- Raise TOS to an integer power in edx:eax.  Special cases have
# already been dispensed with.

integer_power:
	or	$0, %edx
	jns	1f

	fld1
	fdivp	%st(1)
	neg	%eax
	adc	$0, %edx
	neg	%edx

1:	fld1			# 1 . x
	fxch	%st(1)		# x . 1
	
2:	shrdl	$1, %edx, %eax
	jnc	3f

	fxch	%st(1)
	fmul	%st(1)
	fxch	%st(1)

3:	shr	$1, %edx
	mov	%eax, %ecx
	or	%edx, %ecx
	je	4f

	fmul	%st(0)
	jmp	2b

4:	fstp	%st(0)
	ret


# zero_power-- Come here if the integer exponent is zero.  If the base is
# a not-a-number, then that is our result.  Otherwise, the result is one.

zero_power:
	fxam
	fstsw	%ax

	and	$0x45, %ah
	cmp	$0x01, %ah
	je	0f		# Branch if NaN

	fstp	%st(0)
	fld1

0:	ret



PUBLIC(g95_power_r10_i1)
	mov	PARM1, REGDX
	fldt	(REGDX)
	mov	PARM2, REGDX
	movsbw	(REGDX), %cx

	cmp	$0, %cl
	je	zero_power

	sets	%ch
	and	$0x01, %cl
	call	check_x
	jc	0b

	movsbl	(REGDX), %eax
	cdq
	jmp	integer_power


PUBLIC(g95_power_r10_i2)
	mov	PARM1, REGDX
	fldt	(REGDX)
	mov	PARM2, REGDX
	movw	(REGDX), %cx

	cmp	$0, %cx
	je	zero_power

	sets	%ch
	and	$0x01, %cl
	call	check_x
	jc	0b

	movswl	(REGDX), %eax
	cdq
	jmp	integer_power


PUBLIC(g95_power_r10_i4)
	mov	PARM1, REGDX
	fldt	(REGDX)
	mov	PARM2, REGDX
	movl	(REGDX), %eax

	cmp	$0, %eax
	je	zero_power

	mov	%al, %cl
	sets	%ch
	and	$0x01, %cl
	call	check_x
	jc	0b

	mov	(REGDX), %eax
	cdq
	jmp	integer_power


PUBLIC(g95_power_r10_i8)
	mov	PARM1, REGDX
	fldt	(REGDX)
	mov	PARM2, REGDX

	mov	(REGDX), %ecx
	mov	4(REGDX), %eax

	or	%ecx, %eax
	je	zero_power

	testb	$0x80, 7(REGDX)
	sets	%ch
	and	$0x01, %cl

	call	check_x
	jc	0b
	
	mov	(REGDX), %eax
	mov	4(REGDX), %edx
	jmp	integer_power	
		

# Exponentiation.  Compute x^y

PUBLIC(g95_power_r10)
	mov	PARM2, REGDX
	fldt	(REGDX)		# y

	fxam
	fnstsw	%ax
	movb	%ah, %ch

	andb	$0x02, %ch
	shrb	$1, %ch		# Bit 0 of ch holds the sign of y
	
	andb	$0x45, %ah

	cmpb	$0x40, %ah
	je	3f		# Got +/- 0.0
	cmpb	$0x01, %ah
	je	4f		# Got Nan
	cmpb	$0x05, %ah
	je	5f		# Got +/- Inf

# y is nonzero and finite.  See if it is an integer.

	sub	$8, SP
	movl	$0xffffffff, (SP)
	movl	$0x7fffffff, 4(SP)

	fildll	(SP)
	fcomp
	fstsw	%ax
	movb	$2, %cl
	and	$0x45, %ah
	cmp	$0x00, %ah
	jne	1f		# Too big to be an "integer"

	fld	%st
	fistpll	(SP)
	fildll	(SP)

	fcomp
	fstsw	%ax
	movb	$2, %al
	and	$0x45, %ah
	cmp     $0x40, %ah
	jne	1f		# Not an integer

	movb	(SP), %cl
	andb	$0x01, %cl

1:	add	$8, SP
	mov	PARM1, REGDX
	fldt	(REGDX)		# x . y

	call	check_x
	jnc	2f
	
	fstp	%st(1)
	ret	

# No special cases of x.

2:	cmp	$0x02, %cl
	je	9f

	sub	$8, SP	
	fxch	%st(1)		# y . x
	fistpll	(SP)

	movl	(SP), %eax
	movl	4(SP), %edx
	add	$8, SP

	jmp	integer_power

# y = 0
3:	fstp	%st(0)
	fld1
	ret

# y = NaN, compute a binary NaN.
4:	mov	PARM2, REGDX
	fldt	(SP)
	faddp	%st(1)
	ret

# y = +/- Infinity
5:	mov	PARM1, REGDX
	fldt	(REGDX)		# x . y
	fxam
	fstsw	%ax

	andb	$0x45, %ah
	cmpb	$0x01, %ah
	jne	6f		# Jump if x not a NaN

	faddp	%st(1)		# Binary NaN
	ret

6:	fstp	%st(1)		# x
	fld1			# 1 . x
	fcompp			# <empty>
	fstsw	%ax

	andb	$0x45, %ah
	cmpb	$0x40, %ah
	jne	7f

# x==1
	fld1
	ret

# x <> 1
7:	xor	%ah, %ch
	and	$1, %ch
	je	8f

	fldz
	ret

8:	flds	INFINITY	# Single +Infinity
	ret

# General exponentiation

9:	sub	$8, SP
	movl	$0x3E95F000, (SP)    # Slightly less than 1.0-sqrt(2)/2

        fld1                    # 1.0 . x . y
        fld     %st(1)          # x . 1.0 . x .	 y
        fsub    %st(1)          # x-1 . 1.0 . x . y
        fabs                    # |x-1| . 1.0 . x . y

	fcomps	(SP)		# 1.0 . x . y

        fnstsw	%ax
        fxch			# x . 1.0 . y

	and	$0x45, %ah
	cmp	$0x00, %ah
	je	1f              # |x-1| > 1.0-sqrt(2)/2

        fsub    %st(1)          # x-1 . 1.0 . y
        fyl2xp1                 # log2(x) . y
        jmp     2f

1:	fyl2x                   # log2(x) . y
2:	fmul    %st(1)          # y*log2(x) . y
        fxam
	fnstsw
        andb    $0x45, %ah
        cmpb    $0x05, %ah      # is y*log2(x) == inf ?
        je      3f

        fst	%st(1)		# y*log2(x) . y*log2(x)
        frndint			# int(y*log2(x)) . y*log2(x)
        fsubr	%st, %st(1)	# int(y*log2(x)) . fract(y*log2(x))
        fxch                    # fract(y*log2(x)) . int(y*log2(x))
        f2xm1                   # 2^fract(y*log2(x))-1 . int(y*log2(x))
	fld1
        faddp	%st(1)		# 2^fract(y*log2(x)) . int(y*log2(x))
        fscale			# 2^fract(y*log2(x))*2^int(y*log2(x)) . int(y*log2(x))
        add	$8, SP
        fstp	%st(1)		# 2^fract(y*log2(x))*2^int(y*log2(x))
        ret

3:	fstp	%st(1)		# y*log2(x)
	fld1			# 1 . y*log2(x)
	fscale			# 2^(y*log2(x)) . y*log2(x)
	add	$8, SP
	fstp	%st(1)          # 2^(y*log2(x))
	ret

	
### Complex exponentials

PUBLIC(g95_power_z10)
	mov	PARM2, REGAX
	fldt	(REGAX)		# a.r
	fldt	IMAG(REGAX)	# a.c . a.r

	fxam
	fstsw	%ax
	andb	$0x45, %ah
	cmpb	$0x40, %ah
	jne	2f

	fxch	%st(1)
	fxam
	fstsw	%ax
	fxch	%st(1)
	andb	$0x45, %ah
	cmpb	$0x40, %ah
	jne	2f

# Special case of base equal to zero.

	fstp	%st
	fstp	%st
	
	mov	PARM3, REGAX
	fldt	(REGAX)
	fxam
	fstsw	%ax
	fstp	%st

	andb	$0x45, %ah
	cmpb	$0x40, %ah
	jne	1f

	mov	PARM3, REGAX
	fldt	IMAG(REGAX)
	fxam
	fstsw	%ax
	fstp	%st

	andb	$0x45, %ah
	cmpb	$0x40, %ah
	jne	1f

# Base and exponent are zero, result = (1.0, 0.0)

	mov	PARM1, REGAX
	fld1
	fstpt	(REGAX)
	fldz
	fstpt	IMAG(REGAX)
	ret

# Base zero and exponent nonzero, result = (0.0, 0.0)
	
1:	mov	PARM1, REGAX
	fldz
	fstpt	(REGAX)
	fldz
	fstpt	IMAG(REGAX)
	ret

# General case.  First calculate

#  m = log(|(a.r, a.c)|)
#  n = atan2(a.c, a.r)
	
2:	fld	%st(1)		# a.r . a.c . a.r 
	fld	%st(1)		# a.c . a.r . a.c . a.r
	call	mag		# |a| . a.c . a.r
	fldln2			# ln2 . |a| . a.c . a.r
	fxch	%st(1)		# |a| . ln2 . a.c . a.r
	fyl2x			# m . a.c . a.r
	fxch	%st(2)		# a.r . a.c . m
	fpatan			# n . m

# Now compute
# x = exp(m*b.r - n*b.c)
# y = m*b.c + n*b.r

	mov	PARM3, REGAX
	fldt	(REGAX)		# b.r . n . m
	fld	%st(0)		# b.r . b.r . n . m

	fmul	%st(2)		# b.r*n . b.r . n . m
	fxch	%st(1)		# b.r . b.r*n . n . m

	fmul	%st(3)		# b.r*m . b.r*n . n . m
	fxch	%st(3)		# m . b.r*n . n . b.r*m
	fxch	%st(1)		# b.r*n . m . n . b.r*m
	fxch	%st(2)		# n . m . b.r*n . b.r*m

	fldt	IMAG(REGAX)	# b.c . n . m . b.r*n . b.r*m
	fxch	%st(2)		# m . n . b.c . b.r*n . b.r*m
	fmul	%st(2)		# b.c*m . n . b.c . b.r*n . b.r*m
	fxch	%st(2)		# b.c . n . b.c*m . b.r*n . b.r*m
	fmulp	%st(1)		# b.c*n . b.c*m . b.r*n . b.r*m

	fxch	%st(2)		# b.r*n . b.c*m . b.c*n . b.r*m
	faddp	%st(1)		# b.r*n + b.c*m . b.c*n . b.r*m
	fxch	%st(2)		# b.r*m . b.c*n . y
	fsubp	%st(1)		# b.r*m - b.c*n . y
	call	exp_10		# x . y

# The final result is:
#  a**b = ( x*cos(y), x*sin(y) )

	fxch	%st(1)		# y . x

	fsincos
	fnstsw	%ax
	test	$0x04, %ah
	jz	4f

.align 4
	fldpi
	fadd    %st(0)
	fxch    %st(1)
3:	fprem1
	fnstsw  %ax
	test	$0x4, %ah
	jnz	3b
	fstp	%st(1)
	fsincos

4:	mov	PARM1, REGAX	# sin(y) . cos(y) . x
	fmul	%st(2)		# x*sin(y) . cos(y) . x
	fstpt	(REGAX)		# cos(y) . x
	fmulp	%st(1)		# x * cos(y)
	fstpt	IMAG(REGAX)
	ret


#  Complex number to an integer power


PUBLIC(g95_power_z10_i1)
	mov	PARM3, REGDX
	movsbl	(REGDX), %eax
	cdq
	mov	%eax, %ecx
	jmp	0f

PUBLIC(g95_power_z10_i2)
	mov	PARM3, REGDX
	movswl	(REGDX), %eax
	cdq
	mov	%eax, %ecx
	jmp	0f

PUBLIC(g95_power_z10_i4)
	mov	PARM3, REGDX
	mov	(REGDX), %eax
	cdq
	mov	%eax, %ecx
	jmp	0f

PUBLIC(g95_power_z10_i8)
	mov	PARM3, REGDX
	mov	(REGDX), %ecx
	mov	4(REGDX), %edx

# Common entry point for complex ** integer.   edx:ecx is the exponent

0:	mov	PARM2, REGAX
	fldt	(REGAX)		# a_r
	fldt	IMAG(REGAX)	# a_c . a_r

	fxam
	fstsw	%ax
	andb	$0x45, %ah
	cmpb	$0x40, %ah
	jne	3f

	fxch	%st(1)		# a_r . a_c
	fxam
	fstsw	%ax
	fxch	%st(1)		# a_c . a_r
	andb	$0x45, %ah
	cmpb	$0x40, %ah
	jne	3f

# base == 0

	mov	PARM1, REGAX
	or	%edx, %ecx
	je	4f

# base == 0, exponent nonzero, result is zero, already on the stack.

	fstpt	(REGAX)
	fstpt	IMAG(REGAX)
	ret

# base == 0, exponent == 0, result is (1.0, 0.0)

4:	fld1
	fstpt	(REGAX)
	fstpt	IMAG(REGAX)
	fstp	%st
	ret

# Generate case, base <> 0.  Exponent in %edx:%ecx

3:	or	%edx, %edx
	jns	4f

	neg	%ecx
	adc	$0, %edx
	neg	%edx

# Compute the complex reciprocal of the TOS.

	fld	%st		# a_c . a_c . a_r
	fmul	%st		# a_c^2 . a_c . a_r
	fld	%st(2)		# a_r . a_c^2 . a_c . a_r
	fmul	%st		# a_r^2 . a_c^2 . a_c . a_r
	faddp	%st(1)		# a_r^2 + a_c^2 . a_c . a_r

	fxch	%st(2)		# a_r . a_c . det
	fdiv	%st(2)		# a_r/det . a_c . det
	fxch	%st(2)		# det . a_c . a_r/det
	fdivrp	%st(1)		# a_c/det . a_r/det
	fchs			# -a_c/det . a_r/det

# At this point, load the accumulated product

4:	fld1			# 1 . s_c . s_r
	fxch	%st(2)		# s_r . s_c . 1
	fldz			# 0 . s_r . s_c . 1
	fxch	%st(2)		# s_c . s_r . 0 . 1

# The fp stack looks like:  s_c . s_r . p_c . p_r
# Where s is the current square and p is the current product

5:	shrd	$1, %edx, %ecx
	jnc	6f

# Compute p = p*s

	fld	%st(3)		# p_r . s_c . s_r . p_c . p_r
	fmul	%st(2)		# p_r s_r . s_c . s_r . p_c . p_r
	fld	%st(3)		# p_c . p_r s_r . s_c . s_r . p_c . p_r
	fmul	%st(2)		# p_c s_c . p_r s_r . s_c . s_r . p_c . p_r
	fsubrp	%st(1)		# p_r s_r - p_c s_c .  s_c . s_r . p_c . p_r
	fxch	%st(4)		# p_r . s_c . s_r . p_c . p_r'
	fmul	%st(1)		# p_r s_c . s_c . s_r . p_c . p_r'
	fld	%st(3)		# p_c . p_r s_c . s_c . s_r . p_c . p_r'
	fmul	%st(3)		# p_c s_r . p_r s_c . s_c . s_r . p_c . p_r'
	faddp	%st(1)		# p_c s_r + p_r s_c . s_c . s_r . p_c . p_r'
	fxch	%st(3)		# p_c . s_c . s_r . p_c s_r + p_r s_c . p_r'
	fstp	%st		# s_c . s_r . p_c' . p_r'

6:	mov	%edx, %eax
	or	%ecx, %eax
	je	7f

# Compute s = s*s

	fld	%st(1)		# s_r . s_c . s_r . p_c . p_r
	fmul	%st		# s_r^2 . s_c . s_r . p_c . p_r
	fld	%st(1)		# s_c . s_r^2 . s_c . s_r . p_c . p_r
	fmul	%st		# s_c^2 . s_r^2 . s_c . s_r . p_c . p_r
	fsubrp	%st(1)		# s_r^2-s_c^2 . s_c . s_r . p_c . p_r
	fxch	%st(2)		# s_r . s_c . s_r^2-s_c^2 . p_c . p_r
	fmulp	%st(1)		# s_r s_c . s_r^2-s_c^2 . p_c . p_r
	fadd	%st		# 2 s_r s_c . s_r^2-s_c^2 . p_c . p_r
	jmp	5b		# s_c' . s_r' . p_c . p_r

7:	fstp	%st		# s_r . p_c . p_r
	fstp	%st		# p_c . p_r

	mov	PARM1, REGAX
	fstpt	IMAG(REGAX)
	fstpt	(REGAX)
	ret
