
/* Copyright (C) 2002-2008 Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


#include "runtime.h"



typedef enum { CLOSE_DELETE, CLOSE_KEEP, CLOSE_UNSPECIFIED } close_status;

static st_option status_opt[] = {
    { "keep",     CLOSE_KEEP   },
    { "delete",   CLOSE_DELETE },
    { NULL } };



void st_close(void) {
char path[PATH_LENGTH+1];
close_status status;
unit_status s;
iounit_t *u;

    library_start();

    status = (ioparm->status == NULL) ? CLOSE_UNSPECIFIED :
	find_option(ioparm->status, ioparm->status_len, status_opt,
		    "Bad STATUS parameter in CLOSE statement");

    if (ioparm->library_rc != LIBRARY_OK)
	goto done;

    u = find_unit(ioparm->unit, ioparm->unit_kind);
    if (u != NULL) {
	path[0] = '\0';
	if (unpack_filename(path, u->file, u->file_len))
	    path[0] = '\0';

	s = u->flags.status;
	close_unit(u);

	if (s == STATUS_SCRATCH && status == CLOSE_KEEP)
	    generate_error(ERROR_BAD_OPTION,
			   "Can't KEEP a scratch file on CLOSE");

	else if (path[0] != '\0' &&
		 (status == CLOSE_DELETE ||
		  (s == STATUS_SCRATCH && HAVE_WINDOWS)))
	    delete_file(path);
    }

done:
    library_end();
}
