
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the spread() intrinsic. */

#include "runtime.h"
#include <string.h>


#define spread prefix(spread)

g95_array_descriptor *spread(g95_array_descriptor *source, G95_DINT *dim_p,
			     G95_DINT *ncopies_p) {
G95_AINT dim, extent, ncopies, element_size, index[G95_MAX_DIMENSIONS];
int i, m, zero_size;

g95_array_descriptor *result;
char *p, *q;

    ncopies = *ncopies_p;
    if (ncopies < 0)
	ncopies = 0;

    zero_size = (ncopies == 0);

    dim = *dim_p;
    if (dim < 1 || dim > source->rank+1)
	bad_dim();

    dim--;   /* now zero based */

    element_size = source->element_size;

    if (source->rank >= G95_MAX_DIMENSIONS)
	runtime_error("SPREAD(): too many dimension in source argument");

    section_info[0] = source->rank + 1;
    section_info[1] = element_size;

    m = 2;
    for(i=0; i<source->rank; i++) {
	extent = source->info[i].ubound - source->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim) {
	    section_info[m++] = 1;
	    section_info[m++] = ncopies;
	}

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    if (i == dim) {
	section_info[m++] = 1;
	section_info[m++] = ncopies;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    for(i=0; i<source->rank; i++)
	index[i] = source->info[i].lbound;

    for(;;) {
	q = source->offset;

	for(i=0; i<source->rank; i++)
	    q += index[i] * source->info[i].mult;

	p = result->offset;

	for(i=0; i<=source->rank; i++) {
	    if (i == dim)
		continue;

	    m = (i > dim) ? i-1 : i;
	    p += (index[m] - source->info[m].lbound + 1)*result->info[i].mult;
	}

	for(i=1; i<=ncopies; i++)
	    memcpy(p + i*result->info[dim].mult, q, element_size);

	if (bump_element(source, index))
	    break;
    }

    return result;
}


#define spread_s prefix(spread_s)

g95_array_descriptor *spread_s(char *source, G95_DINT *dim_p,
			       G95_DINT *ncopies_p, G95_DINT source_len) {
g95_array_descriptor *result;
G95_AINT ncopies;
char *p;

    ncopies = *ncopies_p; 
    if (ncopies < 0)
	ncopies = 0;

    result = temp_array(1, source_len, ncopies);

    p = result->base;

    while(ncopies > 0) {
	memcpy(p, source, source_len);
	p += source_len;
	ncopies--;
    }

    return result;
}
