
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement maxloc()/minloc() intrinsics. */


#ifdef SUBROUTINE

g95_array_descriptor *SUBROUTINE(g95_array_descriptor *array,
				 void *dummy,
				 g95_array_descriptor *mask,
				 G95_DINT *mask_s) {
  
G95_AINT a_index[G95_MAX_DIMENSIONS], m_index[G95_MAX_DIMENSIONS],
         x_index[G95_MAX_DIMENSIONS], rank, *ip;
int i;

g95_array_descriptor *r;
TYPE *extremum;
char *p;

    extremum = NULL;
    rank = array->rank;

    if (mask_s != NULL && !(*mask_s))
	goto done;

    for(i=0; i<rank; i++) {
	a_index[i] = array->info[i].lbound;
	if (array->info[i].lbound > array->info[i].ubound)
	    goto done;

	if (mask != NULL)
	    m_index[i] = mask->info[i].lbound;
    }

    for(;;) {
	if (mask != NULL) {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask->info[i].mult * m_index[i];

	    if (!extract_logical(p, mask->element_size))
		goto next;
	}

	p = array->offset;
	for(i=0; i<rank; i++)
	    p += array->info[i].mult * a_index[i];

	if (extremum == NULL || COMPARE(*((TYPE *) p), *extremum)) {
	    extremum = (TYPE *) p;
	    for(i=0; i<rank; i++)
		x_index[i] = a_index[i];
	}

    next:
	if (bump_element(array, a_index))
	    break;

	if (mask != NULL)
	    bump_element(mask, m_index);
    }

done:
    /* Without an extremum, we return a zero vector */

    if (extremum == NULL)
	for(i=0; i<rank; i++)
	    x_index[i] = array->info[i].lbound - 1;

    r = temp_array(1, sizeof(G95_AINT), rank);
    ip = (G95_AINT *) r->base;

    for(i=0; i<rank; i++)
	*ip++ = x_index[i] - array->info[i].lbound + 1;

    return r;
}


g95_array_descriptor *SUBROUTINE_D(g95_array_descriptor *array,
				   G95_DINT *dim_p,
				   g95_array_descriptor *mask,
				   G95_DINT *mask_s) {
G95_AINT n, dim, extent, *p, size, array_x[G95_MAX_DIMENSIONS],
         mask_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int m, i, rank, zero_size;
TYPE *p1, *extremum;
char *q, *m1, *m2;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = sizeof(G95_DINT);

    zero_size = 0;
    size = 1;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    zero_size = 1;
	    extent = 0;
	}

	if (i == dim)
	    continue;

	size = size * extent;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);

    p = (G95_AINT *) result->base;

    for(n=0; n<size; n++)
	*p++ = 0;

    n = 0;

    if (zero_size || (mask_s != NULL && !(*mask_s)))
	return result;

    p = (G95_AINT *) result->base;

    for(;;) {
	q = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	extremum = NULL;

	for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (i - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    p1 = (TYPE *) (q + array->info[dim].mult * i);
	    if (extremum == NULL || COMPARE(*p1, *extremum)) {
		extremum = p1;
		n = i;
	    }
	}

	*p++ = n - array->info[dim].lbound + 1;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}


G95_AINT SUBROUTINE_1(g95_array_descriptor *array, void *dummy,
		      g95_array_descriptor *mask, G95_DINT *mask_s) {
G95_AINT x_index, m, a, i;
TYPE *extremum;
char *p;

    if (mask_s != NULL && !(*mask_s))
	return 0;

    x_index = -1;
    i = 0;
    m = 0;

    extremum = NULL;
    if (mask != NULL)
	m = mask->info[0].lbound;

    for(a=array->info[0].lbound; a<=array->info[0].ubound; a++) {
	if (mask != NULL) {
	    p = mask->offset + mask->info[0].mult*m++;

	    if (!extract_logical(p, mask->element_size))
		continue;
	}

	p = array->offset + array->info[0].mult*a;

	if (extremum == NULL || COMPARE(*((TYPE *) p), *extremum)) {
	    extremum = (TYPE *) p;
	    x_index = a;
	}
    }

    return (extremum == NULL) ? 0 : x_index - array->info[0].lbound + 1;
}


#undef SUBROUTINE
#undef SUBROUTINE_D
#undef SUBROUTINE_1
#undef TYPE
#undef COMPARE

#else
#include "runtime.h"

#define SUBROUTINE prefix(minloc_i1)
#define SUBROUTINE_D prefix(minlocd_i1)
#define SUBROUTINE_1 prefix(minloc1_i1)
#define TYPE G95_INT1
#define COMPARE(a, b) a < b
#include "mmloc.c"

#define SUBROUTINE prefix(maxloc_i1)
#define SUBROUTINE_D prefix(maxlocd_i1)
#define SUBROUTINE_1 prefix(maxloc1_i1)
#define TYPE G95_INT1
#define COMPARE(a, b) a > b
#include "mmloc.c"

#define SUBROUTINE prefix(minloc_i2)
#define SUBROUTINE_D prefix(minlocd_i2)
#define SUBROUTINE_1 prefix(minloc1_i2)
#define TYPE G95_INT2
#define COMPARE(a, b) a < b
#include "mmloc.c"

#define SUBROUTINE prefix(maxloc_i2)
#define SUBROUTINE_D prefix(maxlocd_i2)
#define SUBROUTINE_1 prefix(maxloc1_i2)
#define TYPE G95_INT2
#define COMPARE(a, b) a > b
#include "mmloc.c"

#define SUBROUTINE prefix(minloc_i4)
#define SUBROUTINE_D prefix(minlocd_i4)
#define SUBROUTINE_1 prefix(minloc1_i4)
#define TYPE G95_INT4
#define COMPARE(a, b) a < b
#include "mmloc.c"

#define SUBROUTINE prefix(maxloc_i4)
#define SUBROUTINE_D prefix(maxlocd_i4)
#define SUBROUTINE_1 prefix(maxloc1_i4)
#define TYPE G95_INT4
#define COMPARE(a, b) a > b
#include "mmloc.c"

#ifdef G95_INT8

#define SUBROUTINE prefix(minloc_i8)
#define SUBROUTINE_D prefix(minlocd_i8)
#define SUBROUTINE_1 prefix(minloc1_i8)
#define TYPE G95_INT8
#define COMPARE(a, b) a < b
#include "mmloc.c"

#define SUBROUTINE prefix(maxloc_i8)
#define SUBROUTINE_D prefix(maxlocd_i8)
#define SUBROUTINE_1 prefix(maxloc1_i8)
#define TYPE G95_INT8
#define COMPARE(a, b) a > b
#include "mmloc.c"

#endif

#ifdef G95_INT16

#define SUBROUTINE prefix(minloc_i16)
#define SUBROUTINE_D prefix(minlocd_i16)
#define SUBROUTINE_1 prefix(minloc1_i16)
#define TYPE G95_INT16
#define COMPARE(a, b) a < b
#include "mmloc.c"

#define SUBROUTINE prefix(maxloc_i16)
#define SUBROUTINE_D prefix(maxlocd_i16)
#define SUBROUTINE_1 prefix(maxloc1_i16)
#define TYPE G95_INT16
#define COMPARE(a, b) a > b
#include "mmloc.c"

#endif

#define SUBROUTINE prefix(minloc_r4)
#define SUBROUTINE_D prefix(minlocd_r4)
#define SUBROUTINE_1 prefix(minloc1_r4)
#define TYPE float
#define COMPARE(a, b) a < b
#include "mmloc.c"

#define SUBROUTINE prefix(maxloc_r4)
#define SUBROUTINE_D prefix(maxlocd_r4)
#define SUBROUTINE_1 prefix(maxloc1_r4)
#define TYPE float
#define COMPARE(a, b) a > b
#include "mmloc.c"

#define SUBROUTINE prefix(minloc_r8)
#define SUBROUTINE_D prefix(minlocd_r8)
#define SUBROUTINE_1 prefix(minloc1_r8)
#define TYPE double
#define COMPARE(a, b) a < b
#include "mmloc.c"

#define SUBROUTINE prefix(maxloc_r8)
#define SUBROUTINE_D prefix(maxlocd_r8)
#define SUBROUTINE_1 prefix(maxloc1_r8)
#define TYPE double
#define COMPARE(a, b) a > b
#include "mmloc.c"

#define SUBROUTINE prefix(minloc_r16)
#define SUBROUTINE_D prefix(minlocd_r16)
#define SUBROUTINE_1 prefix(minloc1_r16)
#define TYPE packed16
#define COMPARE(a, b) (__lttf2(a, b) < 0)
#include "mmloc.c"

#define SUBROUTINE prefix(maxloc_r16)
#define SUBROUTINE_D prefix(maxlocd_r16)
#define SUBROUTINE_1 prefix(maxloc1_r16)
#define TYPE packed16
#define COMPARE(a, b) (__gttf2(a, b) > 0)
#include "mmloc.c"

#endif

