/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "defs.h"
#ifndef lint
static char RCSid[] __attribute__((__unused__)) = 
"$FreeRdist: distopt.c,v 1.7 2012/07/11 17:20:20 christos Exp $";

static char sccsid[] __attribute__((__unused__)) =
"@(#)distopt.c";

static char copyright[] __attribute__((__unused__)) =
"@(#) Copyright (c) 1983 Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* !lint */

/*
 * Dist Option functions
 */


/*
 * Distfile Option Information
 */
DISTOPTINFO distoptinfo[] = {
	{ DO_CHKNFS,		"chknfs", 	NULL},
	{ DO_CHKREADONLY,	"chkreadonly",	NULL},
	{ DO_CHKSYM,		"chksym",	NULL },
	{ DO_DEFGROUP,		"defgroup",	defgroup },
	{ DO_DEFOWNER,		"defowner",	defowner },
	{ DO_COMPARE,		"compare", 	NULL },
	{ DO_COMPRESS,		"compress", 	NULL },
	{ DO_FOLLOW,		"follow", 	NULL },
	{ DO_HISTORY,		"history", 	NULL },
	{ DO_IGNLNKS,		"ignlnks",	NULL },
	{ DO_NOCHKGROUP,	"nochkgroup",	NULL },
	{ DO_NOCHKMODE,		"nochkmode",	NULL },
	{ DO_NOCHKOWNER,	"nochkowner",	NULL },
	{ DO_NODESCEND,		"nodescend",	NULL },
	{ DO_NOEXEC,		"noexec",	NULL },
	{ DO_NUMCHKGROUP,	"numchkgroup",	NULL },
	{ DO_NUMCHKOWNER,	"numchkowner",	NULL },
	{ DO_QUIET,		"quiet",	NULL },
	{ DO_REMOVE,		"remove",	NULL },
	{ DO_SAVETARGETS,	"savetargets",	NULL },
	{ DO_UPDATEPERM,	"updateperm",	NULL },
	{ DO_VERIFY,		"verify",	NULL },
	{ DO_WHOLE,		"whole",	NULL },
	{ DO_YOUNGER,		"younger",	NULL },
	{ 0,			NULL,		NULL },
};

/*
 * Get a Distfile Option entry named "name".
 */
DISTOPTINFO *
getdistopt(const char *name, int *len)
{
	int i;

	for (i = 0; distoptinfo[i].do_name; ++i)
		if (strncasecmp(name, distoptinfo[i].do_name,
				*len = strlen(distoptinfo[i].do_name)) == 0)
			return &distoptinfo[i];

	return NULL;
}

/*
 * Parse a dist option string.  Set option flags to optptr.
 * If doerrs is true, print out own error message.  Returns
 * 0 on success.
 */
int
parsedistopts(const char *str, opt_t *optptr, int doerrs)
{
	char *string, *optstr;
	DISTOPTINFO *distopt;
	int len;

	/* strtok() is harmful */
	string = xstrdup(str);

	for (optstr = strtok(string, ","); optstr;
	     optstr = strtok(NULL, ",")) {
		/* Try Yes */
		if ((distopt = getdistopt(optstr, &len)) != NULL) {
			FLAG_ON(*optptr, distopt->do_value);
			if (distopt->do_arg && optstr[len] == '=')
				distopt->do_arg = xstrdup(&optstr[len + 1]);
			continue;
		}

		/* Try No */
		if ((distopt = getdistopt(optstr+2, &len)) != NULL) {
			FLAG_OFF(*optptr, distopt->do_value);
			continue;
		}

		if (doerrs)
			error("Dist option \"%s\" is not valid.", optstr);
	}

	if (string)
		(void) free(string);

	return nerrs;
}

/*
 * Get a list of the Distfile Option Entries.
 */
char *
getdistoptlist(void)
{
	int i;
	static char buf[1024];

	for (i = 0, buf[0] = CNULL; distoptinfo[i].do_name; ++i) {
		if (buf[0] == CNULL)
			(void) strcpy(buf, distoptinfo[i].do_name);
		else {
			(void) strcat(buf, ",");
			(void) strcat(buf, distoptinfo[i].do_name);
		}
	}

	return buf;
}

/*
 * Get a list of the Distfile Option Entries for each enabled 
 * value in "opts".
 */
char *
getondistoptlist(opt_t opts)
{
	int i;
	static char buf[1024];

	for (i = 0, buf[0] = CNULL; distoptinfo[i].do_name; ++i) {
		if (!IS_ON(opts, distoptinfo[i].do_value))
			continue;

		if (buf[0] == CNULL)
			(void) strcpy(buf, distoptinfo[i].do_name);
		else {
			(void) strcat(buf, ",");
			(void) strcat(buf, distoptinfo[i].do_name);
		}
		if (distoptinfo[i].do_arg) {
			(void) strcat(buf, "=");
			(void) strcat(buf, distoptinfo[i].do_arg);
		}
	}

	return buf;
}

