#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

int width=0;
int height=0;
int awidth=0;
int kwidth=0;

char *afont;
char *kfont;
char *ofont;

main(argc,argv) int argc; char *argv[]; {
	int size;
	char *fnt;
	char buf[256];
	FILE *fp;
	int fd;
	int code,xcode;
	int mode;
	int c;
	int tmp;
	int abytes;

	while ((c=getopt(argc,argv,"w:h:a:k:o:")) != -1) {
		switch(c) {
		case 'w':
			if (sscanf(optarg,"%d",&tmp)==1) {
				width = tmp;
			}
			break;
		case 'h':
			if (sscanf(optarg,"%d",&tmp)==1) {
				height = tmp;
			}
			break;
		case 'a':
			afont = optarg;
			break;
		case 'k':
			kfont = optarg;
			break;
		case 'o':
			ofont = optarg;
			break;
		}
	}
	if (height == 0 || width == 0 || !afont || !kfont || !ofont) {
		printf("usage bdftomgl -w width -h height -a ank_bdf -k kanji_bdf -o output mgl_font\n");
		exit(1);
	}
	printf("converting ANK %s kanji %s to mgl %s width = %d height = %d\n",
		afont,kfont,ofont,width,height);

	awidth = (width/2+7)/8;
	kwidth = (width+7)/8;
	abytes = awidth * height * 256;

	size = 32+abytes+kwidth*height*8064;
	fnt = (char *)malloc(size);
	memset(fnt,0,size);
	mode = -2;

	sprintf(fnt,"#MGLFONT01%02d%02d",width,height);

	fp = fopen(afont,"r");
	while (fgets(buf,256,fp) != NULL) {
		if (sscanf(buf,"STARTCHAR %x",&code)==1) {
		} else if (sscanf(buf,"ENCODING %d",&code)==1) {
		} else if (!strncmp(buf,"BITMAP",6)) {
			mode = -1;
		} else if (!strncmp(buf,"ENDCHAR",7)) {
			mode = -2;
		}
		if (mode >= 0 && sscanf(buf,"%x",&c) == 1) {
		    if (awidth == 1) {
			fnt[32 + code * awidth * height + mode] = c;
		    } else {
			fnt[32 + code * awidth*height + mode*2] = (c >> 8) & 0xff;
			fnt[32 + code * awidth*height + mode*2 + 1] = c & 0xff;
		    }
		}
		if (mode >= -1) mode ++;
	}
	fclose(fp);

	fp = fopen(kfont,"r");
	while (fgets(buf,256,fp) != NULL) {
		if (sscanf(buf,"STARTCHAR %x",&code)==1) {
			xcode = ((code & 0xff) - 0x20)
				+ (((code >> 8) & 0xff) - 0x21) * 96;
		} else if (sscanf(buf,"ENCODING %d",&code)==1) {
			xcode = ((code & 0xff) - 0x20)
				+ (((code >> 8) & 0xff) - 0x21) * 96;
		} else if (!strncmp(buf,"BITMAP",6)) {
			mode = -1;
		} else if (!strncmp(buf,"ENDCHAR",7)) {
			mode = -2;
		}
		if (mode >= 0 && sscanf(buf,"%x",&c) == 1) {
		   if (xcode < 8064) {
		     if (kwidth == 2) {
			fnt[32 + abytes + xcode * kwidth*height + mode*2] = (c >> 8) & 0xff;
			fnt[32 + abytes + xcode * kwidth*height + mode*2+ 1] = c & 0xff;
		     } else if (kwidth == 3) {
			fnt[32 + abytes + xcode * kwidth*height + mode*3] = (c >> 16) & 0xff;
			fnt[32 + abytes + xcode * kwidth*height + mode*3+ 1] = (c>> 8) & 0xff;
			fnt[32 + abytes + xcode * kwidth*height + mode*3+ 2] = c & 0xff;
		     }
		   }
		}
		if (mode >= -1) mode ++;
	}
	fclose(fp);

printf("outputfile %s\n",ofont);
	if (!ofont) ofont = "tmp.fnt";
	fd = creat(ofont,0666);
	if (fd < 0) {
		perror("write open");
		exit(1);
	}
	write(fd,fnt,size);
	close(fd);
}
