// 
// hash.h -- simple hash support
//

//
// Copyright (c) 2004 Dean Gaudet <dean@arctic.org>
// 
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
// OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
// 

// $Id: hash.h,v 1.1 2004/11/08 01:54:59 dean Exp $

#ifndef HASH_H_INCLUDED
#define HASH_H_INCLUDED

#include <stddef.h>

typedef struct hash_str hash_t;

// create a hash with a first level of 2**n_bits
hash_t *hash_create(size_t n_bits);

// free a hash
void hash_destroy(hash_t *h);

// free a hash and call free(value) on each element
void hash_destroy_and_free_value(hash_t *h);

// number of elements in hash
size_t hash_n_elts(hash_t *h);

// lookup an element in hash
void *hash_lookup(hash_t *h, const void *key, size_t key_len);

// insert key into hash -- assumes no match
void hash_insert(hash_t *h, const void *key, size_t key_len, void *value);

// a linearized hash is an array of hash_linear_t ... one for each
// element in the hash.  the caller must free the result afterwards
typedef struct {
	const void *key;
	size_t key_len;
	void *value;
} hash_linear_t;

hash_linear_t *hash_linearize(hash_t *h);

#endif
