//
// this is just a testing tool so i can understand pcap_findalldevs
//

// 
// Copyright (c) 2004 Dean Gaudet <dean@arctic.org>
// 
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
// OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
// 

// $Id: devlist.c,v 1.4 2004/11/08 01:54:59 dean Exp $

#define _BSD_SOURCE 1
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <assert.h>
#include <signal.h>
#include <sys/time.h>
#include <errno.h>
#include <pcap.h>
#include <sys/socket.h>
#if defined(__linux__) || defined(__FreeBSD__)
#include <net/ethernet.h>
#endif
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#if defined(__NetBSD__)
#include <net/if.h>
#include <net/if_ether.h>
#endif
#include <arpa/inet.h>
#ifdef AF_PACKET		// linux
#include <netpacket/packet.h>
#endif
#ifdef AF_LINK			// netbsd
#include <net/if_dl.h>
#endif


static void print_addr(struct sockaddr *sa)
{
	char buf[INET6_ADDRSTRLEN];

	switch (sa->sa_family) {
	case AF_INET:
		printf("AF_INET   %s\n",
			inet_ntop(AF_INET, &((struct sockaddr_in *)sa)->sin_addr, buf, sizeof(buf)));
		break;
	case AF_INET6:
		printf("AF_INET6  %s\n",
			inet_ntop(AF_INET6, &((struct sockaddr_in6 *)sa)->sin6_addr, buf, sizeof(buf)));
		break;
#ifdef AF_PACKET
	case AF_PACKET:
		{
			int i;

			printf("AF_PACKET ");
			for (i = 0; i < ((struct sockaddr_ll *)sa)->sll_halen; ++i) {
				printf("%s%02x", i ? ":" : "", ((struct sockaddr_ll *)sa)->sll_addr[i]);
			}
			printf("\n");
		}
		break;
#endif
#ifdef AF_LINK
	case AF_LINK:
		printf("AF_LINK   %s\n", link_ntoa((struct sockaddr_dl *)sa));
		break;
#endif
	default:
		printf("AF_%u\n", sa->sa_family);
		break;
	}
}

int main(int argc, char **argv)
{
	char errbuf[PCAP_ERRBUF_SIZE];
	pcap_if_t *devlist;
	pcap_addr_t *addr;

	if (pcap_findalldevs(&devlist, errbuf) == -1) {
		fprintf(stderr, "pcap_findalldevs: %s\n", errbuf);
		exit(1);
	}
	while (devlist) {
		printf("%s %s %s\n",
			devlist->name,
			devlist->description ? devlist->description : "",
			(devlist->flags & PCAP_IF_LOOPBACK) ? "PCAP_IF_LOOPBACK" : "");
		addr = devlist->addresses;
		while (addr) {
			printf("\taddr:      "); print_addr(addr->addr);
			if (addr->netmask) { printf("\tnetmask:   "); print_addr(addr->netmask); }
			if (addr->broadaddr) { printf("\tbroadaddr: "); print_addr(addr->broadaddr); }
#ifndef __FreeBSD__
			// dstaddr had some bogus value on freebsd... resulting in a segfault
			if (addr->dstaddr) { printf("\tdstaddr:   "); print_addr(addr->dstaddr); }
#endif
			addr = addr->next;
		}
		devlist = devlist->next;
	}
	return 0;
}
