#include <config.h>
#ifdef HAVE_ENCA
#include "encadetector.h"

Detector::LangList ENCADetector::langList;

const Detector::LangList &ENCADetector::getLanguages()
{
if(langList.empty())
  {
  size_t n;
  const char **langs=enca_get_languages(&n);
  for(int i=0;i<n;i++)
     {
     LangInfo info;
     info.code=langs[i];
     if(info.code=="__")
       continue;
     info.name=enca_language_english_name(langs[i]);
     langList.push_back(info);
     }
  }
return langList;
}

ENCADetector::ENCADetector(const string &aDefaultCharset,const string &aLang):
              Detector(aDefaultCharset,aLang),changed(true)
{
analyser=enca_analyser_alloc(lang.c_str());
}

ENCADetector::~ENCADetector()
{
enca_analyser_free(analyser);
}

void ENCADetector::scan(const string &s)
{
Detector::scan(s);
buffer+=s;
changed=true;
}

string ENCADetector::getCharset() const
{
if(changed)
  {
  encoding=enca_analyse_const(analyser,
                       reinterpret_cast<const unsigned char *>(buffer.c_str()),
                       buffer.length());
  changed=false;
  }
if(enca_charset_is_known(encoding.charset))
  {
  const char *name=enca_charset_name(encoding.charset,ENCA_NAME_STYLE_ICONV);
  if(name!=NULL)
    return name;
  else
    return defaultCharset;
  }
else
  return defaultCharset;
}
#endif /* HAVE_ENCA */
