/*
  upgradewin.c
  
  for Final Battle
  
  Bill Kendrick
  Last modified: 4/2/98
  
  Routines to redraw the upgrades window.
*/


#include <stdio.h>
#include "const.h"
#include "glovar.h"
#include "types.h"
#include "upgradewin.h"
#include "lib/text.h"
#include "graphics.h"


void drawupgradewin(int pln)
{
  int i, fh2;
  
  XClearWindow(display[pln], upgradewin[pln]);
  
  for (i = 0; i < NUM_SHOWN_UPGRADES; i++)
    {
      drawbitmap(display[pln], upgradewin[pln], upgradegc[pln], 8, i * 33,
		 upgradeupgradebitmaps[pln][upgradenums[i]]);
      drawtext(display[pln], upgradewin[pln], upgradegc[pln],
	       48, i * 33 + fh[pln], upgrade_name_strings[upgradenums[i]]);
    }
  
  updateupgradewin(pln);
}


void updateupgradewin(int pln)
{
  int i, ii, v, light;
  char str[100];
  
  for (i = 0; i < UNIQUE_UPGRADES - 1; i++)
    {
      ii = upgradenums[i];
      light = 0;
      v = -1;
      
      /* Yuck!  It's hard-coded! */
      
      if (ii == UPGRADE_CLOAK)
	v = player[pln].can_radar_cloak;
      else if (ii == UPGRADE_TOTALCLOAK)
	v = player[pln].can_total_cloak;
      else if (ii == UPGRADE_CLOAKRADAR)
	{
	  if (player[pln].cloakradar == 0)
	    {
	      strcpy(str, "Inactive ");
	      light = 0;
	    }
	  else
	    {
	      strcpy(str, "Activated");
	      light = 1;
	    }
	}
      else if (ii == UPGRADE_WARP)
	v = player[pln].warp;
      else if (ii == UPGRADE_HOME)
	v = player[pln].home;
      else if (ii == UPGRADE_AUTO)
	v = player[pln].autop;
      else if (ii == UPGRADE_SPEED)
	{
	  if (player[pln].max == MAX_SPEED)
	    {
	      strcpy(str, "Normal");
	      light = 0;
	    }
	  else
	    {
	      strcpy(str, "Fast  ");
	      light = 1;
	    }
	}
      
      if (v != -1)
	{
	  if (v == 0)
	    light = 0;
	  else
	    light = 1;
	  
	  sprintf(str, "%d   ", v);
	}
      
      drawtext(display[pln], upgradewin[pln], upgradegc_colors[pln][light],
	       48, i * 33 + fh[pln] * 2, str);
    }
}
