/*
   movement.h
   
   for Final Battle

   Mike Hufnagel & Bill Kendrick
   Previously modified: 11/26/95
   Last modified: 12/4/97

   Handles movements, and collisions detection of all objects.
*/

#ifndef MOVEMENT_H
#define MOVEMENT_H

void collision(int pln);
/* 
   Determines whether player "pln" has collided with anything.
*/

void moveasteroid(void);
/*
   Moves all the asteroids in the universe.
*/

void movedrone(void);
/*
   Moves all the drones in the universe.
*/

void movedebris(void);
/*
   Moves all the debris in the universe.
*/
   
void moveship(int pln);
/* 
   Handles player "pln"'s ship movement due to thrust and keeps it in bounds
   (or wraps it around).
*/

void moveupgrades(void);
/*
   Moves all the upgrade icons in the universe.
*/

void moveweapon(void);
/*
   Moves all the bullets, missles etc. in the universe.
*/

int nearest_ship(int x, int y, int pln);
/* 
   Returns the player-number of the ship closest to (x,y), as long as
   it's not player number "pln" (because player "pln" IS ALWAYS the closest
   ship to player "pln"!).
*/

void movewormhole(void);
/*
  Moves womehole.
*/

void wormholetest(int *x, int *y, int goaway);
/*
  If x,y are within the wormhole, they are warped.  The wormhole goes
  away if "goaway" is 0.
*/

#endif /* MOVEMENT_H */
