/*
  event.c
  
  for Final Battle
  
  Mike Hufnagel & Bill Kendrick
  Previously modified: 12/8/95
  Last modified: 4/2/98
*/

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include "commwin.h"
#include "const.h"
#include "event.h"
#include "glovar.h"
#include "movement.h"
#include "types.h"
#include "radarwin.h"
#include "weaponwin.h"
#include "lib/rndm.h"
#include "lib/connect.h"
#include "actionwin.h"


/* Local prototypes */

void add_server(void);
void undo_title(int pln);
void quit(int pln);
void alert_selected_weapon(int pln);
void stophoming(int pln);


void button_event(int pln, Window whichwin, int x, int y, unsigned int but)
{
  int dam;
  char str[100];


  /* First off, a click in any window gets rid of the title */
  
  if (title_exist[pln])
    undo_title(pln);
  
  if (whichwin == radarwin[pln])
    {
      if (but == Button1)
	{
	  /* --- They selected a warp, auto- or homing-pilot position --- */
	  
	  /* Correct x/y proportions based on their radar window's aspect */
	  
	  x = x * (WIDTH_OF_WORLD / radargeom[pln].w);
	  y = y * (HEIGHT_OF_WORLD / radargeom[pln].h);
	  
	  if (player[pln].warp)
	    {
	      /* Take them directly to the mouse position */
	      
	      player[pln].x = x;
	      player[pln].y = y;
	      actionmessage(pln, "Warp engaged");
	      
	      /* They've used one up! */
	      
	      player[pln].warp--;
	      
	      drawradar(pln);
	    }
	  else if (player[pln].home)
	    {
	      /* Determine the player they want (closest to the mouse) */
	      
	      if ((player[pln].homeship = nearest_ship(x, y, pln)) != -1)
		{
		  /* That ship's position is where they want to go */
		  
		  player[pln].homingmode = HOME_HOMING;
		  player[pln].homex = player[player[pln].homeship].x;
		  player[pln].homey = player[player[pln].homeship].y;
		  actionmessage(pln, "Ship homing engaged");
		}
	      else
		{
		  /* (Hmm.. they must be the only player..) */
		  
		  complain(pln, "Ship homing cannot engage");
		}
	      
	     
	      /* They've used one up! */
	      
	      player[pln].home--;
	    }
	  else if (player[pln].autop)
	    {
	      /* The mouse button position is where to home in on */
	      
	      player[pln].homingmode = HOME_AUTO;
	      player[pln].homex = x;
	      player[pln].homey = y;
	      
	      actionmessage(pln, "Autopilot engaged");
	      
	      /* They've used one up! */
	      
	      player[pln].autop--;
	    }
	  else
	    {
	      /* No upgrade available! */
	      
	      complain(pln, "No radar-based command available!");
	    }
	}
      else if (but == Button3)
	{
	  stophoming(pln);
	}
    }
  else if (whichwin == damagewin[pln])
    {
      /* Which line did they click? */
      
      dam = (y / (fh[pln] + 2)) - 1;
      
      if (dam >= 0 && dam < UNIQUE_DAMAGABLES)
	{
	  /* Assign or unassign people: */
	  
	  if (but == Button1)
	    {
	      if (player[pln].crew_free > 0 &&
		  player[pln].damage[dam] != OK)
		{
		  player[pln].crew_working[dam]++;
		  player[pln].crew_free--;
		  
		  updatedamagewin(pln);
		}
	    }
	  else if (but == Button3)
	    {
	      if (player[pln].crew_working[dam] > 0)
		{
		  player[pln].crew_free++;
		  player[pln].crew_working[dam]--;
		  
		  updatedamagewin(pln);
		}
	    }
	}
      else if (dam >= UNIQUE_DAMAGABLES && dam < UNIQUE_DAMAGABLES + 2)
	{
	  /* Cryo- -store or -unstore people: */
	  
	  if (but == Button1)
	    {
	      if (player[pln].crew_free > 0)
		{
		  player[pln].crew_frozen++;
		  player[pln].crew_free--;
		  
		  updatedamagewin(pln);
		}
	    }
	  else if (but == Button3 && player[pln].crew_frozen > 0)
	    {
	      if (player[pln].crew_working[dam] > 0)
		{
		  player[pln].crew_free++;
		  player[pln].crew_frozen--;
		  
		  updatedamagewin(pln);
		}
	    }
	}
    }
  else if (whichwin == commwin[pln])
    {
      /* They can enter a message: */
      
      if (sending_message[pln] == 0)
	{
	  sending_message[pln] = 1;
	  message_size[pln] = 0;
	  actionmessage(pln, "Enter message. RETURN to send, ESC to abort");
	}
    }
  else if (whichwin == weaponwin[pln])
    {
      /* Choose a weapon: */
      
      if (y / 32 < UNIQUE_WEAPONS)
	{
	  if (player[pln].weapons[y / 32] != 0)
	    {
	      player[pln].current_weapon = y / 32;
	      alert_selected_weapon(pln);
	    }
	  else
	    {
	      sprintf(str, "You have no %s-weapon ammunition!",
		      weapon_name_strings[y / 32]);
	      complain(pln, str);
	    }
	}
      else
	complain(pln, "Opps!");
    }
}

void client_event(int pln)
{
  if (event.xclient.message_type == XA_STRING)
    {
      /* XA_STRING?  Must be someone wanting to join in! */
      
      add_server();
    }
  else if ((event.xclient.message_type == wm_protocols) &&
	   (event.xclient.data.l[0] == wm_delete_window))
    {
      /* wm_protocols?  Must be someone trying to kill our window!! */
      
      quit(pln);
    }
}

void configure_event(int pln, Window whichwin, int w, int h)
{
  if (whichwin == actionwin[pln])
    {
      /* Action window resizes: */
      
      actiongeom[pln].w = w;
      actiongeom[pln].h = h;
    }
  else if (whichwin == radarwin[pln])
    {
      /* Radar window resizes: */
      
      radargeom[pln].w = w;
      radargeom[pln].h = h;
    }
}


void map_event(int pln)
{
  /* DANGEROUS CODE! :)  */
  /*
  XMapRaised(display[pln], damagewin[pln]);
  XMapRaised(display[pln], radarwin[pln]);
  XMapRaised(display[pln], weaponwin[pln]);
  XMapRaised(display[pln], upgradewin[pln]);
  XMapRaised(display[pln], commwin[pln]);
  XMapRaised(display[pln], realactionwin[pln]);
  */
}


void expose_event(int pln, Window whichwin)
{
  map_event(pln);
  
  if (whichwin == damagewin[pln])
    drawdamagewin(pln);
  else if (whichwin == upgradewin[pln])
    drawupgradewin(pln);
  else if (whichwin == commwin[pln])
    drawcomm(pln);
  else if (whichwin == weaponwin[pln])
    drawweaponwin(pln);
  else if (whichwin == titlewin[pln] && title_exist[pln])
    {
      /* Draw into title window now that it's up! */
      
      XClearWindow(display[pln], titlewin[pln]);
      XCopyPlane(display[pln], titlebitmap[pln], titlewin[pln],
		 titlegc[pln], 0, 0, titlew, titleh, 0, 0, 1);
    }
  /* (All other windows redrawn every frame anyways) */
}


void kbd_event(int pln)
{
  char string[20], key;
  char str[100], temp[1024];
  int i, j, need_fixing, old_crew_free, added_crew;
  
  
  /* First off, a keypress in any window gets rid of the title */
  
  if (title_exist[pln])
    undo_title(pln);
  
  map_event(pln);
  
  
  /* Check normal keys */
  
  if (XLookupString(&event.xkey, string, 1, &keysym, &composestatus) != 0)
    {
      key = toupper(string[0]);
      
      if (sending_message[pln] == 0)
	{
	  if (key == FIRE)
	    {
	      /* Fire a weapon: */
	      
	      if ((player[pln].damage[DAM_WEAPONS] == OK) ||
		  ((player[pln].damage[DAM_WEAPONS] == DAMAGED) &&
		   (rndm(10) < 5)))
		{
		  fireweapon(pln);
		  updateweaponwin(pln);
		}
	    }
	  else if (key == REPAIR)
	    {
	      /* Auto-repair stuff: */
	      
	      need_fixing = 0;
	      
	      for (j = 0; j < UNIQUE_DAMAGABLES; j++)
		{
		  if (player[pln].damage[j] == DAMAGED)
		    need_fixing = need_fixing + 1;
		  else if (player[pln].damage[j] == DESTROYED)
		    need_fixing = need_fixing + 2;
		}
	      
	      old_crew_free = player[pln].crew_free;
	      
	      if (need_fixing == 0)
		{
		  complain(pln, "Nothing needs fixing!");
		}
	      else
		{
		  if (old_crew_free != 0)
		    {
		      for (j = 0; j < UNIQUE_DAMAGABLES; j++)
			{
			  added_crew = 0;
			  
			  if (player[pln].damage[j] == DAMAGED)
			    added_crew = old_crew_free / need_fixing;
			  else if (player[pln].damage[j] == DESTROYED)
			    added_crew = (old_crew_free / need_fixing) * 2;
			  
			  player[pln].crew_working[j] = 
			    player[pln].crew_working[j] + added_crew;
			  
			  player[pln].crew_free =
			    player[pln].crew_free - added_crew;
			  
			  if (added_crew != 0)
			    {
			      sprintf(temp, "Added %d crew to fix %s.",
				      added_crew, damagable_name_strings[j]);
			      message(pln, GOD, temp);
			    }
			}
		    }
		  else
		    {
		      complain(pln, "No free crew! Unassign some first!");
		    }
		  
		  updatedamagewin(pln);
		} /* (if need_fixing==0 else) */
	    }
	  else if (key == UNREPAIR)
	    {
	      /* Repair unassignment stuff: */
	      
	      for (j = 0; j < UNIQUE_DAMAGABLES; j++)
		{
		  player[pln].crew_free +=
		    player[pln].crew_working[j];
		  
		  player[pln].crew_working[j] = 0;
		}		  
	      
	      updatedamagewin(pln);
	    }
	  else if (key == WEAPON_SELECT)
	    {
	      /* Select next available weapon: */
	      
	      do
		{
		  player[pln].current_weapon = (player[pln].current_weapon + 1)
		    % UNIQUE_WEAPONS;
		}
	      while (player[pln].weapons[player[pln].current_weapon] == 0);
	      
	      alert_selected_weapon(pln);
	    }
	  else if (key == RADAR_CLOAK)
	    {
	      if (player[pln].cloaked == CLOAK_NORMAL)
		player[pln].cloaked = 0;
	      else
		{
		  if (player[pln].can_radar_cloak != 0)
		    {
		      player[pln].cloaked = CLOAK_NORMAL;
		      player[pln].can_radar_cloak--;
		      message(pln, GOD, "Cloaked from radar.");
		    }
		  else if ((player[pln].can_total_cloak != 0) &&
			   BEST_CLOAK == 1)
		    {
		      player[pln].cloaked = CLOAK_TOTAL;
		      player[pln].can_total_cloak--;
		      complain(pln,
			       "No radar cloak; cloaked totally though!");
		    }
		  else
		    complain(pln, "Can't cloak from radar!");
		}
	      
	      updateupgradewin(pln);
	    }
	  else if (key == TOTAL_CLOAK)
	    {
	      if (player[pln].cloaked == CLOAK_TOTAL)
		player[pln].cloaked = 0;
	      else
		{
		  if (player[pln].can_total_cloak != 0)
		    {
		      player[pln].cloaked = CLOAK_TOTAL;
		      player[pln].can_total_cloak--;
		      message(pln, GOD, "Totally cloaked!");
		    }
		  else if ((player[pln].can_radar_cloak != 0) &&
			   BEST_CLOAK == 1)
		    {
		      player[pln].cloaked = CLOAK_NORMAL;
		      player[pln].can_radar_cloak--;
		      complain(pln,
			       "Can't totally cloak; cloaked from radar only!");
		    }
		  else
		    complain(pln, "Can't totally cloak!");
		  
		  updateupgradewin(pln);
		}
	    }
	  else if (key == MESSAGE_START)
	    {
	      /* Begin accepting a message */
	      
	      sending_message[pln] = 1;
	      message_size[pln] = 0;
	      actionmessage(pln,
			    "Enter message. RETURN to send, ESC to abort");
	    }
	  else if (key == QUIT)
	    quit(pln);
	}
      else
	{
	  /* Accepting a message... */
	  
	  if (message_size[pln] < MAX_MESG_SIZE)
	    {
	      if (isprint(key))
		{
		  message_str[pln][message_size[pln]] = key;
		  message_size[pln]++;
		  message_str[pln][message_size[pln]] = '\0';
		  
		  update_message_str(pln);
		}
	    }
	  else
	    complain(pln, "Message too long! RETURN to send, ESC to abort!");
	}
    }
  
  
  /* Check arrow key (and other wierd) controls: */
  
  if (XKeysymToString(keysym) != NULL)
    {
      strcpy(string, XKeysymToString(keysym));
      
      if (sending_message[pln] == 1 &&
	  (strcmp(string, "KP_Return") == 0 ||
	   strcmp(string, "Return") == 0 ||
	   strcmp(string, "KP_Escape") == 0 ||
	   strcmp(string, "Escape") == 0))
	{
	  /* End (send or abort) message: */
	  
	  sending_message[pln] = 0;
	  
	  if (strcmp(string, "KP_Return") == 0 ||
	      strcmp(string, "Return") == 0)
	    {
	      sprintf(temp, "Message from: %s: %s",
		      name[pln], message_str[pln]);
	      actionmessage_all(temp);
	      message_all(name[pln], message_str[pln]);
	    }
	  else
	    actionmessage(pln, "Message aborted");
	  
	  message_str[pln][0] = '\0';
	  update_message_str(pln);
	}
      else if (sending_message[pln] == 1 &&
	       (strcmp(string, "KP_Delete") == 0 ||
		strcmp(string, "Delete") == 0))
	{
	  /* Delete characters from message: */
	  
	  if (message_size[pln] > 0)
	    {
	      message_size[pln]--;
	      message_str[pln][message_size[pln]] = '\0';
	      
	      update_message_str(pln);
	    }
	}
      else
	{
	  if (strcmp(string, "KP_Right") == 0 ||
	      strcmp(string, "Right") == 0)
	    {
	      arrow_key[pln][KEY_RIGHT] = 1;
	    }
	  
	  if (strcmp(string, "KP_Left") == 0 ||
	      strcmp(string, "Left") == 0)
	    {
	      arrow_key[pln][KEY_LEFT] = 1;
	    }
	  
	  if (strcmp(string, "KP_Up") == 0 ||
	      strcmp(string, "Up") == 0)
	    {
	      arrow_key[pln][KEY_UP] = 1;
	    }
	  
	  if (strcmp(string, "KP_Down") == 0 ||
	      strcmp(string, "Down") == 0)
	    {
	      arrow_key[pln][KEY_DOWN] = 1;
	    } 
	}
    }
}


void kbd_release(pln)
{
  char string[20];


  XLookupString(&event.xkey, string, 1, &keysym, &composestatus);
  
  if (XKeysymToString(keysym) != NULL)
    {
      strcpy(string, XKeysymToString(keysym));
      
      if (strcmp(string, "KP_Right") == 0 ||
	  strcmp(string, "Right") == 0)
	{
	  arrow_key[pln][KEY_RIGHT] = 0;
	}
      
      if (strcmp(string, "KP_Left") == 0 ||
	  strcmp(string, "Left") == 0)
	{
	  arrow_key[pln][KEY_LEFT] = 0;
	}
      
      if (strcmp(string, "KP_Up") == 0 ||
	  strcmp(string, "Up") == 0)
	{
	  arrow_key[pln][KEY_UP] = 0;
	}

      if (strcmp(string, "KP_Down") == 0 ||
	  strcmp(string, "Down") == 0)
	{
	  arrow_key[pln][KEY_DOWN] = 0;
	} 
    }
}



void keep_handling_keyboard_control(int pln)
{
  if (arrow_key[pln][KEY_RIGHT] == 1)
    {
      stophoming(pln);
      
      if (player[pln].damage[DAM_THRUST] == OK ||
	  (player[pln].damage[DAM_THRUST] == DAMAGED &&
	   (rndm(10) < 5)))
	{
	  /* Rotate clockwise ("right") */
	  
	  player[pln].dir =  (player[pln].dir + 1) % 16;
	}
    }
  
  if (arrow_key[pln][KEY_LEFT] == 1)
    {
      stophoming(pln);
      
      if (player[pln].damage[DAM_THRUST] == OK ||
	  (player[pln].damage[DAM_THRUST] == DAMAGED &&
	   (rndm(10) < 5)))
	{
	  /* Rotate counterclockwise ("left") */
	  
	  player[pln].dir = (player[pln].dir - 1);
	  if (player[pln].dir < 0)
	    player[pln].dir = 15;
	    }
    }
  
  if (arrow_key[pln][KEY_UP] == 1)
    {
      stophoming(pln);
      
      if ((player[pln].damage[DAM_ENGINE] == OK) ||
	  ((player[pln].damage[DAM_ENGINE] == DAMAGED) &&
	   (rndm(10) < 5)))
	{
	  /* Thrust */
	  
	  player[pln].xm += xmove[player[pln].dir];
	  player[pln].ym += ymove[player[pln].dir];
	  
	  /* Keep within maximum speed allowed */
	  
	  if (player[pln].xm >= player[pln].max)
	    player[pln].xm = player[pln].max;
	  else if (player[pln].xm <= -player[pln].max)
	    player[pln].xm = -player[pln].max;
	  
	  if (player[pln].ym >= player[pln].max)
	    player[pln].ym = player[pln].max;
	  else if (player[pln].ym <= -player[pln].max)
	    player[pln].ym = -player[pln].max;
	}
    }
  
  if (arrow_key[pln][KEY_DOWN] == 1)
    {
      stophoming(pln);
      
      if ((player[pln].damage[DAM_ENGINE] == OK) ||
	  ((player[pln].damage[DAM_ENGINE] == DAMAGED) &&
	   (rndm(10) < 5)))
	{
	  /* Slow down: */
	  
	  if (DOWN_KEY == 0)
	    {
	      player[pln].xm = player[pln].xm / 2;
	      player[pln].ym = player[pln].ym / 2;
	    }
	  else if (DOWN_KEY == 1)
	    {
	      player[pln].xm -= xmove[player[pln].dir];
	      player[pln].ym -= ymove[player[pln].dir];
	      
	      /* Keep within maximum speed allowed */
	      
	      if (player[pln].xm >= player[pln].max)
		player[pln].xm = player[pln].max;
	      else if (player[pln].xm <= -player[pln].max)
		player[pln].xm = -player[pln].max;
	      
	      if (player[pln].ym >= player[pln].max)
		player[pln].ym = player[pln].max;
	      else if (player[pln].ym <= -player[pln].max)
		player[pln].ym = -player[pln].max;
	    }
	}
    }
}


/* local functions */

void add_server(void)
{
  int i, free_server, x, y;
  char mesgtxt[100];
  char * charptr;
  int len;
  Window TheirRoot;
  int TheirScreen;
  Display * TheirDisp;
  
  x = 10;
  y = 10;
  
  /* Find a free slot */
  
  free_server = -1;
  
  for (i = SERV - 1; i >= 0; i--)
    if (player[i].exist == 0)
      free_server = i;
  
  /* Add this player */
  
  if (free_server != -1)
    {
      strcpy(server[free_server], event.xclient.data.b);
      
      printf("SERVER: %s\n", server[free_server]);
      fflush(stdout);
      
      TheirDisp = ConnectToServer(server[free_server],
				  &TheirScreen, &TheirRoot);
      
      charptr = XFetchBuffer(TheirDisp, &len, 0);
      printf("Received %d bytes, charptr=%d\n", len, charptr);
      
      if (charptr == NULL)
	{
	  strcpy(name[free_server], "HUH!?");
	}
      else
	{
	  for (i = 0; i < len; i++)
	    name[free_server][i] = charptr[i];
	  name[free_server][len] = '\0';
	}
      
      printf("Adding: %s at %s\n", name[free_server], server[free_server]);
      
      if (add(free_server, x, y) != 1)
	{
	  /* Couldn't do it!  Free slot back up (should be already, but...) */
	  player[free_server].exist = 0;
	}
      else
	{
	  /* Tell everyone (ELSE) they've joined */
	  sprintf(mesgtxt, "%s at %s has joined!", name[free_server],
		  server[free_server]);
	  
	  actionmessage_all(mesgtxt);
	  
	  /* Welcome the new player */
	  message(free_server, GOD, "Welcome!");
	}
    }
}

void quit(int pln)
{
  int i;
  char mesgtxt[100];
  
  /* Tell everyone (ELSE) they've gone */

  sprintf(mesgtxt, "%s has left!", name[pln]);
  message_all(GOD, mesgtxt);
  
  disconnect(pln);
  
  actionmessage_all(mesgtxt);
}

void undo_title(int pln)
{
  title_exist[pln] = 0;
  XDestroyWindow(display[pln], titlewin[pln]);
}

void alert_selected_weapon(int pln)
{
  char str[100];
  
  sprintf(str, "%s selected.",
	  weapon_name_strings[player[pln].current_weapon]);
  message(pln, GOD, str);
  updateweaponwin(pln);
}


void stophoming(int pln)
{
  /* They cancelled an auto- or homing-pilot command,
     or arrived there */
  
  
  if (player[pln].homingmode != HOME_NONE)
    {
      player[pln].xm = player[pln].xm / 4;
      player[pln].ym = player[pln].ym / 4;
      
      if (player[pln].homingmode == HOME_AUTO)
	actionmessage(pln, "Auto-pilot disengaged");
      else if (player[pln].homingmode == HOME_HOMING)
	actionmessage(pln, "Homing-pilot disengaged");
      
      player[pln].homingmode = HOME_NONE;
    }
}
