/*
  actionwin.c
  
  for Final Battle

  By Bill Kendrick & Mike Hufnagel
  November 12, 1995 - December 4, 1997
*/

#include "actionwin.h"
#include "graphics.h"
#include "const.h"
#include "glovar.h"
#include "types.h"

void drawactionwin(int pln)
{
  int i;
  
  /* Erase: */
  
  /* XClearWindow(display[pln], actionwin[pln]); */
  
  XFillRectangle(display[pln], actionwin[pln], actioncleargc[pln],
		 0, 0, actiongeom[pln].w, actiongeom[pln].h);
  
  
  /* Stars */
  
  for (i = 0; i < NUM_STARS; i++)
    drawstar(pln, i);
  
  
  /* Ships */
  
  for (i = 0; i < SERV; i++)
    {
      if (player[i].exist)
	drawship(pln, i);
    }
  
  
  /* Draw action window message: */
  
  if (player[pln].playermessage_life != 0)
    {
      drawtext(display[pln], actionwin[pln], actiongc_white[pln],
	       actiongeom[pln].w / 2 -
	       (XTextWidth(font[pln], "x", 1) *
		strlen(player[pln].playermessage) / 2),
	       actiongeom[pln].h / 2 - 16,
	       player[pln].playermessage);
      player[pln].playermessage_life--;
    }
  
  
  /* Weapons */
  
  for (i = 0; i < NUM_WEAPONS; i++)
    {
      if (weapons[i].exist)
	drawweapon(pln,i);
    }
  
  
  /* Asteroids */
  
  for (i = 0; i < NUM_ASTEROIDS; i++)
    {
      if (asteroid[i].exist)
	drawasteroid(pln, i);
    }
  
  
  /* Drones */
  
  for (i = 0; i < NUM_DRONES; i++)
    {
      if (drone[i].exist)
	drawdrone(pln, i);
    }
  
  
  /* Upgrades */
  
  for (i = 0; i < NUM_UPGRADES; i++)
    {
      if (upgrade[i].exist)
	drawupgrade(pln, i);
    }
  
  
  /* Debris */

  for (i = 0; i < NUM_DEBRIS; i++)
    {
      if (debris[i].exist)
	drawdebris(pln, i);
    }
  
  
  /* Deadmen */

  for (i = 0; i < NUM_DEADMAN; i++)
    {
      if (deadman[i].exist)
	drawdeadman(pln, i);
    }
  
  
  /* Wormhole */
  
  if (wormhole.exist)
    drawwormhole(pln);
  
  
  /* Bound the world */
  
  if (player[pln].x <= (actiongeom[pln].w / 2))
    {
      XDrawLine(display[pln], actionwin[pln], actiongc_white[pln], 
		actiongeom[pln].w / 2 - player[pln].x, 0, 
		actiongeom[pln].w / 2 - player[pln].x, actiongeom[pln].h); 
    }
  else if (player[pln].x >= (WIDTH_OF_WORLD - (actiongeom[pln].w / 2)))
    {
      XDrawLine(display[pln], actionwin[pln], actiongc_white[pln], 
		actiongeom[pln].w / 2 + WIDTH_OF_WORLD - player[pln].x + 32, 0, 
		actiongeom[pln].w / 2 + WIDTH_OF_WORLD - player[pln].x + 32, 
		actiongeom[pln].h); 
    }
  if (player[pln].y <= (actiongeom[pln].h / 2))
    {
      XDrawLine(display[pln], actionwin[pln], actiongc_white[pln], 
		0, actiongeom[pln].h / 2 - player[pln].y,
		actiongeom[pln].w, actiongeom[pln].h / 2 - player[pln].y); 
    }
  else if (player[pln].y >= (HEIGHT_OF_WORLD - (actiongeom[pln].h / 2)))
    {
      XDrawLine(display[pln], actionwin[pln], actiongc_white[pln], 
		0, actiongeom[pln].h / 2 + HEIGHT_OF_WORLD - player[pln].y + 32,
		actiongeom[pln].w, 
		actiongeom[pln].h / 2 + HEIGHT_OF_WORLD - player[pln].y + 32); 
    }
}


void actionmessage(int pln, char * message)
{
  strcpy(player[pln].playermessage, message);
  player[pln].playermessage_life = ACTION_WIN_MESSAGE_LENGTH;
}


void actionmessage_all(char * message)
{
  int i;
  
  for (i = 0; i < SERV; i++)
    {
      if (player[i].exist == 1)
	actionmessage(i, message);
    }
}
