#ifndef MACRO_H
#define MACRO_H

#include <stdarg.h> /* required by some curses.h implementations */
#ifdef NEED_NCURSES
#include <ncurses.h>
#else
#include <curses.h>
#endif

struct Macro
{
  chtype *mac;
  size_t len;
};

int mc_start(struct Macro *m, int times);
chtype mc_get(void);
int mc_defstart(void);
int mc_defend(struct Macro *m, int delete);
void mc_null(struct Macro *m);

#endif
