.\"{{{roff}}}\"{{{ Macros
.ds HF 3 3 3 3 3
.ds HP +3 +2 +1
.nr Hb 7
.de Li
.LI "\\$1"
.if \\w'\\$1 'u>\\n(Pin .br
..
.\" variable
.ds V \fI
.ds v \fP
.\" code
.ds C \fB
.ds c \fP
.\" anchor
.ds A \fI
.ds a \fP
.\" emphasize
.ds E \fI
.ds e \fP
.\" keyboard
.ds K \fB
.ds k \fP
.\"}}}
.\"{{{ Title
.ND "February 10th, 2004"
.TL
Fe User Guide
.AU "Michael Haardt <michael@moria.de>"
.AF ""
.AS "" 0.5i
Yet another editor? Yes, and like all other editors, its special
design goals may or may not make it your personal favourite.  Fe
is a folding editor, often also called outline editor.  I believe
that folding is as important as the progress from line editors to
screen editors.  Fe is a small editor and needs little resources,
but still offers many advanced commands.  Instead of an extension
language, that forces learning yet another programming language
and bloats the editor, it is designed as a C library containing
editor primitives and a user interface module.  This module can easily be
changed if you want extensions or a different user interface.
Right now there is only one user interface, which is similar to Emacs,
in particular to the Emacs-like interface of Origami.
.AE
.MT 4 1
.\"}}}
.H 1 "Copyright and usage conditions" \"{{{
\*Cfe\*c (Folding editor) is copyright (c) by Michael Haardt <michael@moria.de>, 1995\(en2004.
.P
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.P
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.P
You should have received a copy of the GNU General Public License along
with this program.  If not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
.P
The source is available from \*Ahttp://www.moria.de/~michael/fe/\*a.
.\"}}}
.H 1 "First things first" \"{{{
The first thing you will notice in fe is the status line, which tells you
a lot: If it starts with a star,
the buffer contains unsaved changes.  Then comes the version number
of the editor.  After, enclosed in parentheses, you see the current
fold language and any modes you should be aware of.  Next is the file
name associated with the buffer you are editing.  If switched on, it
is followed by the cursor position.  As the last, you see the current
local time, which can also be switched off.
.P
At the bottom of the screen is the prompt line.  If you type a command
that consists of multiple keys, you will see any typed but not yet
processed keys.  The notation for keys is:
.VL \n(Pi
.Li \*KC-\*k\*Vchr\*v
Hold the \*KCONTROL\*k key while pressing the character \*Vchr\*v.
Thus, \*KC-f\*k would be: hold the \*KCONTROL\*k key and press \*Kf\*k.
Some people may be used to see \*K^F\*k or \*KCTRL F\*k, here it is
\*KC-f\*k.
.Li \*KM-\*k\*Vchr\*v
If your keyboard has a META key, that prefixes the character with an
\*KESC\*k, then hold it down while typing \*Vchr\*v.  Alternatively,
press the \*KESCAPE\*k key and release it, then press the character
\*Vchr\*v.
.Li \*KM-C-\*k\*Vchr\*v
Hold down \*KMETA\*k and \*KCONTROL\*k while typing \*Vchr\*v.
If you have no \*KMETA\*k key, then press the \*KESCAPE\*k key and
release it, then hold the \*KCONTROL\*k key while pressing the character
\*Vchr\*v.
.LE 1
Several commands print a prompt and put you in a line editor in the
prompt line.  This command line editor has a history function,
used by the cursor \*Kup\*k and \*Kdown\*k keys.  There are history
lists for the following things:
.BL
.LI
File names
.LI
Line numbers
.LI
Strings to search for or replace
.LE 1
The command line editor further does file name completion with the
\*Ktab\*k key (\*KC-i\*k).
.P
Although it is commonly said that you edit a file, what you really doing
is loading the file into a buffer in memory, edit this buffer and later
write it back into a file.  As such, if you do not save the buffer, all
your work, no matter how much, is lost.  It is advised to save regularly,
because the system might crash because of a software or hardware failure.
.P
If you are a new user, then read below for the most important commands:
.VL \n(Pi
.\"{{{ M-x                  -- main menu
.Li \*KM-x\*k
This brings you into the main menu.  Using the menu is slower than
directly typing the commands you want to use, but if you are a new
user, it may help you until you know all commands.  You can leave any
menu with \*KC-g\*k.
.\"}}}
.\"{{{ M-z                  -- save and exit
.Li \*KM-z\*k
Save the buffer and exit the editor.
.\"}}}
.\"{{{ C-x C-c              -- exit
.Li "\*KC-x C-c\*k"
Exit the editor.  If there are unsaved changes, you will be asked if
you want to exit anyway, which means to lose the changes.
.\"}}}
.\"{{{ M-C-l                -- redraw screen
.Li \*KM-C-l\*k
Redraw the screen.  This is useful after you received output from
\*Awrite\*a(1)
.\" Mm2html depends on this break
or \*Atalk\*a(1), or if you got line noise.
.\"}}}
.LE
.\"}}}
.H 1 "Files and Buffers" \"{{{
.VL \n(Pi
.\"{{{ C-x C-b              -- name buffer
.Li "\*KC-x C-b\*k"
Name buffer.
.\"}}}
.\"{{{ C-x C-i              -- insert file
.Li "\*KC-x C-i\*k"
Insert file.  The mark will be set at the beginning of the inserted
file and the cursor will be at its end.
.\"}}}
.\"{{{ C-x C-r              -- load buffer from file
.Li "\*KC-x C-r\*k"
Load buffer from file.  The mark will be set to the end of the file and
the cursor to its beginning.
.\"}}}
.\"{{{ C-x C-s              -- save buffer to file
.Li "\*KC-x C-s\*k"
Save buffer to file.
.\"}}}
.\"{{{ C-x C-w              -- save buffer to new file
.Li "\*KC-x C-w\*k"
Save buffer to a different file.  Fe will ask for a file name and if you want to
omit all fold marks.  Sometimes people insist on getting files that do not contain
all those confusing braces.  ;-)
.\"}}}
.LE
.\"}}}
.H 1 "Arguments" \"{{{
Many commands take an numerical argument.  In general, a positive argument
repeats the command as often as the argument says, whereas a negative
argument repeats the opposite commands as often.  Nevertheless, read
the description of each command to get to know what an argument does
for it, if anything at all.
.VL \n(Pi
.\"{{{ M--                  -- set negative argument
.Li \*KM-\-\*k
This starts setting a negative argument.
.\"}}}
.\"{{{ M-digit              -- set argument
.Li \*KM-\*k\*Vdigit\*v
If used as the first command to set an argument, this sets a positive
argument.  Once you start setting an argument, you can type regular
digits or \*KM-\*k\*Vdigit\*v to continue typing the argument.
.\"}}}
.LE
.\"}}}
.H 1 "Moving the cursor" \"{{{
Moving the cursor is an important thing in an editor.
The most basic commands are:
.\"{{{ picture
.DS CB
.if t \{
.PS
line -> right 1 ; " forward character: C-f" ljust
line -> left 1 from last line.start ; "backward character: C-b " rjust
line -> down 0.5i from last line.start ; "next line: C-n" below
line -> up 0.5i from last line.start ; "previous line: C-p" above
.PE
\}
.if n \{
                    previous line: C-p
                            ^
                            |
                            |
backward character: C-b <---+---> forward character: C-f
                            |
                            |
                            v
                     next line: C-n
\}
.DE
.\"}}}
If you use an argument, any of these will be repeated \*Vargument\*v times.
A negative argument will repeat them just as much, but in the opposite
direction.  If your terminal supports cursor keys, those will work as
well.
.P
Knowing these commands gets the job done, but it will not be efficient
on bigger files.  For that reason, you should also look to use the more
complicated cursor movement commands, they make editing more pleasant and
save much time:
.VL \n(Pi
.\"{{{ C-a                  -- beginning of line
.Li \*KC-a\*k
Go to the beginning of the line.  If the cursor is already at the first
non-white space character of the line, it will go to the very first
character of the line, else to the first non-white space character.
Press \*KC-a\*k a few times to see how it works.
.\"}}}
.\"{{{ C-e                  -- end of line
.Li \*KC-e\*k
Go to the end of the line.  If the cursor is already at the last
non-white space character of the line, it will go to the very last
character of the line, else to the last non-white space character.
.\"}}}
.\"{{{ C-v, next page       -- next page
.Li "\*KC-v\*k, \*Knext page\*k"
Go to the next page or until the end of the current fold.  If an
argument is given, this causes repetition of this command.  If the
argument is negative, the cursor will move to the previous page or the
beginning of the current fold.
.\"}}}
.\"{{{ M-v, previous page   -- previous page
.Li "\*KM-v\*k, \*Kprevious page\*k"
Go to the previous page or until the beginning of the current fold.  If
an argument is given, this causes repetition of this command.  If the
argument is negative, the cursor will move to the next page or until the
end of the current fold.
.\"}}}
.\"{{{ M-<                  -- beginning of buffer
.Li \*KM-<\*k
Go to the beginning of the buffer.
.\"}}}
.\"{{{ M->                  -- end of buffer
.Li \*KM->\*k
Go to the end of the buffer.
.\"}}}
.\"{{{ M-C-n                -- go to last line inside fold
.Li \*KM-C-n\*k
Go to the last line inside the fold.
.\"}}}
.\"{{{ M-C-p                -- go to first line inside fold
.Li \*KM-C-p\*k
Go to the first line inside the fold.
.\"}}}
.\"{{{ M-f                  -- forward word
.Li \*KM-f\*k
Move one word forward.
.\"}}}
.\"{{{ M-b                  -- backward word
.Li \*KM-b\*k
Move one word backward.
.\"}}}
.\"{{{ M-g                  -- Go to line
.Li \*KM-g\*k
Go to line.  The number of the line if given by the argument, if you
specify one, else you will be prompted for it.
.\"}}}
.\"{{{ C-l                  -- center display
.Li \*KC-l\*k
Center display (put the current line in the middle of the display).
This is not a cursor motion, but it saves moving the cursor to get just
the same effect.
.\"}}}
.\"{{{ M-#                  -- go to matching fence
.Li \*KM-#\*k
Go to matching fence, that is a matching paren, brace or bracket.
.\"}}}
.LE
.\"}}}
.H 1 "Editing" \"{{{
.VL \n(Pi
.\"{{{ C-d            -- delete character under cursor
.Li "\*KC-d\*k"
Delete the character under the cursor.  You can not delete fold marks or
remove a newline which could cause two fold marks to be in one line.  An
argument causes deletion of \*Vargument\*v characters under the cursor,
a negative argument causes deletion of \-\*Vargument\*v characters left
to the cursor.
.\"}}}
.\"{{{ C-m            -- insert newline and indent
.Li "\*KC-m\*k, \*KReturn\*k"
Insert a newline character and indent the new line as much as the
previous line.  If auto-indent mode is switched off, \*KC-m\*k and
\*KC-j\*k have reversed meanings.
.\"}}}
.\"{{{ C-j            -- insert newline
.Li "\*KC-j\*k, \*KLinefeed\*k"
Insert a newline character.  If auto-indent mode is switched off,
\*KC-m\*k and \*KC-j\*k have reversed meanings.
.\"}}}
.\"{{{ M-C-d          -- delete word under cursor
.Li "\*KM-C-d\*k"
Delete the word right under the cursor.  You can not delete fold marks
or remove a newline, that could cause two fold marks to be in one line.
An argument causes deletion of \*Vargument\*v words under the cursor, a
negative argument causes deletion of \-\*Vargument\*v words left to the
cursor.
.\"}}}
.\"{{{ M-C-h          -- delete word backwards under cursor
.Li "\*KM-C-h\*k"
Delete the word left to the cursor.  You can not delete fold marks or
remove a newline, that could cause two fold marks to be in one line.  An
argument causes deletion of \*Vargument\*v words left to the cursor, a
negative argument causes deletion of \-\*Vargument\*v words right to the
cursor.
.\"}}}
.\"{{{ C-h, backspace -- delete previous character
.Li "\*KC-h\*k, \*Kbackspace\*k"
Delete the character left to the cursor.  You can not delete fold marks
or remove a newline, that could cause two fold marks to be in one line.
An argument causes deletion of \*Vargument\*v characters left to the
cursor, a negative argument causes deletion of \-\*Vargument\*v
characters under the cursor.
.\"}}}
.\"{{{ C-q            -- quote character
.Li \*KC-q\*k
Quote character.  Sometimes you may want to insert a character, that is
also part of an editor command.  The solution is to quote the character
using this command.  Example: \*KC-q C-@\*k inserts a null character.
Further, this function composes ISO-8859-1 characters from ASCII
characters using the same pair used by many terminals and X11 servers,
e.g. \*Kss\*k gives a sharp s and \*Ka"\*k gives a small a with
diaeresis.  A positive argument inserts as many characters as specified.
.\"}}}
.\"{{{ C-t            -- transpose character
.Li \*KC-t\*k
Transpose characters.
.\"}}}
.\"{{{ C-x =          -- describe line
.Li "\*KC-x =\*k"
Describe line.
.\"}}}
.\"{{{ M-c            -- capitalise word
.Li \*KM-c\*k
Capitalise word.
.\"}}}
.\"{{{ M-l            -- lower case word
.Li \*KM-l\*k
Lower case word.
.\"}}}
.\"{{{ M-u            -- upper case word
.Li \*KM-u\*k
Upper case word.
.\"}}}
.\"{{{ C-x #          -- insert counter
.Li "\*KC-x #\*k"
Insert the value of the counter and increment it.
.\"}}}
.LE
.\"}}}
.H 1 "Regions and the kill ring" \"{{{
A region is the amount of text between an invisible mark you can set
and the cursor.  For many operations, like removing regions, they must
respect the fold structure, i.e.\& you can not remove a region, that only
contains the begin of a fold.  Similar to the cursor, typing at the mark
position pushes the mark forward, so when edit a previously empty buffer,
the mark will always be at its end until you set it elsewhere.
.P
Besides the buffer, that holds your file contents, there is a ring of
buffers for text you have \*Ekilled\*e (which means removed, erased,
wiped out).  You can yank any element of this ring back to your text.
This is universal, as it allows you to duplicate killed
text, move it, exchange regions of text and much more.  Kill commands
that directly follow each other will append the killed text to the
current ring element, but if you do anything else in between, a new
element will be created.
.P
The following commands manipulate regions and the kill ring:
.VL \n(Pi
.\"{{{ C-@, M-.             -- set mark
.Li \*KC-@\*k, \*KM-.\*k
Set the invisible mark, which marks one end of a region at the current
cursor position.  On some terminals, you have to type \*KC-@\*k, on others
\*KCONTROL-space\*k is fine.  Some even accept both.  Some ancient ones
accept neither, which is why there is a second, less handy, keyboard
command.
.\"}}}
.\"{{{ C-x C-x              -- swap cursor and mark
.Li "\*KC-x C-x\*k"
Swap cursor and mark.
.\"}}}
.\"{{{ C-k                  -- kill to end of line
.Li \*KC-k\*k
This command kills all text from the cursor position to the end of the
line.  If the concerned part contains the beginning of a fold, the whole
fold will be killed.  If the line is empty, the terminating new line
character will be killed.  This is a short-cut for setting a mark, moving
the cursor appropiately and killing the region.
.\"}}}
.\"{{{ C-w                  -- kill region
.Li \*KC-w\*k
Kill region.
.\"}}}
.\"{{{ M-w                  -- copy region
.Li \*KM-w\*k
Copy region.
.\"}}}
.\"{{{ C-y                  -- yank current kill ring element back
.Li \*KC-y\*k
Yank kill ring element back.
.\"}}}
.\"{{{ M-y                  -- move backward in kill ring
.Li \*KM-y\*k
Replace the just yanked back text with the previous element of the kill ring.
That way you can browse through the kill ring until you found what you are
looking for.  A negative argument moves forward.
.\"}}}
.\"{{{ C-x C-f              -- filter region
.Li "\*KC-x C-f\*k"
Filter region.  The marked region will be read as standard input by
the command which name you will be prompted for.  The standard output
of this command replaces the marked region, if the command terminated
successfully and if it could be read correctly.  Further, the old and the
new contents are put in the kill ring, so if filtering did not generate
the intended result, you can walk back in the kill ring with \*KM-y\*k
to get the old region back.  A common application of this function is
to reformat a paragraph by filtering a region through \*Cfmt\*c.
.\"}}}
.\"{{{ C-x |                -- pipe region
.Li "\*KC-x |\*k"
Pipe region.  The marked region will be read as standard input by
the command which name you will be prompted for.  The standard output
of this command will be placed in a new buffer.  This command is useful
to run \*Cspell\*c or \*Cdiction\*c, or just any command that analyses
text.
.\"}}}
.LE
.\"}}}
.H 1 "Folding" \"{{{
.VL \n(Pi
.\"{{{ M-C-@                -- fold region
.Li \*KM-C-@\*k
Fold region.
.\"}}}
.\"{{{ C-u                  -- unfold
.Li \*KC-u\*k
Unfold.
.\"}}}
.\"{{{ C-o                  -- open fold
.Li \*KC-o\*k
Open fold.
.\"}}}
.\"{{{ C-c                  -- close fold
.Li \*KC-c\*k
Close fold.  A positive argument closes the given number of folds, a
negative argument opens them.
.\"}}}
.LE
.\"}}}
.H 1 "Search and replace" \"{{{
.VL \n(Pi
.\"{{{ C-s                  -- incremental search
.Li \*KC-s\*k
Incremental search.  This differs from the usual searching by searching
as you type what to search for, so you can stop typing the rest of the
search string if you already found what you were looking for by typing
its beginning.  Incremental search has the following commands:
.VL \n(Pi
.Li "\*KC-h\*k, \*Kbackspace\*k"
Delete the last character from the search string.
.Li \*KC-s\*k
Move to the next occurence of the search string in the buffer and switch
search direction to forward.
.Li \*KC-r\*k
Move to the previous occurence of the search string in the buffer and
switch search direction to backwards.
.Li "\*KC-p\*k, \*Kcursor up\*k"
Switch to the previous search string in the history.
.Li "\*KC-n\*k, \*Kcursor down\*k"
Switch to the next search string in the history.
.Li "\*KC-q\*k"
Quote/compose character.
.Li "\*KC-g\*k, \*Kcancel\*k"
Abort searching, move the cursor back to where it was before starting
incremental search.  The search string will not be stored in the history.
.Li \*KEnter\*k
Quit searching and leave the cursor where it is.  The search string will
be stored in the history.
.LI "any other character"
Append the character to the search string.
.LE
.\"}}}
.\"{{{ C-r                  -- reverse incremental search
.Li \*KC-r\*k
Incremental search, but starting with search direction backwards.
.\"}}}
.\"{{{ M-C-r                -- search backward
.Li \*KM-C-r\*k
Search backwards, go to the last line, that contains the string you will
be prompted for.
.\"}}}
.\"{{{ M-C-s                -- search forward
.Li \*KM-C-s\*k
Search forward, go to the next line, that contains the string you will
be prompted for.
.\"}}}
.\"{{{ M-R                  -- Search and replace
.Li \*KM-R\*k
Search and replace.  You will be promted for what to search and what
to replace it by.  If no argument is given, all occurences of the search
string from the cursor position until the end of the text will be
replaced.  An argument limits the number of substitutions and a negative
argument causes searching backwards.
.\"}}}
.\"{{{ M-r                  -- Query search and replace
.Li \*KM-r\*k
Query search and replace.  You will be promted for what to search and
what to replace it by.  If no argument is given, you will be asked for
each occurences of the search string from the cursor position until the
end of the text, if you want to replace it.  An argument limits the
number of substitutions and a negative argument causes searching
backwards.  The replace menu offers the following choices:
.VL \n(Pi
.Li Yes
Replace the string and proceed.
.Li No
Do not replace the string and proceed.
.Li "Rest, !"
Replace the rest without asking any more.
.Li Abort
Do not replace the string and abort.
.Li "Replace and abort, ."
Replace the string and abort.
.LE
.\"}}}
.LE
.\"}}}
.H 1 "Modes and variables" \"{{{
.\"{{{ modes
Modes are switches, that change the general behaviour of the editor
for a certain buffer:
.VL \n(Pi
.Li "\*KC-x m\*k \*Vmode\*v"
Adds (enables) the specified mode.
.Li "\*KC-x C-m\*k \*Vmode\*v"
Deletes (disables) the specified mode.
.LE 1
The following modes exist:
.VL \n(Pi
.\"{{{ b
.Li \*Kb\*k
Show begin and end marks of a file in a fashion similar to Origami.
.\"}}}
.\"{{{ i
.Li \*Ki\*k
Auto-indent mode.  While being in this mode, \*Kreturn\*k causes the new
new line to be indented as much as the previous line, while \*KC-j\*k just
creates a new line.  If auto-indent mode is switched off, the two keys
have the reversed function.
.\"}}}
.\"{{{ l
.Li \*Kl\*k
Display the line number of each line.
.\"}}}
.\"{{{ m
.Li \*Km\*k
Magic mode.  Searching (regular and incremental) will search for regular
expressions instead of strings.
.\"}}}
.\"{{{ o
.Li \*Ko\*k
Overwrite characters instead of inserting them.  You can not overwrite
newline characters or fold marks and no auto-indenting will be done
in overwrite mode.
.\"}}}
.\"{{{ p
.Li \*Kp\*k
Show the cursor position in the status line.
.\"}}}
.\"{{{ r
.Li \*Kr\*k
Read-only.  This mode is automatically set, if you load a file on which
you have no write permission.  Fe will offer to check in a file to an
RCS archive, if you set this mode and offer to check it out if you
delete the mode.
.\"}}}
.\"{{{ R
.Li \*KR\*k
Always redraw the screen immediatly instead of only redrawing it when
there are no characters typed ahead.
.\"}}}
.\"{{{ s
.Li \*Ks\*k
Scroll the whole screen sideways instead of only scrolling the current
line.
.\"}}}
.\"{{{ t
.Li \*Kt\*k
Show the current local time in the status line.
.\"}}}
.\"{{{ B
.Li \*KB\*k
Display fold marks in a bold font.
.\"}}}
.LE 1
Additionally, the \*Kinsert\*k key toggles insert/overwrite mode.
.\"}}}
.P
.\"{{{ variables
In contrary to modes, which can only be switched on or off, variables
can be set to one of many values.
.VL \n(Pi
.Li "\*KC-x : \*k\*Vvariable\*v"
Set the specified \*Vvariable\*v.
.LE 1
The following variables exist:
.VL \n(Pi
.\"{{{ d
.Li \*Kd\*k
Display/window size.  The size of a window can be changed by setting this
variable.
.\"}}}
.\"{{{ l
.Li \*Kl\*k
Set the folding language, which determines which comments will be used
to encapsulate fold marks.
.\"}}}
.\"{{{ t
.Li \*Kt\*k
Tab width.  Setting the tab width to 0 causes tabs to be displayed
as ^I.
.\"}}}
.\"{{{ #
.Li \*K#\*k
Counter/increment.  The counter is global for all displays, whereas the
other variables are per-display.  It is handy when enumerating
something and usually used in recorded macros.  Its default value is 0
and the default increment is 1.
.\"}}}
.LE
.\"}}}
.\"}}}
.H 1 "Macros" \"{{{
Sometimes during editing, you will find that you press the same
key sequences over and over.  In that case you should record the
sequence of keys once and then replay it when you need it.  Such
a recorded sequence of keys is called a macro.  The following
commands deal with macros:
.VL \n(Pi
.Li "\*KC-x (\*k"
Start recording a macro.
.Li "\*KC-x )\*k"
Stop recording a macro.
.Li "\*KC-x e\*k"
Execute the previously recorded macro.  A positive argument repeats
the number of executions.
.LE
.\"}}}
.H 1 "Windows" \"{{{
Windows make editing considerably easier.  You can split your screen
and either edit the same file in two windows (which is why windows
are called displays at times) or edit different files.
The following commands split and merge windows:
.VL \n(Pi
.Li "\*KC-x 2\*k"
Split the screen in two windows.
.Li "\*KC-x 0\*k"
Delete the current window.
.Li "\*KC-x o\*k"
Switch to the next window.
.LE
.\"}}}
.H 1 "Shell commands" \"{{{
The following commands are the interface to the shell:
.VL \n(Pi
.Li "\*KC-x c\*k"
Start an interactive sub-shell.
.Li "\*KC-x !\*k"
Start a non interactive shell command.
.Li "\*KC-z\*k"
Suspend fe.
.LE
.\"}}}
.H 1 "A few words on the design of fe" \"{{{
After working with Origami for many years, both as user and developer,
I have decided to implement a new folding editor: fe.  There are a few
basic design decisions which make it different from Origami:
.P
Origami is partially written in its extension language.  While being
more of a hack in the beginning, it has changed to a full programming
language.  As such, it takes time to be learnt.  Code written in it is
not well usable by most people who don't know it.  The conclusion for
fe is not to support any extension language, neither a homebrew one or
a standardised language, like scheme.  Instead, fe is implemented as
a library of basic editor primitives.  Its is easy to write your own
editor by using that library.  fe can be modified easy without
having to learn a new programming language.  The editor also stays
small and elegant this way, while Origami has to offer zillions hooks
for extension functions.
.P
Origami implements folds as double-linked n-trees, with nodes being
single lines or folds.  This allows quick manipulation of folds
or lines.  But region oriented functions become hard to implement and are
mostly not too quick any more.  fe uses a gap buffer to store text, folds
are represented as meta-characters in the flat buffer.  This means basic
fold primitives are slower than in Origami, but more complex and region
oriented functions are faster.  During development of the first prototype
of fe, I found many functions in Origami not to be as canonical as they
should be after I implemented them in fe.  From my past experience, the
performance of typical personal computers to have increased by a factor of 10
every 5 years in the last decade, so the circumstances for
editor design have clearly changed over time.
.P
Folding has its merits, because it adds a structure to flat files.  But,
it also means that by bad structure design and badly commented folds
the file will get harder to understand, not easier.  This can happen
up to the point where you want all folds to be gone to see what the
file contains.  If you need to keep many folds open during development
to see their contents, you are probably prepraring that situation at
least for others.  Although in general I don't like programs forcing
me to do something, fe makes an exception here for two reasons: If the
structure is obvious, you \*Ewant\*e the editor to close folds for
you automatically.  If it is not, you \*Ewant\*e to recognise that
before it is too late.  For that reason, fe closes all folds when you leave them.
If you want to transport code from one fold to another, just split the
current display and edit the file at two places.  If both places are
sufficient far away from each other, that's what you even had to do if
you could leave folds open.
\"}}}
