
#import "XMLParser.h"
#import <stdio.h>

@interface MyXMLParser : XMLParser
{
  int depth;
  FILE *fp;
}

- startElement:(const XML_Char *)qname:(const XML_Char **)atts;
- endElement:(const XML_Char *)qname;
- (int)dataRead:(char *)buff:(int)buflen;
- (FILE *)setfile:(const char *)name;

@end

@implementation MyXMLParser

- startElement:(const XML_Char *)qname:(const XML_Char **)atts
{
  int i;

  for (i=0; i<depth; i++)
    printf("  ");

  printf("%s", qname);

  for (i=0; atts[i]; i+=2)
    printf(" %s='%s'", atts[i], atts[i+1]);

  printf("\n");
  depth++;
}

- endElement:(const XML_Char *)qname
{
  depth--;
}

- (int)dataRead:(char *)buff:(int)buflen
{
  int len;

  len = fread(buff, sizeof(char), buflen, fp);
  return(len);
}

- (FILE *)setfile:(const char *)name
{
  fp = fopen(name, "r");
  return(fp);
}

@end

int
main(int argc, char **argv)
{
  id mpr = [[MyXMLParser alloc] init:NULL :'|':8192:
				  (XML_PARSE_STARTELEM | XML_PARSE_ENDELEM)];

  [mpr setfile:argv[1]];
  [mpr start];
  return(0);
}
