#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <dirent.h>
#include <sys/stat.h>

#ifndef	MAXPATHLEN
#define	MAXPATHLEN	256
#endif

int main(int argc, char **argv)
{
	char *windir, *os;
	char dest[MAXPATHLEN];
	char desktop_pif[MAXPATHLEN];
	char destination[MAXPATHLEN];
	size_t size;
	void *buff;
	FILE *fp;
	DIR *dir;
	struct dirent *de;

	if (argc < 2) {
		fprintf(stderr, "usage: %s piffile.pif\n", argv[0]);
		return -1;
	}

	windir = getenv("WINDIR");
	os = getenv("OS");
	if (NULL != os && 0 == strcasecmp(os, "Windows_NT")) {
		sprintf(dest, "%s\\Profiles\\All Users",
			windir);
		mkdir(dest, 0);
		sprintf(dest, "%s\\Profiles\\All Users\\Desktop",
			windir);
		mkdir(dest, 0);
		sprintf(desktop_pif, "%s\\Profiles\\All Users\\Desktop\\ENTROPY.pif",
			windir);
	} else {
		sprintf(dest, "%s\\Desktop",
			windir);
		mkdir(dest, 0);
		sprintf(desktop_pif, "%s\\Desktop\\ENTROPY.pif",
			windir);
	}
	fp = fopen(argv[1], "rb");
	if (NULL == fp) {
		fprintf(stderr, "piffile '%s' not found! (%s)\n",
			argv[1], strerror(errno));
		return -1;
	}
	fseek(fp, 0, SEEK_END);
	size = ftell(fp);
	buff = malloc(size);
	if (NULL == buff) {
		fprintf(stderr, "out of memory (%d)! (%s)\n",
			size, strerror(errno));
		return -1;
	}
	fseek(fp, 0, SEEK_SET);
	fread(buff, size, 1, fp);
	fclose(fp);

	fp = fopen(desktop_pif, "wb");
	fwrite(buff, size, 1, fp);
	fclose(fp);
	free(buff);

	sprintf(dest, "%c:\\progra~1", windir[0]);
	sprintf(destination, "%s\\entropy-%s.%s",
		dest, NODE_VER_MAJ, NODE_VER_MIN);
	mkdir(destination, 0);
	sprintf(destination, "%s\\entropy-%s.%s\\de",
		dest, NODE_VER_MAJ, NODE_VER_MIN);
	mkdir(destination, 0);
	sprintf(destination, "%s\\entropy-%s.%s\\tmp",
		dest, NODE_VER_MAJ, NODE_VER_MIN);
	mkdir(destination, 0);

	dir = opendir(".");
	while (NULL != (de = readdir(dir))) {
		if (0 == strcmp(de->d_name, "."))
			continue;
		if (0 == strcmp(de->d_name, ".."))
			continue;
		if (0 == strcasecmp(de->d_name, argv[1]))
			continue;
		printf("Copying %s", de->d_name);
		fp = fopen(de->d_name, "rb");
		if (NULL == fp) {
			fprintf(stderr, "failed to read '%s'! (%s)\n",
				de->d_name, strerror(errno));
			return -1;
		}
		fseek(fp, 0, SEEK_END);
		size = ftell(fp);
		buff = malloc(size);
		if (NULL == buff) {
			fprintf(stderr, "\nout of memory (%d)! (%s)\n",
				size, strerror(errno));
			return -1;
		}
		fseek(fp, 0, SEEK_SET);
		fread(buff, size, 1, fp);
		fclose(fp);
		printf(" %d Bytes...\n", size);
		if (0 == strcasecmp(de->d_name, "entropy.lo"))
			sprintf(destination, "%s\\entropy-%s.%s\\de\\%s",
				dest, NODE_VER_MAJ, NODE_VER_MIN, de->d_name);
		else
			sprintf(destination, "%s\\entropy-%s.%s\\%s",
				dest, NODE_VER_MAJ, NODE_VER_MIN, de->d_name);
		fp = fopen(destination, "wb");
		if (NULL == fp) {
			fprintf(stderr, "\nfailed to create '%s' (%s)\n",
				destination, strerror(errno));
		} else {
			fwrite(buff, size, 1, fp);
			fclose(fp);
		}
		free(buff);
	}
	closedir(dir);

	printf("Press any key...");
	fgetc(stdin);	
	return 0;
}
