/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: temp.h,v 1.3 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_temp_h_
#define	_temp_h_

#include "osd.h"

/* Up to what size should we keep files in memory? */
#define	TEMP_MEMORY_LIMIT	(size_t)(512*1024)
/* Use this for files of unknown size */
#define	TEMP_UNKNOWN_SIZE	(size_t)-1

#undef	FILE_LINE_ARGS
#undef	FILE_LINE_PARMS
#define	TMP_DEBUG 1
#if	TMP_DEBUG
#define	FILE_LINE_ARGS	, char *file, uint32_t line
#define	FILE_LINE_PARMS	, __FILE__, __LINE__
#else
#define	FILE_LINE_ARGS
#define	FILE_LINE_PARMS
#endif

typedef enum temptype_e {
	TEMP_INVALID,
	TEMP_MEMORY,
	TEMP_EXPANDABLE,
	TEMP_FILESYSTEM
}	temptype_t;

typedef struct tempfile_s {
	char name[63+1];
	temptype_t type;
	int fd;
	size_t rpos;
	size_t wpos;
	size_t wmax;
	size_t size;
	void *data;
}	tempfile_t;

#ifdef	__cplusplus
extern "C" {
#endif

int _temp_invalid(tempfile_t *tf FILE_LINE_ARGS);
int _temp_binary(tempfile_t *tf, const char *name, size_t size FILE_LINE_ARGS);
int _temp_closed(tempfile_t *tf, const char *name, size_t size FILE_LINE_ARGS);
int _temp_open(tempfile_t *tf FILE_LINE_ARGS);
int _temp_seek(tempfile_t *tf, off_t offs, int whence FILE_LINE_ARGS);
int _temp_read(tempfile_t *tf, void *buff, size_t size, size_t *pdone
	FILE_LINE_ARGS);
int _temp_write(tempfile_t *tf, const void *buff, size_t size FILE_LINE_ARGS);
int _temp_close(tempfile_t *tf, int dispose FILE_LINE_ARGS);

int temp(void);

#define	temp_invalid(tf) _temp_invalid(tf FILE_LINE_PARMS)
#define	temp_binary(tf,name,size) _temp_binary(tf,name,size FILE_LINE_PARMS)
#define	temp_closed(tf,name,size) _temp_closed(tf,name,size FILE_LINE_PARMS)
#define	temp_open(tf) _temp_open(tf FILE_LINE_PARMS)
#define	temp_seek(tf,offs,whence) _temp_seek(tf,offs,whence FILE_LINE_PARMS)
#define	temp_read(tf,buff,size,pdone) _temp_read(tf,buff,size,pdone FILE_LINE_PARMS)
#define	temp_write(tf,buff,size) _temp_write(tf,buff,size FILE_LINE_PARMS)
#define	temp_close(tf,dispose) _temp_close(tf,dispose FILE_LINE_PARMS)

#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_temp_h_) */
