/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: sock.h,v 1.2 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef _sock_h_
#define _sock_h_

#include "osd.h"

#define	SOCKBUFFSIZE	8192		/* for sock_printf */

typedef struct conn_s {
	int status;						/* connection status */
	int socket;						/* the connected socket */
	struct sockaddr_in address;		/* the connected socket address */
	char peeraddr[64];				/* dotted quad IP address and port */
	char peername[256];				/* the name which the peer claims to be */
	void *temp;						/* temporary user data (client.c) */
	time_t last_io;					/* when did the last io take place? */
	uint32_t minsize;				/* minimum transfer size */
	uint32_t maxsize;				/* maximum size of recv or send buffer */
	int limited;					/* limit bandwidth if non-zero */
	uint64_t in_total;
	uint64_t out_total;
}	conn_t;

enum CONN_STATUS {
	CONN_CLOSED = 0,
	CONN_DNSLOOKUP,
	CONN_CONNECTING,
	CONN_ACCEPTING,
	CONN_CONNECTED,
	CONN_SELECTERROR,
	CONN_EXCEPTION,
	CONN_READERROR,
	CONN_WRITEERROR,
	CONN_EOF,
	CONN_SHUTDOWN,
	CONN_CLOSING
};

#ifdef	__cplusplus
extern "C" {
#endif
int is_local_ip(uint32_t addr, uint32_t myaddr);
int sock_aton(struct sockaddr_in *dst, const char *src);
const char *sock_ntoa(const struct sockaddr_in *src);
const char *conn_status_str(int status);
void conn_status_change(conn_t *conn, int status);
int sock_outgoing(conn_t *conn, const char *hostaddress, int port, int limited);
int sock_incoming(const char *hostaddress, int port, int limited,
	void (*child)(conn_t *conn), int (*post_accept)(void),
	int niceness, const char *listener);
int sock_readall(conn_t *conn, void *buffer, size_t size);
int sock_writeall(conn_t *conn, const void *buffer, size_t size);
int sock_gets(conn_t *conn, char *dst, size_t size);
int sock_agets(conn_t *conn, char **pdst);
int sock_printf(conn_t *conn, const char *fmt, ...);
int sock_shutdown(conn_t *conn);
#ifdef	__cplusplus
}
#endif
#endif /* !defined(_sock_h_) */
