/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: fec.h,v 1.2 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef _fec_h_
#define	_fec_h_

#include "osd.h"

#ifdef	__cplusplus
extern "C" {
#endif

/* encode 8 data blocks of size 'size' and generate fec block 'idx' */
int fec_encode(uint8_t *data, size_t size, int idx, uint8_t *fec);

/* decode 'src' blocks of size 'size' listed in 'idx' and return 'data' */
int fec_decode(uint8_t *data, uint8_t *src[], size_t size, int idx[]);

/* split data into bit chunks and fec_encode the chunks */
int fec84_encode(uint8_t *out, uint8_t *in, size_t size, int flags);

/* fec_decode 8 (or more) out of 12 bit chunks and return raw data */
int fec84_decode(uint8_t *out, uint8_t *in, size_t size, int flags);

/* allocate and initialize tables */
int fec(void);

#ifdef	__cplusplus
}	/* end extern "C" */
#endif
#endif	/* !defined(_fec_h_) */
