static char rcsid[] = "@(#)$Id: elmunidata.c,v 1.12 2001/06/16 10:40:38 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.12 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "elmutil.h"
#include "s_me.h"
#include "s_elm.h"

#include "unidata.h"


extern char *optarg;		
extern int   optind;		

int main(argc, argv)
     int argc;
     char *argv[];
{
  struct mapped_data * unidata = NULL;
  char * target_file = NULL;
  FILE * text_target_file = NULL;
  FILE * logfile = NULL;
  int err = 0;
  int silent_gaps = 0;

  int c;

#if DEBUG
  init_debugfile("ELMUNIDATA");
#endif
  locale_init();
  user_init();
  init_defaults();
  read_rc_file();

  while ((c = getopt(argc, argv, "w:l:sd:b:BIT:")) != EOF) {
    switch(c) {
    case 'w':
	target_file = optarg;
	break;
    case 'I':
	target_file = unidata_path;
	break;
    case 'l':
	logfile = fopen(optarg,"w");
	break;
    case 's':
	silent_gaps = 1;
	break;
    case 'd' : 	
#if DEBUG
	set_debugging(optarg);	  
#else
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
			  "Warning: system created without debugging enabled - request ignored\n"));
#endif
	break;
    case 'B':
	unidata = default_unidata();
	if (!unidata) {
	    err = 1;
	    goto fail;
	}
	lib_error(CATGETS(elm_msg_cat, MeSet, MeFileLoaded,
			  "%s loaded"),
		  raw_unidata_path);
	break;
    case 'b':
	if (!get_unidata(&unidata,optarg)) {
	    err = 1;
	    goto fail;
	}
	lib_error(CATGETS(elm_msg_cat, MeSet, MeFileLoaded,
			  "%s loaded"),
		  optarg);
	break;
    case 'T':
	text_target_file = fopen(optarg,"w");
	break;
    case '?':
	exit(1);
    }
  }


    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);

#ifdef DEBUG
    { 
	int d = panic_dprint("\n\
======================================================\n\
Debug output of the ELMUNIDATA program (version %s).\n",
			     version_buff);

#if 0	
	if (d >= 50) {
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    error_sleep(5+sleepmsg);	    
	}
#endif
    }
#endif


  if (optind < argc) {
      if (!read_unidata_text(&unidata,argv[optind],logfile,
			     silent_gaps)) {

	  err = 1;
	  goto fail;
      }
      if (logfile) {
	  fprintf(logfile,catgets(elm_msg_cat, MeSet, MeFileParsed,
				  "%s parsed"),
		  argv[optind]);
	  putc('\n',logfile);
      }
      lib_error(CATGETS(elm_msg_cat, MeSet, MeFileParsed,
			"%s parsed"),
		argv[optind]);
  }

  if (target_file && unidata) {
      if (!write_unidata(unidata,target_file))
	  exit(1);
  }

  if (text_target_file && unidata) {
      if (!write_unidata_text(unidata,text_target_file))
	  exit(1);
  }

  if (text_target_file)
      fclose(text_target_file);

 fail:

  if (logfile) {
      if (err) {
	  fprintf(logfile,catgets(elm_msg_cat, MeSet, MeProgFailed,
				  "%s failed; exit code=%d"),
		  argv[0],err);
	  putc('\n',logfile);
      }
      fclose(logfile);
  }
  if (err)
      lib_error(CATGETS(elm_msg_cat, MeSet, MeProgFailed,
			"%s failed; exit code=%d"),
		argv[0],err);
  return err;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
