static char rcsid[] = "@(#)$Id: init.c,v 1.26 2001/06/10 14:31:46 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.26 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/***** Initialize - read in all the defaults etc etc 
*****/

#include "headers.h"
#include "patchlevel.h"
#include "s_elm.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"ELM");

#include "me.h"

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}


static void get_term_chars P_((void));

#ifdef TERMIOS
#  include <termios.h>
   typedef struct termios term_buff;
#else
# ifdef TERMIO
#  include <termio.h>
#  define tcgetattr(fd,buf)	ioctl((fd),TCGETA,(buf))
   typedef struct termio term_buff;
# else
#  include <sgtty.h>
typedef struct {
  struct sgttyb sgttyb;
  struct tchars tchars;
#ifdef TIOCLGET
  struct ltchars ltchars;
#endif
} term_buff;
static int tcgetattr P_((int,term_buff *));  /* Prototype */
# endif
#endif

#ifdef PWDINSYS
#  include <sys/pwd.h>
#else
#  include <pwd.h>
#endif

#include <errno.h>

extern int errno;		/* system error number on failure */
extern char version_buff[];

char *error_description();

#ifndef I_UNISTD 
char *getlogin();
unsigned short getgid(), getuid(); 
struct passwd *getpwuid();
#endif

char *get_full_name();

SIGHAND_TYPE
#ifdef SIGTSTP
	sig_user_stop(), sig_return_from_user_stop(),
#endif
#ifdef SIGWINCH
	winch_signal(),
#endif
	quit_signal(), term_signal(), ill_signal(),
	fpe_signal(), segv_signal(),
#ifdef SIGBUS
	bus_signal(),
#endif
	alarm_signal(), pipe_signal(), hup_signal(),
	usr1_signal(), usr2_signal() ;

extern void init_opts_menu();
extern void malloc_failed_exit();

void initialize(requestedmfile)
     char *requestedmfile;  /* first mail file to open, empty if the default */
{
    register int init_scr_return; 
    struct folder_info *folder = NULL;

    char buffer[SLEN], *cp;

    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);
    def_ans_yes = catgets(elm_msg_cat, ElmSet, ElmYes, "y");
    def_ans_no = catgets(elm_msg_cat, ElmSet, ElmNo, "n");
    nls_deleted = catgets(elm_msg_cat, ElmSet, ElmTitleDeleted, "[deleted]");
    nls_form = catgets(elm_msg_cat, ElmSet, ElmTitleForm, "Form");
    nls_message = catgets(elm_msg_cat, ElmSet, ElmTitleMessage, "Message");
    nls_to = catgets(elm_msg_cat, ElmSet, ElmTitleTo, "To");
    nls_from = catgets(elm_msg_cat, ElmSet, ElmTitleFrom, "From");
    nls_page = catgets(elm_msg_cat, ElmSet, ElmTitlePage, "  Page %d");
    change_word = catgets(elm_msg_cat, ElmSet, ElmChange, "change");
    save_word = catgets(elm_msg_cat, ElmSet, ElmSave, "save");
    copy_word = catgets(elm_msg_cat, ElmSet, ElmCopy, "copy");
    cap_save_word = catgets(elm_msg_cat, ElmSet, ElmCapSave, "Save");
    cap_copy_word = catgets(elm_msg_cat, ElmSet, ElmCapCopy, "Copy");
    saved_word = catgets(elm_msg_cat, ElmSet, ElmSaved, "saved");
    copied_word = catgets(elm_msg_cat, ElmSet, ElmCopied, "copied");
    strfcpy(item, catgets(elm_msg_cat, ElmSet, Elmitem, "message"),
	    sizeof item);
    strfcpy(items, catgets(elm_msg_cat, ElmSet, Elmitems, "messages"),
	    sizeof items);
    strfcpy(Item, catgets(elm_msg_cat, ElmSet, ElmItem, "Message"),
	    sizeof Item);
    strfcpy(Items, catgets(elm_msg_cat, ElmSet, ElmItems, "Messages"),
	    sizeof Items);
    strfcpy(Prompt, catgets(elm_msg_cat, ElmSet, ElmPrompt, "Command: "),
	    sizeof Prompt);
    
    Stopped_Text = catgets(elm_msg_cat, ElmSet, ElmStoppedUseFGToReturn,
			   "\n\nStopped.  Use \"fg\" to return to ELM\n\n");
    Back_Text    = catgets(elm_msg_cat, ElmSet, ElmBackInElmRedraw,
			   "\nBack in ELM. (You might need to explicitly request a redraw.)\n\n");
    Segv_Text = catgets(elm_msg_cat, ElmSet, ElmSegmentViolationSignal,
			"\n\nSegment Violation signal!\n\n");
    Bus_Text  = catgets(elm_msg_cat, ElmSet, ElmBusErrorSignal,
			"\n\nBus Error signal!\n\n");
    Fpe_Text  = catgets(elm_msg_cat, ElmSet, ElmFloatingPointSignal,
			"\n\nFloating Point Exception signal!\n\n");
    Ill_Text  = catgets(elm_msg_cat, ElmSet, ElmIllegalInstructionSignal,
			"\n\nIllegal Instruction signal!\n\n");
    /*
     * Install the error trap to take if xmalloc() or friends fail.
     */
    safe_malloc_fail_handler = malloc_failed_exit;

    init_opts_menu();
    init_scr_return = InitScreen();

    out_util_setup();
    
    /* make all newly created files private */
    original_umask = umask(077);
    
    /* get username and home directory */
    user_init();

    /* user_init sets have_saved_ids, mailgroupid, userid and groupid */
    if (have_saved_ids) {
	DPRINT(Debug,4,(&Debug, 
			"*** setting gid=%d (mailgroupid=%d)\n",
			groupid,mailgroupid));
	
	if (setgid(groupid) < 0) {
	    int err = errno;
	    lib_error(FRM("init: setgid(%d) FAILED: %s"),
		      groupid,error_description(err));
	}
    }
    
#ifdef DEBUG
    { 
	int d = panic_dprint("\n\
======================================================\n\
Debug output of the ELM program (version %s).\n",
			     version_buff);
	
	if (d >= 50) {
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    error_sleep(5+sleepmsg);	    
	}
    }

    /*
     * If debug level is fairly low, ignore keyboard signals
     * until the screen is set up.
     */

    /* FIXME -- Probably wrong variable ... */
    if (Debug.active < 5) {
	signal(SIGINT,  SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
    }
#endif
    
    if(!check_only && !batch_only) {
	if (init_scr_return < 0) {
	    if (init_scr_return == -1) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNoTerm,
				  "Sorry, but you must specify what type of terminal you're on if you want to\n\
run the \"elm\" program. (You need your environment variable \"TERM\" set.)\n"));
		DPRINT(Debug,1,
		       (&Debug, 
			"No $TERM variable in environment!\n"));
	    }
	    else if (init_scr_return == -2) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBadTerm,
				  "You need a cursor-addressable terminal to run \"elm\" and I can't find any\n\
kind of termcap entry for \"%s\" - check your \"TERM\" setting...\n"),
			  getenv("TERM"));
		DPRINT(Debug,1,
		       (&Debug, 
			"$TERM variable is an unknown terminal type!\n"));
	    } else {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmTermInitFailed,
				  "Failed trying to initialize your terminal entry: unknown return code %d\n"), 
			  init_scr_return);
		DPRINT(Debug,1,
		       (&Debug, 
			"Initscreen returned unknown code: %d\n",
			init_scr_return));
	    }
	    exit(1);	/* all the errors share this exit statement */
	}
    }
    
#ifdef DEBUG
    /* FIXME -- Probably wrong variable ... */
    if (Debug.active < 5) {	/* otherwise let the system trap 'em! */
	init_signals();
    }
    else {
	DPRINT(Debug,3,
	       (&Debug, 
		"\n*** Elm-Internal Signal Handlers Disabled due to debug level %d ***\n\n",
		Debug.active));
    }
#else
    init_signals();
#endif

    init_signals1();

#ifdef BACKGROUD_PROCESSES
    init_backgroud_handling();
#endif

	get_term_chars();


	/* Determine options that might be set in the global elmrc */
	if (init_defaults() != 0) {
	  sleep(1);
	}

	/* Determine options that might be set in the .elm/elmrc */
	if (read_rc_file() != 0) {
	    sleep(1);
	    if (!batch_only && !write_elmrc) {
		lib_error(CATGETS(elm_msg_cat, ElmSet,
				  ElmFixElmrc,
				  "Fix %s, %s, %s and/or %s or let elm rebuild them with option '-w'."),
			  ELMRCFILE, USER_MIME_CHARSETS,
			  USER_TERMINAL_INFO, USER_MAIL_SERVICES);
		exit(1);
	    }
	}
	
	if (check_only) {
	    DPRINT(Debug,5,
		   (&Debug, 
		    "initialize: check_only (-c) -- skipping rest of initialize.\n"));
	    return;
	}

	if (!Check_attachments())
	    exit(1);

	/* Check if .elm and Mail directories exists */
	directory_check();

	if (write_elmrc) {
	    int err;
	    FILE *f = NULL;
	    char *tmp;

	    save_options();

	    tmp = elm_message(FRM("%s.N"),user_mime_charsets);
	    err = can_open(tmp,"w");
	    if (err)
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  tmp, error_description(err));
	    else if (!(f = fopen(tmp,"w"))) {
		int err = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  tmp, error_description(err));
	    } else {
		dump_locale_map(f,user_locale_map);
		if (EOF == fclose(f)) {
		    int err = errno;
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      tmp, error_description(err));
		    
		} else if (0 != rename(tmp,user_mime_charsets)) {
		    int err = errno;
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotRenamed,
				      "Failed to rename temporary file to %.50s: %30s"),
			      user_mime_charsets, 
			      error_description(err));
		
		} else {
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmCharsetsSavedIn,
				      "Charsets saved in file %s."), 
			      user_mime_charsets);
		}
		free(tmp);
	    }

	    tmp = elm_message(FRM("%s.N"),user_terminal_info);
	    err = can_open(tmp,"w");
	    if (err)
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  tmp, error_description(err));
	    else if (!(f = fopen(tmp,"w"))) {
		int err = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  tmp, error_description(err));
	    } else {
		dump_terminal_map(f,user_terminal_map);
		if (EOF == fclose(f)) {
		    int err = errno;
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      tmp, error_description(err));
		    
		} else if (0 != rename(tmp,user_terminal_info)) {
		    int err = errno;
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotRenamed,
				      "Failed to rename temporary file to %.50s: %30s"),
			      user_terminal_info, 
			      error_description(err));
		
		} else {
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmTerminalInfoSavedIn,
				      "Additional terminal info saved in file %s."), 
			      user_terminal_info);
		}
		free(tmp);
	    }

	    tmp = elm_message(FRM("%s.N"),user_mail_services);
	    err = can_open(tmp,"w");
	    if (err)
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  tmp, error_description(err));
	    else if (!(f = fopen(tmp,"w"))) {
		int err = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  tmp, error_description(err));
	    } else {
		dump_service_entries(f,0 /* USER */);
		if (EOF == fclose(f)) {
		    int err = errno;
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      tmp, error_description(err));
		    
		} else if (0 != rename(tmp,user_mail_services)) {
		    int err = errno;
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotRenamed,
				      "Failed to rename temporary file to %.50s: %30s"),
			      user_mail_services, 
			      error_description(err));
		
		} else {
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmMailServInfoSavedIn,
				      "Mail service info saved in file %s."), 
			      user_mail_services);
		}
		free(tmp);
	    }


	    sleep(1);
	}


	/** check to see if the user has defined a LINES or COLUMNS
	    value different to that in the termcap entry (for
	    windowing systems, of course!) **/

	ScreenSize(&elm_LINES, &elm_COLUMNS);

	/* WARNING: elm_LINES and elm_COLUMNS are inconsistent!
	 *
	 * elm_LINES    == number of lines in screen -1
	 * elm_COLUMNS  == number of rows in screen
	 *
	 *
	 * Check code in MoveCursor!
	 *
	 * row          == 0 .. elm_LINES
	 * col          == 0 .. elm_COLUMNS-1
	 *
	 *
	 * Who was this smart programmer!!!!!!!!!!!!!!!!!!!!!
	 *
	 *                         - K E H <hurtta@ozone.FMI.FI>
	 */

	if ((cp = getenv("LINES")) != NULL && isdigit(*cp)) {
	    sscanf(cp, "%d", &elm_LINES);
	    elm_LINES -= 1; 
	}

	if ((cp = getenv("COLUMNS")) != NULL && isdigit(*cp))
	    sscanf(cp, "%d", &elm_COLUMNS);

	/* Now that we've read the rc file we can enter RAW mode */
	if (!batch_only) {
	    Raw(ON);
	    /** clear the screen **/
	    ClearScreen();
	}

	if (-1 != wanted_switchmode)
	    allow_charset_switching = wanted_switchmode;

	if (init_scr_return >= 0) {
	    if (wanted_charset) {
		charset_t X = MIME_name_to_charset(wanted_charset,0);
		if (!X) {
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsCharsetUnknown,
				      "Charset %s given with -D flag is unknown."),
			      wanted_charset);
		} else if (set_display_charset(X,0)) {
		    CarriageReturn();
		    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					    ElmDisplayCharsetChanged,
					    "[display charset changed to %s]"),
				    wanted_charset);
		    CarriageReturn();
		} else {
		    DPRINT(Debug,1,
			   (&Debug, 
			    "No way to set terminal to charset %s (-D option)\n",
			    wanted_charset));
		}
	    } else if (wanted_display_charset &&
		       wanted_display_charset != system_charset) {
		if (set_display_charset(wanted_display_charset,1)) {
		    CarriageReturn();
		    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					    ElmDisplayCharsetChanged,
					    "[display charset changed to %s]"),
				    display_charset -> MIME_name ?
				    display_charset -> MIME_name :
				    "<no MIME name>");
		    CarriageReturn();
		} 
	    }
	}
	
	post_process_charset_options();

	if (! mail_only) {
	    if (mini_menu)
		headers_per_page = elm_LINES - 13;
	    else
		headers_per_page = elm_LINES -  8;	/* 5 more headers! */
	    
	    if (headers_per_page <= 0) {
		Raw(OFF);
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmWindowSizeTooSmall,
				  "The window is too small to run Elm.  It must have at least %d rows"),
			  1 + elm_LINES - headers_per_page);
		exit(1);
	    }

	    /* Determine the mail file to read */
	    if (!requestedmfile)
		folder = enter_new_folder(defaultfile);
	    else {
		/* Assuming that file name given with -f is on 
		   local-fs-charset and not system_charset
		*/
		struct folder_browser * XXX    = new_browser(selection_folder);
		struct string         * buffer = new_string2(local_fs_charset,
							     s2us(requestedmfile));
		int redraw = 0;
		
		

		if (!browser_expand(XXX,&buffer,NULL))
		    gen_browser(XXX,&buffer,&redraw,word_change,NULL,
				CATGETS(elm_msg_cat, ElmSet, 
					ElmSelectFolder,
					"Select folder: "));
		
		if (!give_dir_flags(XXX)) {		    
		    Raw(OFF);
		    close_cached_connections();
		    NewLine();
		    exit(0);
		}
		folder = folder_from_dir_item(XXX);
	    }
	    if (!folder) {
		Raw(OFF);
		close_cached_connections();
		NewLine();
		exit(0);
	    }

	    if (!sessionlock_folder(folder,SESSIONLOCK_CHECK)) {
		Raw(OFF);
		NewLine();
		
		DPRINT(Debug,1,
		       (&Debug, 
			"Error: given file %s as folder - unreadable (%s)!\n", 
			folder->cur_folder_sys, error_description(errno)));
		close_folder(folder,CLOSE_NORMAL);
		close_cached_connections();
		exit(1);
	    }

	    if (check_size)
		if(check_mailfile_size(folder) != 0) {
		    close_folder(folder,CLOSE_NORMAL);
		    Raw(OFF);
		    close_cached_connections();
		    NewLine();
		    exit(0);
		}

	    /* read in the folder! */
	    newmbox_1(folder, FALSE);	
	}

	/** fix the shell if needed **/

	if (shell[0] != '/') {
	    elm_sfprintf(buffer, sizeof buffer,
			 FRM("/bin/%s"), 
			 shell);
	    strfcpy(shell, buffer, sizeof shell);
	}


#ifdef DEBUG
	if (Debug.active >= 2 && Debug.active < 10) {
	    debug_action_call(&Debug,
			      "hostname = %-20s \tusername = %-20s \tfullname = %-20s\n",
			      hostname, username, full_username);
	    debug_action_call(&Debug,	  
			      "home     = %-20s \teditor   = %-20s \trecvd_mail  = %-20s\n",
			      home, editor, recvd_mail);

	    debug_action_call(&Debug,
			      "folders  = %-20s \tprintout = %-20s\n",
			      folders, printout);
	
	    debug_action_call(&Debug,
			      "sent_mail = %-20s \tprefix   = %-20s \tshell    = %-20s\n\n",
			      sent_mail, prefixchars, shell);
	    
	  if (local_signature[0])
	      debug_action_call(&Debug,
				"local_signature = \"%s\"\n",
				local_signature);
	  if (remote_signature[0])
	      debug_action_call(&Debug,
				"remote_signature = \"%s\"\n",
				remote_signature);
	  if (local_signature[0] || remote_signature[0])
	      debug_action_call(&Debug, "\n");
	}
#endif
}

static void get_term_chars()
{
    /** This routine sucks out the special terminal characters
	ERASE and KILL for use in the input routine.  The meaning 
	of the characters are (dare I say it?) fairly obvious... **/
    
    term_buff term_buffer;
    
    if (tcgetattr(STANDARD_INPUT,&term_buffer) == -1) {
	int err = errno;

	DPRINT(Debug,3,
	       (&Debug, 
		"Error: %s encountered on ioctl call (get_term_chars)\n", 
		error_description(err)));

	/* set to defaults for terminal driver */
	backspace = BACKSPACE;
	kill_line = ctrl('U');
	word_erase = ctrl('W');
	interrupt_char = 0177;	/* DEL */
	reprint_char = ctrl('R');
	eof_char = ctrl('D');
    } else {
#if defined(TERMIO) || defined(TERMIOS)
	backspace = term_buffer.c_cc[VERASE];
	kill_line = term_buffer.c_cc[VKILL];
#if   defined(TERMIOS) && defined(VWERASE)
	word_erase = term_buffer.c_cc[VWERASE];
#else
	word_erase = ctrl('W');
#endif
	interrupt_char = term_buffer.c_cc[VINTR];
#if defined(TERMIOS) && defined(VREPRINT)
	reprint_char = term_buffer.c_cc[VREPRINT];
#else
	reprint_char = ctrl('R');
#endif
	eof_char = term_buffer.c_cc[VEOF];
#else
	backspace = term_buffer.sgttyb.sg_erase;
	kill_line = term_buffer.sgttyb.sg_kill;
#ifdef     TIOCLGET
	word_erase = term_buffer.ltchars.t_werasc;
	reprint_char = term_buffer.ltchars.t_rprntc;
#else
	word_erase = ctrl('W');
	reprint_char = ctrl('R');
#endif
	interrupt_char = term_buffer.tchars.t_intrc;
	eof_char = term_buffer.tchars.t_eofc;
#endif
    }
}

#if !defined(TERMIO) && !defined(TERMIOS)
static int
tcgetattr(fd, buf)
     int fd;
     term_buff *buf;
{
    if (ioctl(fd, TIOCGETP, &buf->sgttyb) < 0)
	return(-1);
    if (ioctl(fd, TIOCGETC, &buf->tchars) < 0)
	return(-1);
#ifdef TIOCLGET
    if (ioctl(fd, TIOCLGET, &buf->ltchars) < 0)
	return(-1);
#endif
    return(0);
}
#endif


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */




