static char rcsid[] = "@(#)$Id: elm.c,v 1.31 2001/06/16 10:40:36 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.31 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * This file and all associated files and documentation:
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/* Main program of the ELM mail system! 
*/

#include "patchlevel.h"
#include "elm.h"
#include "s_elm.h"

#ifdef BSD_TYPE
#  include <sys/timeb.h>
#endif

#include "mime.h"
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"ELM");

char *parse_arguments(), *error_description();

static void do_check_only P_((char *argv[])); /* Prototype */
static void debug_screen P_((void));
static void debug_message P_((void));

static void elm_panic_prepare P_((CONST int interrupt, 
				  CONST char * title,
				  CONST char * ms));
static void elm_panic_prepare(interrupt,title,ms)
     CONST int interrupt;
     CONST char * title;
     CONST char * ms;
{
    int do_cursor = RawState();

    if (do_cursor && !interrupt) {
	lib_error(FRM("%s: %s"),title,ms);
	sleep(1);
    }

    if (do_cursor) {
	MoveCursor(elm_LINES, 0);
	Raw(OFF);
    }
}

static void elm_panic_exit P_((CONST int interrupt));
static void elm_panic_exit(interrupt)
     CONST int interrupt;
{
    emergency_exit(interrupt);
}

void forget_passphrase() 
{
#ifdef USE_PGP
    if (pgp_void_passphrase())
	lib_error(CATGETS(elm_msg_cat, ElmSet, 
			  ElmPGPPassphraseForgotten,
			  "PGP passphrase forgotten!"));
#endif
#ifdef REMOTE_MBX
    if(close_cached_connections())
	lib_error(CATGETS(elm_msg_cat, ElmSet, 
			  ElmCachedConenctionsClosed,
			  "Cached connections closed!"));
#endif

    error_sleep(1);
}

int main(argc, argv)
     int argc;
     char *argv[];
{
	int  ch;
	char address[SLEN];
	char *req_mfile_name = NULL;    /* Malloced */
	char **to_whom = NULL;
	int bytes;
	int  i,j;      		/** Random counting variables (etc)          **/
	extern int errno;

	set_panic_prepare(elm_panic_prepare);
	set_panic_exit(elm_panic_exit);

#if DEBUG
	init_debugfile("ELM");
#endif	

	locale_init();
	
	req_mfile_name = parse_arguments(argc, argv, &to_whom);
	initialize(req_mfile_name);
	if (req_mfile_name) {
	    free(req_mfile_name);
	    req_mfile_name = NULL;
	}

	if (mail_only) {
	    DPRINT(Debug,2,(&Debug, 
			    "Mail-only: mailing to\n"));
	    
	    if(!batch_only) {
		print_format_center(1,
				    CATGETS(elm_msg_cat, ElmSet, ElmSendOnlyMode,
					    "Send only mode [ELM %s]"), 
				    version_buff);
	    }
	    send_msg_argv(to_whom, batch_subject, MAIL_EDIT_MSG,
			  (batch_only ? NO : allow_forms));
	    leave(0);
	} else if (check_only) {
	    do_check_only(to_whom);
	    leave(0);
	}

	showscreen();

	while (1) {
#ifdef SIGWINCH
	  if (resize_screen) {
	    int	newLINES, newCOLUMNS;

	    ScreenSize(&newLINES, &newCOLUMNS);
	    resize_screen = 0;
	    if (newLINES != elm_LINES || newCOLUMNS != elm_COLUMNS) {
	      elm_LINES = newLINES, elm_COLUMNS = newCOLUMNS;
#undef max
#define max(a,b)	       ((a) < (b) ? (b) : (a))
	      if (mini_menu)
		headers_per_page = max (elm_LINES - 13, 1);
	      else
		headers_per_page = max (elm_LINES -	 8, 1);	  /* 5 more headers! */
#undef max
	      redraw++;
	    }
	  }
	  else redraw = 0;
#else
    	  redraw = 0;
#endif
	  nufoot = 0;
	  nucurr = 0;

#ifdef BACKGROUD_PROCESSES      
	  if (handle_sigchld)
	      sigchld_handler();
#endif

	  if (current_folder) {
	      flush_folder(current_folder);

	      if (new_mail_on_folder(current_folder,&bytes)) {
		  int was_on_page = on_page(current);
		  int pageon = header_page;
		  int last_in_folder = message_count;

		  DPRINT(Debug,2,(&Debug, 
			     "Just received %d bytes more mail (elm)\n", 
			     bytes));
		  lib_transient(CATGETS(elm_msg_cat, ElmSet, ElmNewMailHangOn,
					"New mail has arrived! Hang on..."));
		 	    	  
		  newmbox_1(current_folder, TRUE);	/* last won't be touched! */
		  clear_error();
		  header_page = pageon;
		  
		  if (selected)               /* update count of selected messages */
		      selected += message_count - last_in_folder;
		  
		  if (on_page(current) || 
		      was_on_page) /* do we REALLY have to rewrite? */
		      showscreen();
		  
		  update_title();
		  ClearLine(elm_LINES-1);	     /* remove reading message... */
		  if ((message_count - last_in_folder) == 1)
		      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNewMessageRecv,
					"1 new message received."));
		  else
		      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNewMessageRecvPlural,
					"%d new messages received."), 
				message_count - last_in_folder);
	      } else if (bytes < 0) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, 
				    ElmALERTMailfileShrinken,
				    "ALERT: Mailfile shrinken %d bytes!"),
			    -bytes);
		  DPRINT(Debug,1,(&Debug, 
				  "ALERT: Mailfile shrinken %d bytes!",
				  -bytes));
		  sleep_message();
	      }
	  }

	  prompt(Prompt);

	  CleartoEOLN();
	  ch = GetPrompt();

	  if (redraw_screen) {
	    redraw_screen = 0;
	    redraw++;
	  }

#ifdef SIGWINCH
	  if (resize_screen) {
	    int	newLINES, newCOLUMNS;

	    ScreenSize(&newLINES, &newCOLUMNS);
	    resize_screen = 0;
	    if (newLINES != elm_LINES || newCOLUMNS != elm_COLUMNS) {
	      elm_LINES = newLINES, elm_COLUMNS = newCOLUMNS;
#define max(a,b)	       ((a) < (b) ? (b) : (a))
	      if (mini_menu)
		headers_per_page = max (elm_LINES - 13, 1);
	      else
		headers_per_page = max (elm_LINES - 8, 1);	  /* 5 more headers! */
#undef max
	      redraw++;
	    }
	  }
#endif
	  CleartoEOS();

	  if (isascii(ch) && isprint(ch)) {
	      DPRINT(Debug,4,(&Debug, 
			      "\nCommand: %c [%d]\n\n", ch, ch));
	  } else {
	      DPRINT(Debug,4,(&Debug, 
			      "\nCommand: %d\n\n", ch));
	  }

	  set_error("");	/* clear error buffer */

	  MoveCursor(elm_LINES-3,strlen(Prompt));

	  switch (ch) {

	  case HELP_MARK:
	  case '?' 	:  
	      if (help(FALSE))
		  redraw++;
	      else
		  nufoot++;
	      break;
	  
	  case '$'    :  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
						 ElmResyncFolder,
						 "Resynchronize folder"));
	                   redraw += resync();
			   nucurr = get_page(current);
			   break;

	    case '|'    :  Writechar('|'); 
			   if (message_count < 1) {
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoMailToPipe,
					       "No mail to pipe!"));
			     
			   } else {
	    		     /* softkeys_off(); */
                             redraw += do_pipe();		
			     /* softkeys_on(); */
			   }
			   break;

#ifdef ALLOW_SUBSHELL
	    case '!'    :  Writechar('!'); 
                           redraw += subshell();		
			   break;
#endif
	    case '<'    :  /* scan current message for calendar information */
#ifdef ENABLE_CALENDAR
			   if  (message_count < 1) {
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoMailToScan,
					       "No mail to scan!"));
			     
			   }
			   else {
			       Write_to_screen(CATGETS(elm_msg_cat, 
						       ElmSet, 
						       ElmScanForCalendar,
						       "Scan message for calendar entries..."));
			       scan_calendar();
			   }
#else
	 		   lib_error(CATGETS(elm_msg_cat, ElmSet, 
					     ElmSorryNoCalendar,
					     "Sorry. Calendar function disabled."));
			   
#endif
			   break;

	    case 'a'    :  alias();
			   redraw++;
			   /* define_softkeys(MAIN); */	break;
			
	    case 'b'    :  Write_to_screen(CATGETS(elm_msg_cat, 
						   ElmSet, ElmBounceMessage,
						   "Bounce message"));
			   FlushBuffer();
			   if (message_count < 1) {
	  		     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoMailToBounce,
					       "No mail to bounce!"));
			     
			   }
			   else 
			     nufoot = remail();
			   break;

	    case 'c'    :  Write_to_screen(CATGETS(elm_msg_cat, 
						   ElmSet, ElmChangeFolder,
			     "Change folder"));
	                   /* define_softkeys(CHANGE); */
			   redraw += change_file();
			   /* define_softkeys(MAIN); */
			   break;

#ifdef ALLOW_MAILBOX_EDITING
	    case 'e'    :  if (user_level < 2) {
				lib_error(CATGETS(elm_msg_cat, ElmSet, 
						  ElmNoFolderEditing,
						  "You are not experienced to use folder editing"));
				
				break;
			   }
	                    Write_to_screen(CATGETS(elm_msg_cat, 
						    ElmSet, ElmEditFolder,
						    "Edit folder"));
			   if (current > 0) {
			     edit_mailbox();
	   		   }
			   else {
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmFolderIsEmpty,
					       "Folder is empty!"));
			     
			   }
			   break;
#else
	    case 'e'    : lib_error(CATGETS(elm_msg_cat, ElmSet, 
					    ElmNoFolderEdit,
					    "Folder editing isn't configured in this version of ELM."));
			  
			  break;
#endif
#ifdef USE_PGP
	    case ctrl('E'):
              if (message_count < 1)
                lib_error(CATGETS(elm_msg_cat, ElmSet, ElmNoMailInFolder,
				  "There is no mail in this folder!"));
              else {
  	        Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmExtractPGPKey,
					"Extract PGP public key"));
	        if (headers[current-1]->pgp & PGP_PUBLIC_KEY)
	  	  redraw = pgp_extract_public_key();
	        else
		  lib_error(CATGETS(elm_msg_cat, ElmSet, 
				    ElmNoPgpPublicKeys,
				    "This message does not contain PGP public keys!"));
              }
	      break;

#endif
           case ctrl('F'):
	       Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
				       ElmPassphraseForget,
				       "Forget passphrase"));
	       forget_passphrase();
	       break;

	    case 'f'    :  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
						   ElmForward,
						   "Forward"));
	                   /* define_softkeys(YESNO); */
			   if (current > 0) {
			     if(forward()) redraw++;
			     else nufoot++;
			   } else {
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoMailToForward,
					       "No mail to forward!"));
			     
			   }
			   /* define_softkeys(MAIN); */
			   break;

	    case 'g'    :  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
						   ElmGroupReply,
						   "Group reply"));
			   FlushBuffer();
			   if (current > 0) {
			     if (headers[current-1]->status & FORM_LETTER) {
			       lib_error(CATGETS(elm_msg_cat, ElmSet, 
						 ElmCantGroupReplyForm,
						 "Can't group reply to a Form!!"));
			       
			     }
			     else {
			       /* define_softkeys(YESNO); */
			       redraw += reply_to_everyone();	
			       /* define_softkeys(MAIN); */
			     }
			   }
			   else {
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoMailToReply,
					       "No mail to reply to!")); 
			    FlushBuffer();
			   }
			   break;

	    case 'h'    :  if (elm_filter)
		               Write_to_screen(CATGETS(elm_msg_cat, 
						     ElmSet, 
						     ElmMessageWithHeaders,
						     "Message with headers..."));
	                     else
			       Write_to_screen(CATGETS(elm_msg_cat, 
						       ElmSet, 
						       ElmDisplayMessage,
						       "Display message"));
			   if(current > 0) {
			     FlushBuffer();
			     j = elm_filter;
			     elm_filter = FALSE;
			     i = show_msg(current);
			     while (i)
				i = process_showmsg_cmd(i);
			     elm_filter = j;
			     redraw++;
			     (void)get_page(current);
			   } else
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoMailToRead,
					       "No mail to read!"));
			   break;

#ifdef USE_PGP
            case ctrl('K'):
	                   Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						   ElmMailPGPPublicKey,
						   "Mail PGP public key"));
	                   redraw = pgp_mail_public_key ();
                           break;
#endif
	    case 'm'    :   Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						    ElmMail,
						    "Mail"));
	    redraw += send_msg_l(NULL,NULL, NULL, NULL, 
				 MAIL_EDIT_MSG,allow_forms);
	                   break;

	    case ' '    : 
	    case ctrl('J'):
	    case ctrl('M'): Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						    ElmDisplayMessage,
						    "Display message"));  
			   FlushBuffer();
			   if(current > 0 ) {
			     /* define_softkeys(READ); */

			     i = show_msg(current);
			     while (i)
				i = process_showmsg_cmd(i);
			     redraw++;
			     (void)get_page(current);
			   } else
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoMailToRead,
					       "No mail to read!"));
			   break;

	    case 'n'    : Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						  ElmNextMessage,
						  "Next Message"));
			   FlushBuffer();
			   /* define_softkeys(READ); */

			   if(current > 0 ) {
			     /* define_softkeys(READ); */

			     i = show_msg(current);
			     while (i)
			       i = process_showmsg_cmd(i);
			     redraw++;
			     if (++current > message_count)
			       current = message_count;
			     (void)get_page(current);
			   } else
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoMailToRead,
					       "No mail to read!"));
			   break;

	    case 'o'    :  Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						   ElmOptions,
						   "Options"));
			   if((i=options()) > 0)
			     get_page(current);
			   else if(i < 0)
			     leave(0);
			   redraw++;	/* always fix da screen... */
			   break;

	    case 'p'    :  Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						   ElmPrintMail,
						   "Print mail"));
			   FlushBuffer();
			   if (message_count < 1) {
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoMailToPrint,
					       "No mail to print!"));
			     
			   } else if (print_msg(TRUE) != 0)
			     redraw++;
			   break;

	    case 'P'    : Write_to_screen(CATGETS(elm_msg_cat, ElmSet,	  
						  ElmPrintTextMail,
						  "Print text of mail"));
			   FlushBuffer();
			   if (message_count < 1) {
			       lib_error(CATGETS(elm_msg_cat, ElmSet, 
						 ElmNoMailToPrint,
						 "No mail to print!"));
			       
			   } else if (print_text(TRUE) != 0)
			       redraw++;
			   break;

	    case 'q'    :  Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						   ElmQuit,
						   "Quit"));

	                  if (new_mail_on_folder(current_folder,&bytes)) {
			      lib_error(CATGETS(elm_msg_cat, ElmSet, 
						ElmNewMailQuitCancelled,
						"New Mail!  Quit canceled..."));
			      
			  }
			  else
			      quit(TRUE);		
			   
			   break;

	    case 'Q'    :  Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						   ElmQuickQuit,
						   "Quick quit"));
	                   FlushBuffer();

	                  if (new_mail_on_folder(current_folder,&bytes)) {
			      lib_error(CATGETS(elm_msg_cat, ElmSet, 
						ElmNewMailQuickQuitCancelled,
						"New Mail!  Quick Quit canceled..."));	
			  }
			  else
			      quit(FALSE);		

			   break;

	  case 'r'    : Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						ElmReplyToMessage,
						"Reply to message"));
			   if (current > 0) 
			     redraw += reply();	
			   else {
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoMailToReplyTo,
					       "No mail to reply to!")); 
			     
			   }
			   /* softkeys_on(); */
			   break;

	    case '>'    : /** backwards compatibility **/

	    case 'C'	:
	    case 's'    :  if  (message_count < 1) {
			     if (ch != 'C')
			       lib_error(CATGETS(elm_msg_cat, ElmSet, 
						 ElmNoMailToSave,
						 "No mail to save!"));
			     else
			       lib_error(CATGETS(elm_msg_cat, ElmSet, 
						 ElmNoMailToCopy,
						 "No mail to copy!"));
			     
			   }
			   else {
			     if (ch != 'C')
				 Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
							 ElmSaveToFolder,
							 "Save to folder"));
			     else
				 Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
							 ElmCopyToFolder,
							 "Copy to folder"));
			     if (save(&redraw, FALSE, (ch != 'C'), 0)
				 && resolve_mode && ch != 'C') {
				 if((i=next_message(current-1, TRUE)) != -1) {
				     current = i+1;
				     nucurr = get_page(current);
				 }
			     }
			   }
			   ClearLine(elm_LINES-2);		
			   break;
	  case 'S'     :   if  (message_count < 1) {
	                       lib_error(CATGETS(elm_msg_cat, ElmSet, 
						 ElmNoMailToCopy,
						 "No mail to copy!"));
			       
			   }
			   else {
			       Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						       ElmSaveTextToFileorFolder,
						       "Save (copy) text to file or folder"));
			       save(&redraw, FALSE, 0, 1);
			   }
	                   ClearLine(elm_LINES-2);		
			   break;	                   
	    case 'v'    :  if (headers && current_folder) {
		FILE * ZZ = folder_to_fd(current_folder,-1L);
		Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					ElmViewParts,
					"View parts of message"));
		if (ZZ && (headers[current-1]->status & MIME_MESSAGE)) {
		    mime_warnings(headers[current-1]);
		    attach_parse (headers[current-1], ZZ);
		    if (headers[current-1]->mime_rec.parts)
			(void) attach_menu (headers[current-1]->
					    mime_rec.parts, TRUE,
					    headers[current-1]->
					    header_charset);
		    else 
				/* So we can save mail in decoded ... */
			(void) attach_menu (&(headers[current-1]->
					      mime_rec),TRUE,
					    headers[current-1]->
					    header_charset);
		    redraw++;
		}
		else
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmNoMIMEMessage,
				      "This is not a MIME message!"));
	    }
	    else
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmNoMessages,
				  "There are no messages!"));
	    break;
	  case 'X'    :  Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						 ElmQuickExit,
						 "Quick Exit"));
                           FlushBuffer();
			   leave(0);
			   break;
		
	    case ctrl('Q') :
	  case 'x'    :    Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						   ElmExit,
						   "Exit"));  
                           FlushBuffer();
			   exit_prog();
			   break;

            case EOF :  leave(0);  /* Read failed, control tty died? */
                        break;
	    
	    case '@'    : debug_screen();  redraw++;	break;
	
	  case '#'    : 
	      if (message_count) {
		  Write_to_screen(CATGETS(elm_msg_cat, ElmSet, 
					  ElmCheckMessage,
					  "Check message"));
		  FlushBuffer();
	      debug_message(); 
	      redraw++;	
	      } else {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, 
				    ElmNoMailToCheck,
				    "No mail to check."));
		  
	      }
	      break;

	    /* None of the menu specific commands were chosen, therefore
	     * it must be a "motion" command (or an error).               */
	    default	: motion(ch);

	  }

	  if (redraw)
	      showscreen();

          check_range();
	    
	  if (nucurr == NEW_PAGE) 
	      show_headers();
	  else if (nucurr == SAME_PAGE)
	      show_current();
	  else if (nufoot) {
	    if (mini_menu) {
	      MoveCursor(elm_LINES-7, 0);  
              CleartoEOS();
	      show_menu();
	    }
	    else {
	      MoveCursor(elm_LINES-4, 0);
	      CleartoEOS();
	    }
	    show_last_error();	/* for those operations that have to
				 * clear the footer except for a message.
				 */
	  }

	} /* the BIG while loop! */
}

static void debug_screen()
{
	/**** spit out all the current variable settings and the table
	      entries for the current 'n' items displayed. ****/

	register int i, j;

redraw:
	ClearScreen();

	PutLineX(0,0,CATGETS(elm_msg_cat, ElmSet, 
			     ElmDbxCurrMsgNum,
			     "Current message number = %d\t\t%d message(s) total\n"),
		 current, message_count);
	PutLineX(2,0,CATGETS(elm_msg_cat, ElmSet, 
			     ElmDbxHdrPage,
			     "Header_page = %d           \t\t%d possible page(s)\n"),
		 header_page, (int) (message_count / headers_per_page) + 1);

	if (current_folder) {
	    PutLineX(4,0,CATGETS(elm_msg_cat, ElmSet, 
				 ElmDbxCurrMailFile,
				 "\nCurrent mail file is %S.\n\r\n"), 
		     current_folder->cur_folder_disp);
	}

	i = header_page*headers_per_page;	/* starting header */

	if ((j = i + (headers_per_page-1)) >= message_count) 
	  j = message_count-1;

	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmDebugHeader,
				"Num      From                    Subject                Lines   Offset  Content\n\r\n\r"));
	
	while (i <= j) {	  
	    if (headers[i]->from && headers[i]->from->fullname &&
		string_len(headers[i]->from->fullname))
		Write_to_screen(FRM("%3d %-16.16S %-35.35S %4d %8d %8d\n\r"),
				i+1,
				headers[i]->from->fullname, 
				headers[i]->subject,
				headers[i]->lines,
				headers[i]->offset,
				headers[i]->content_length);
	    else
		Write_to_screen(FRM("%3d %-16.16s %-35.35S %4d %8d %8d\n\r"),
				i+1,
				headers[i]->from && headers[i]->from->addr &&
				headers[i]->from->addr[0] ?
				headers[i]->from->addr :
				headers[i]->env_from,
				headers[i]->subject,
				headers[i]->lines,
				headers[i]->offset,
				headers[i]->content_length);
	  
	    i++;
	}
	
	PutLineX(elm_LINES,0,CATGETS(elm_msg_cat, ElmSet, 
			     ElmDbxPressAnyKey,"Press any key to return."));
	if (REDRAW_MARK == ReadCh(REDRAW_MARK))
	  goto redraw;
}

static void debug_message()
{
	/**** Spit out the current message record.  Include EVERYTHING
	      in the record structure. **/
	
	time_t header_time;
	register struct header_rec *current_header = headers[current-1];

redraw:
	ClearScreen();

	Write_to_screen(FRM("\t\t\t----- Message %d -----\n\r\n\r\n\r\n\r"), 
			current);

	Write_to_screen(FRM("Lines: %-17dStatus: A  C  D  E  F  N  P  T  U  V  O  R  M  P  U  N\n\r"), 
			current_header->lines);
	Write_to_screen(FRM("Content-Length: %-16dc  o  e  x  o  e  r  a  r  i  l  e  i  r  s  H\n\r"), 
			current_header->content_length);
	Write_to_screen(FRM("Binary: %-24dt  n  l  p  r  w  i  g  g  s  d  p  m  e  u  d\n\r"), 
			current_header->binary);
	Write_to_screen(FRM("'From ' on body: %-15dn  f  d  d  m     v  d  n  i     l  e  M  p  r\n\r"),
			current_header->have_from);

	Write_to_screen(FRM("\n\rOffset: %-22ld%3d%3d%3d%3d%3d%3d%3d%3d%3d%3d%3d%3d%3d%3d%3d%3d\n"),
			current_header->offset,
			(current_header->status & ACTION) != 0,
			(current_header->status & CONFIDENTIAL) != 0,
			(current_header->status & DELETED) != 0,
			(current_header->status & EXPIRED) != 0,
			(current_header->status & FORM_LETTER) != 0,
			(current_header->status & NEW) != 0,
			(current_header->status & PRIVATE_MAIL) != 0,
			(current_header->status & TAGGED) != 0,
			(current_header->status & URGENT) != 0,
			(current_header->status & VISIBLE) != 0,
			(current_header->status & UNREAD) != 0,
			(current_header->status & REPLIED) != 0,
			(current_header->status & MIME_MESSAGE) != 0,
			(current_header->status & PRE_MIME_CONTENT) != 0,
			(current_header->status & MIME_UNSUPPORTED) != 0,
			(current_header->status & NOHDRENCODING) != 0);
	
        Write_to_screen(FRM("\n\rReceived on: %s\r"),
			asctime(localtime(&current_header->received_time)));
      

	header_time = current_header->time_sent + current_header->tz_offset;
	Write_to_screen(FRM("\rMessage sent on: %s\r\nFrom timezone: %s (%d)\n\r"),
			asctime(gmtime(&header_time)),
			current_header->time_zone,
			current_header->tz_offset);
	
	Write_to_screen(FRM("(Env) From: %s\n\r"), 
			current_header->env_from);

	if (current_header->from) {
	  int first = 1;
	  struct addr_item *p;
	  for (p = current_header->from; 
	       p->fullname && p->addr && p->comment; 
	       p++) {
	    if (first)
	      Write_to_screen(FRM(     "From: "));
	    else
	      Write_to_screen(FRM(",\r\n      "));
	    Write_to_screen(FRM("%-30S <%s>"),p->fullname,p->addr);
	    first = 0;
	    if (string_len(p->comment)) 
		Write_to_screen(FRM(" (%S)"),p->comment);
	  }
	  Write_to_screen(FRM("\r\n"));
	}

	Write_to_screen(FRM("Subject: %S\n\rInternal Index Reference Number = %d\n\r"),
			current_header->subject,
			current_header->index_number);

	if (current_header->to) {
	    int first = 1;
	    struct addr_item *p;
	    for (p = current_header->to; 
		 p->fullname && p->addr && p->comment; 
		 p++) {
		if (first)
		    Write_to_screen(FRM(     "To: "));
		else
		    Write_to_screen(FRM(",\r\n    "));
		Write_to_screen(FRM("%-30S <%s>"),p->fullname,p->addr);
		first = 0;
		if (string_len(p->comment)) 
		    Write_to_screen(FRM(" (%S)"),p->comment);
	    }
	    Write_to_screen(FRM("\r\n"));
	}

	if (current_header->cc) {
	    int first = 1;
	    struct addr_item *p;
	    for (p = current_header->cc; 
		 p->fullname && p->addr && p->comment; 
		 p++) {
		if (first)
		    Write_to_screen(FRM(     "CC: "));
		else
		    Write_to_screen(FRM(",\r\n    "));
		Write_to_screen(FRM("%-30S <%s>"),p->fullname,p->addr);
		first = 0;
		if (string_len(p->comment)) 
		    Write_to_screen(FRM(" (%S)"),p->comment);	    
	    }
	    Write_to_screen(FRM("\r\n"));
	}


	Write_to_screen(FRM("Message-ID: %s\n\r"), 
			strlen(current_header->messageid) > 0 ? 
			current_header->messageid : "<none>");

	Write_to_screen(FRM("Status: %s\n\r"),  
			current_header->mailx_status);

	Write_to_screen(FRM("Content-Transfer-Encoding: %s\n\r"),
			ENCODING(current_header->mime_rec.encoding));
	
	PutLineX(elm_LINES,0,CATGETS(elm_msg_cat, ElmSet, 
			     ElmDbxPressAnyKey,
				     "Please Press any key to return."));
	if (REDRAW_MARK == ReadCh(REDRAW_MARK))
	  goto redraw;
}

static void do_check_only(to_whom)
     char *to_whom[];
{
    struct expanded_address A;
    
    zero_expanded_address(&A);
    
    dump_expanded_address(3,"Check-only: checking",A);

    if (to_whom) {
	if (argv_to_expanded(&A,to_whom)) {
	    struct string * addr_string = hdr_to_expval(A);
	    if (addr_string) {
		elm_fprintf(stdout,
			    CATGETS(elm_msg_cat, ElmSet, ElmExpandsTo,
				    "Expands to: %S\n"),
			    addr_string);
		free_string(&addr_string);
	    }
	}
	free_expanded_address(&A);
    }
}

void check_range()
{
	int i;

	i = compute_visible(current);

	if ((current < 1) || (selected && i < 1)) {
	    if (message_count > 0) {
	      /* We are out of range! Get to first message! */
	      if (selected)
		current = compute_visible(1);
	      else
		current = 1;
	    }
	    else
	      current = 0;
	}
	else if ((current > message_count)
	       || (selected && i > selected)) {
	    if (message_count > 0) {
	      /* We are out of range! Get to last (visible) message! */
	      if (selected)
		current = visible_to_index(selected)+1;
	      else
		current = message_count;
	    }
	    else
	      current = 0;
	}

}

static char *no_mail = NULL;
static char *no_aliases = NULL;

void
motion(ch)
     int ch;
{
	/* Consolidated the standard menu navigation and delete/tag
	 * commands to a function.                                   */

	int  i;

	/* TODO: Fix this mess... */
	if (no_mail == NULL) {
		no_mail = catgets(elm_msg_cat, ElmSet, ElmNoMailInFolder,
		  "No mail in folder!");
		no_aliases = catgets(elm_msg_cat, ElmSet, ElmNoAliases,
		  "No aliases!");
	}

	switch (ch) {

	case FIND_MARK:
	case '/'    :  /* scan mbox or aliases for string */
	              if  (message_count < 1) {
			lib_error(CATGETS(elm_msg_cat, ElmSet,
					  ElmNoItemToScan, "No %s to scan!"), 
				  items);
			
		      }
		      else if (pattern_match())
			nucurr = get_page(current);
		      else {
			lib_error(CATGETS(elm_msg_cat, ElmSet, 
					  ElmPatternNotFound,
					  "pattern not found!"));
			
		      }
		      break;

next_page:
	case PAGEDOWN_MARK :
	case RIGHT_MARK :
	    case '+'	:  /* move to next page if we're not on the last */
			   if((selected &&
			     ((header_page+1)*headers_per_page < selected))
			   ||(!selected &&
			     ((header_page+1)*headers_per_page<message_count))){

			     header_page++;
			     nucurr = NEW_PAGE;

			     if(move_when_paged) {
			       /* move to first message of new page */
			       if(selected)
				 current = visible_to_index(
				   header_page * headers_per_page + 1) + 1;
			       else
				 current = header_page * headers_per_page + 1;
			     }
			   } else
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmAlreadyOnLastPage,
					       "Already on last page."));
			   break;

prev_page:
	case PAGEUP_MARK :
	case LEFT_MARK  :
	    case '-'	:  /* move to prev page if we're not on the first */
			   if(header_page > 0) {
			     header_page--;
			     nucurr = NEW_PAGE;

			     if(move_when_paged) {
			       /* move to first message of new page */
			       if(selected)
				 current = visible_to_index(
				   header_page * headers_per_page + 1) + 1;
			       else
				 current = header_page * headers_per_page + 1;
			     }
			   } else
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmAlreadyOnFirstPage,
					       "Already on first page."));
			   break;

first_msg:
	case HOME_MARK:
	    case '='    :  if (selected)
			     current = visible_to_index(1)+1;
			   else
			     current = 1;
			   nucurr = get_page(current);
			   break;

last_msg:
	    case '*'    :  if (selected) 
			     current = (visible_to_index(selected)+1);
			   else
			     current = message_count;	
			   nucurr = get_page(current);
			   break;

	    case EOF    : leave(0);
                          break;

	    case ctrl('D') :
	    case '^'    :
	    case 'd'    :  if (message_count < 1) {
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoItemToDelete,
					       "No %s to delete!"), 
				       item);
			     
			   }
			   else {
			     if(ch == ctrl('D')) {

			       /* if current item did not become deleted,
				* don't to move to the next undeleted item */
			       if(!meta_match(DELETED)) break;

			     } else 
 			       delete_msg((ch == 'd'), TRUE);

			     if (resolve_mode) 	/* move after mail resolved */
			       if((i=next_message(current-1, TRUE)) != -1) {
				 current = i+1;
				 nucurr = get_page(current);
			       }
			   }
			   break;

	    case 'J'    :  if(current > 0) {
			     if((i=next_message(current-1, FALSE)) != -1) {
			       current = i+1;
			       nucurr = get_page(current);
			     } else
			       lib_error(CATGETS(elm_msg_cat, ElmSet, 
						 ElmNoMoreItemBelow,
						 "No more %s below."), 
					 items);
			   } else error(ifmain(no_mail, no_aliases));
			   break;

next_undel_msg:
	case DOWN_MARK :
	    case 'j'    :  if(current > 0) {
			     if((i=next_message(current-1, TRUE)) != -1) {
			       current = i+1;
			       nucurr = get_page(current);
			     } else
			       lib_error(CATGETS(elm_msg_cat, ElmSet, 
						 ElmNoItemUndeletedBelow,
						 "No more undeleted %s below."), 
					 items);
			   } else error(ifmain(no_mail, no_aliases));
			   break;

	    case 'K'    :  if(current > 0) {
			     if((i=prev_message(current-1, FALSE)) != -1) {
			       current = i+1;
			       nucurr = get_page(current);
			     } else
			       lib_error(CATGETS(elm_msg_cat, ElmSet, 
						 ElmNoMoreItemAbove,
						 "No more %s above."), 
					 items);
			   } else error(ifmain(no_mail, no_aliases));
			   break;

prev_undel_msg:
	case UP_MARK :
	    case 'k'    :  if(current > 0) {
			     if((i=prev_message(current-1, TRUE)) != -1) {
			       current = i+1;
			       nucurr = get_page(current);
			     } else
			       lib_error(CATGETS(elm_msg_cat, ElmSet, 
						 ElmNoMoreUndeletedAbove,
						 "No more undeleted %s above."), 
					 items);
			   } else error(ifmain(no_mail, no_aliases));
			   break;

	case 'l'    :  Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
					       ElmLimitDisplayBy,
					       "Limit displayed %s by..."), 
				       items);
			   clear_error();
			   if (limit() != 0) {
			     get_page(current);
			     redraw++;
			   } else {
			     nufoot++;
			   }
			   break;

            case ctrl('T') :
	    case 'T'	   :
	    case 't'       :  if (message_count < 1) {
				lib_error(CATGETS(elm_msg_cat, ElmSet, 
						  ElmNoItemToTag,
						  "No %s to tag!"), 
					  items);
				
			      }
			      else if (ch == 't')
				tag_message(TRUE); 
			      else if (ch == 'T') {
				tag_message(TRUE); 
				goto next_undel_msg;
			      }
			      else
				meta_match(TAGGED);
			      break;

	    case 'U'    :  if (message_count < 1) {
			     lib_error(CATGETS(elm_msg_cat, ElmSet,
                                               ElmNoItemToMarkUnread,
			                       "No %s to mark as unread!"),
                                       items);
			     
			   }
			   else
			     unread_msg(TRUE);
			   break;

	    case 'u'    :  if (message_count < 1) {
			     lib_error(CATGETS(elm_msg_cat, ElmSet, 
					       ElmNoItemToMarkUndeleted,
					       "No %s to mark as undeleted!"), 
				       items);
			     
			   }
			   else {
			     undelete_msg(TRUE);
			     if (resolve_mode) 	/* move after mail resolved */
			       if((i=next_message(current-1, FALSE)) != -1) {
				 current = i+1;
				 nucurr = get_page(current);
			       }
/*************************************************************************
 **  What we've done here is to special case the "U)ndelete" command to
 **  ignore whether the next message is marked for deletion or not.  The
 **  reason is obvious upon usage - it's a real pain to undelete a series
 **  of messages without this quirk.  Thanks to Jim Davis @ HPLabs for
 **  suggesting this more intuitive behaviour.
 **
 **  The old way, for those people that might want to see what the previous
 **  behaviour was to call next_message with TRUE, not FALSE.
**************************************************************************/
			   }
			   break;

	    case ctrl('U') : if (message_count < 1) {
			       lib_error(CATGETS(elm_msg_cat, ElmSet, 
						 ElmNoItemToUndelete,
						 "No %s to undelete!"), 
					 items);
			       
			     }
			     else 
			       meta_match(UNDELETE);
			     break;

	    case ctrl('L') : redraw++;	break;

	    case NO_OP_COMMAND : break;	/* noop for timeout loop */

	    default	: if (ch > '0' && ch <= '9') {
		             Write_to_screen(CATGETS(elm_msg_cat, ElmSet,
						     ElmNewCurrentItem,
						     "New Current %s"), 
					     Item);
			    i = read_number(ch, item);

			    if( i > message_count)
			      lib_error(CATGETS(elm_msg_cat, ElmSet, 
						ElmNotThatMany,
						"Not that many %s."), 
					items);
			    else if(selected
				&& isoff(ifmain(headers[i-1]->status,
			                        aliases[i-1]->status), VISIBLE))
			      lib_error(CATGETS(elm_msg_cat, ElmSet, 
						ElmNotInLimitedDisplay,
						"%s not in limited display."),
					Item);
			    else {
			      current = i;
			      nucurr = get_page(current);
			    }
			  }
			  else {
	 		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
					      ElmUnknownCommand,
					      "Unknown command. Use '?' for help."));
			    
			  }
	}
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
