static char rcsid[] = "@(#)$Id: builtin++.c,v 1.15 2001/06/06 18:09:05 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.15 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *
 *  Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "headers.h"
#include "me.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ui");

extern int errno;
extern int tabspacing;

static void builtin_help P_((void));
static void builtin_help () {
  /* A help screen for the pager below. */

redraw:
  ClearScreen ();
  StartInverse();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpTitle,
			   "Help for builtin++"));
  EndInverse();
  NewLine ();
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpKeyA,
			   "Key\t\tAction"));
  NewLine ();
  Write_to_screen (FRM("---\t\t------"));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpSpace,
			   "<SPACE>, +\tNext page."));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpMinus,
			   "-\t\tPrevious page."));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpReturn,
			   "<RETURN>\tNext line."));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpq,
			   "q, x, i\t\tReturn to the index menu."));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpDiv,
			   "/\t\tSearch for pattern in message."));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpArr,
			   "^\t\tFirst page."));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpG,
			   "G\t\tLast page."));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpCtrlL,
			   "^L\t\tRefresh display."));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpCtrlP,
			   "^P\t\tUp one line."));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpCtrlP,
			   "^D\t\tDown one-half page."));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpCtrlU,
			   "^U\t\tUp one-half page."));
  NewLine ();
  Write_to_screen (CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpQuestion,
			   "?\t\tThis help screen."));
  NewLine ();
  PutLineX (elm_LINES, 0, 
	    CATGETS(elm_msg_cat, ElmSet, ElmBuiltinHelpPressRet,
		    "Press any key to return..."));
  if (REDRAW_MARK == ReadCh (REDRAW_MARK))
    goto redraw;

  return;
}

static int search_it P_((struct stringbuffer * bout, int start_idx,
			 struct string * search_pattern));

static int search_it(bout,start_idx,search_pattern)
     struct stringbuffer * bout; 
     int start_idx;
     struct string * search_pattern;
{
    int ret = 0;
    int idx = start_idx;

    while (idx < linecount_stringbuffer(bout) && !ret) {
	struct string * buffer = get_line_from_stringbuffer(bout,idx);

	if (find_pattern_from_string(buffer,search_pattern,1))
	    ret = idx;
	
	idx++;
	free_string(&buffer);
    }
    DPRINT(Debug,3,
	   (&Debug,"Builtin pager: Search from line %d %s (%d)\n",
	    start_idx, 
	    ret ? "SUCCEED" : "FAILED",
	    ret));
    return ret;
}

int builtinplusplus (bout)
     struct stringbuffer * bout;
{   
    int idx = 0;
    int is_end = 0;

    /* Current line for outputting and position on it ... */
    struct string * buffer = NULL;
    int X = 0;
    struct string * search_pattern = NULL;        /* Last seach string */
   
    clear_error();
    
    for (;;) {
	int idx_top;             /* line number of top of display  */
	int ch;                  /* command key readed */
	int search_matches = 0;  /* First idx on page where search matches */
	int lines;               /* Number of visible lines printed
				    so far */
	int FF_seen;            /* If page is breaken because of FF */
 new_page:
	idx_top = idx;       /* line number of top of display  */
	lines = 0;           /* Number of visible lines printed
				so far */
        FF_seen = 0;

	ClearScreen();

    cr_restart:                  /* so that we can handle CR specially --
				    ie. don't reset page variables 
				 */
	while ((idx < linecount_stringbuffer(bout)) &&
	       lines < elm_LINES && !FF_seen) {
	    
	    int chars = 0; /* Number of characters on current line */
	    int mayclear = 1;

	    if (!buffer || X >= string_len(buffer)) {
		/* caller of get_line_from_stringbuffer is expected to 
		   free_string () resulting buffer */

		if (buffer) {
		    if (X >= string_len(buffer))
			idx++;
		    if (idx >= linecount_stringbuffer(bout))
			break;
		    free_string (&buffer);
		}
		X = 0;

		/* There is no pending data to output, so we need to grab 
		 * another line.
		 */

		buffer = get_line_from_stringbuffer(bout,idx);		
	    }

	    /* This is the part of the code that actually displays on 
	     * the screen 
	     */
	    chars = 0;
	    while (X < string_len(buffer)) {
		uint16 ch;
		int len = 0;   /* Length for next clip ... */
		struct string * data;

		if (chars >= elm_COLUMNS)
		    break;
		
		ch = give_unicode_from_string(buffer,X);
		if (ch <= 31) {
		    
		    /* Make sure that carbage from previous
		       output is not left */
		    if (mayclear) {
			CleartoEOLN();
			mayclear = 0;
		    }

		    switch(ch) {
		    case 0x0009:  /* HT */
			Writechar('\t');
			chars = ((chars / tabspacing ) +1) * tabspacing; 
			break;
		    case 0x000C:   /* FF */
		    case 0x000B:   /* VT */
			FF_seen = 1;
			/* FALLTHRU */
		    case 0x000A:   /* LF */
			X++;
			goto out;

		    default:
			/* This won't fit on the line, so just skip it 
			   for now */
			if (chars == elm_COLUMNS - 1)
			    break;
			/* Output character set is assumed to be ASCII
			   compatible on here: */
			StartBold();
			Writechar('^');
			Writechar(ch + 64);
			EndBold();
			chars += 2;
			break;
		    }

		    X++;
		    continue;
		}
		
		/* calculate clip len ... */
		while (X + len     < string_len(buffer) &&
		       chars + len < elm_COLUMNS) {
		    ch = give_unicode_from_string(buffer,X+len);
		    if (ch <= 31)
			break;
		    len++;
		}
		
		if (len < 1)
		    continue;    /* next character was also control char */

		/* clip_from_string updates X */
		data = clip_from_string(buffer,&X,len);
		chars += len;   /* This assumes that all characters will
				   be printed, but because non-printable
				   characters well be printed with 
				   replacement char, that is quite correct
				*/

		if (search_matches &&
		    search_matches == idx)
		    StartBold();
		Write_to_screen(FRM("%S"),data);
		if (search_matches &&
		    search_matches == idx)
		    EndBold();		
		free_string(&data);
	    }

	    /* Make sure that carbage from previous
	       output is not left */
	    if (mayclear) {
		CleartoEOLN();
		mayclear = 0;
	    }


		 out:
	    NewLine();
	    lines++;
	}

	CleartoEOS();
	if (lines < elm_LINES && FF_seen) {
	    StartBold();
	    PutLineX (lines, 0, 
		      CATGETS(elm_msg_cat, ElmSet, ElmBuiltinNewPage,
			      "~ (new page) "));
	    EndBold();  CleartoEOLN(); 
	    NewLine();
	    lines++;
	}
	while (lines < elm_LINES) {
	    Writechar('~'); NewLine();
	    CleartoEOLN();
	    lines++;
	}

    reprompt:
	StartBold();
	
	if (idx >= linecount_stringbuffer(bout)) {
	    PutLineX (elm_LINES, 0, 
		      CATGETS(elm_msg_cat, ElmSet, ElmBuiltinCommandi,
			      "Command ('i' to return to index):"));
	    is_end = 1;
	}
	else {
	    int relative;
	    if (linecount_stringbuffer(bout) < 1)
		relative = 100;
	    else
		relative = 100 * idx / linecount_stringbuffer(bout);
	    
	    if (user_level == 0)
		PutLineX (elm_LINES, 0, 
			  CATGETS(elm_msg_cat, ElmSet, ElmBuiltInMore0,
				  "MORE (line %d-%d/%d, you've seen %d%%). Press <space> for more:"), 
			  idx_top+1,idx,linecount_stringbuffer(bout),
			  relative);
	    else
		PutLineX (elm_LINES, 0, 
			  CATGETS(elm_msg_cat, ElmSet, ElmBuiltInMore,
				  "MORE (line %d-%d/%d, you've seen %d%%):"), 
			  idx_top+1,idx,linecount_stringbuffer(bout),
			  relative);
	    is_end = 0;
	}
	EndBold();
	
    read_key:
	ch = ReadCh (REDRAW_MARK|READCH_CURSOR);

	if (ch != '/') {
	    if (search_pattern) {
		free_string(&search_pattern);
	    }
	}

	switch (ch) {
	case ' ':
	case '+':
	case PAGEDOWN_MARK:
	    if (is_end) {
		return (' ');
	    }
	break;
	case HOME_MARK:
	case '^':      
	    idx = 0;
	    /* Avoid incrementing of idx: */
	    if (buffer)    
		free_string (&buffer);
	    break;
	case 'G':
	    /* Not completely correct if multiline lines */
	    idx = linecount_stringbuffer(bout)-elm_LINES+1;
	    if (idx < 0)
		idx = 0;
	    lines = 0;
	    /* Avoid incrementing of idx: */
	    if (buffer)    
		free_string (&buffer);
	    ClearScreen ();
	    break;
	case FIND_MARK:
	case '/':
	    ClearLine (elm_LINES);
	    {
		int code;
		
		code = optionally_enter2 (&search_pattern,
					  elm_LINES, 0, 
					  OE_REDRAW_MARK, 
					  CATGETS(elm_msg_cat, ElmSet, 
						  ElmBuiltinSearch,
						  "Search: "));

		if (REDRAW_MARK == code)
		    goto redraw;
		if (code < 0)
		    goto quit;
		if (search_pattern && string_len(search_pattern)) {
		    int start_idx;
		    /* Continue search from previous match */
		    if (!search_matches)
			start_idx = idx_top;
		    else if (search_matches < linecount_stringbuffer(bout))
			start_idx = search_matches+1;
		    else
			start_idx = idx_top;
		    search_matches = search_it(bout,start_idx,
					       search_pattern);
		    if (search_matches) {
			if (search_matches > idx_top && 
			    search_matches < idx_top + elm_LINES -3)
			    idx = idx_top;
			else
			    idx = search_matches - elm_LINES / 2;
			if (idx < 0)
			    idx = 0;
			/* Avoid incrementing of idx: */
			if (buffer)    
			    free_string (&buffer);
			goto new_page; /* and draw match */
		    } else {
			int relative;
			if (linecount_stringbuffer(bout) < 1)
			    relative = 100;
			else
			    relative = 100 * idx / linecount_stringbuffer(bout);
			
			ClearLine (elm_LINES);
			StartBold();
			if (user_level == 0)
			    PutLineX (elm_LINES, 0, 
				      CATGETS(elm_msg_cat, ElmSet, ElmBuiltInNotFound0,
					      "NOT FOUND! (line %d-%d/%d, you've seen %d%%). Press <space> for more:"), 
				      idx_top+1,idx,linecount_stringbuffer(bout),
				      relative);
		    else
			PutLineX (elm_LINES, 0, 
				  CATGETS(elm_msg_cat, ElmSet, 
					  ElmBuiltInNotFound,
					  "NOT FOUND! (line %d-%d/%d, you've seen %d%%):"), 
				  idx_top+1,idx,linecount_stringbuffer(bout),
				  relative);		    
			EndBold();
			goto read_key;
		    }
		} 
		goto reprompt;
	    }	    
	case PAGEUP_MARK:
	case '-':
	    idx = idx_top - elm_LINES;
	    if (idx < 0)
		idx = 0;
	    if (buffer)
		free_string(&buffer);
	    break;
	case ctrl('P'):
	    idx = idx_top -1;
	    if (idx < 0)
		idx = 0;
	    if (buffer)
		free_string(&buffer);
	    break;
	case ctrl('D'):
	    if (is_end) 
		goto reprompt; /* Can't go down */
	    lines = elm_LINES / 2;
	    CarriageReturn();
	    if (CleartoEOLN() >= 0) {
		idx_top += elm_LINES / 2;
		goto cr_restart; /* Hanlde Ctrl-D specially */
	    }
	    
	    idx = idx_top + elm_LINES / 2;
	    if (idx < 0)
		idx = 0;
	    if (buffer)
		free_string(&buffer);
	    break;
	    
	case ctrl('U'):
	    idx = idx_top - elm_LINES / 2;
	    if (idx < 0)
		idx = 0;
	    if (buffer)
		free_string(&buffer);
	    break;
	case HELP_MARK:
	case '?':
	    builtin_help ();
	    /* FALLTHRU */
	redraw:
	case REDRAW_MARK:
	case ctrl('L'): 
	    idx = idx_top;
	    if (buffer)
		free_string(&buffer);
	    break;
	case '\n':
	    if (FF_seen)
		break;   /* New page */
	    {
		int x, y;
		
		GetXYLocation (&x, &y);
		ClearLine (x);
	    }
	    lines = elm_LINES - 1;
	    idx_top++;
	    goto cr_restart; /* Hanlde CR specially */
	quit:
	case EOF:
	default:
	return (ch == 'q' || ch == 'x' ? 0 : ch);
	}
    }
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */


