static char rcsid[] = "@(#)$Id: addr_util.c,v 1.21 2001/06/06 18:09:03 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.21 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This file contains addressing utilities 

**/

#include "headers.h"
#include "s_elm.h"
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"addr");

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}
static char *us2s P_((unsigned char *str));
static char *us2s(str) 
     unsigned char *str;
{
    return (char *)str;
}


static int add_expanded_ P_((struct expanded_address *x,
			     const char *ADR, 
			     const struct string *FN,
			     const struct string *COM));
static int add_expanded_ (x,ADR,FN,COM)
     struct expanded_address *x;
     CONST char *ADR;
     CONST struct string *FN;
     CONST struct string *COM;
{
    x->addrs = safe_realloc(x->addrs,(x->addrs_len + 2) * 
			    sizeof (struct addr_item));
    x->addrs[x->addrs_len].addr     = safe_strdup(ADR);
    x->addrs[x->addrs_len].fullname = dup_string(FN);
    x->addrs[x->addrs_len].comment  = dup_string(COM);
    x->addrs[x->addrs_len+1].addr     = NULL;
    x->addrs[x->addrs_len+1].fullname = NULL;
    x->addrs[x->addrs_len+1].comment  = NULL;
    return x->addrs_len++;
}

static int add_textual_ P_((struct expanded_address *x,
			    const char *TEXTUAL, int POS, int LEN));
static int add_textual_ (x,TEXTUAL,POS,LEN)
     struct expanded_address *x;
     CONST char *TEXTUAL;
     int POS, LEN;
{
    x->surface = safe_realloc(x->surface,(x->surface_len + 2) * 
			      sizeof (struct textual));
    if (!TEXTUAL)
	x->surface[x->surface_len].textual     = NULL;
    else
	x->surface[x->surface_len].textual     = safe_strdup(TEXTUAL);
    x->surface[x->surface_len].pos         = POS;
    x->surface[x->surface_len].len         = LEN;
    x->surface[x->surface_len+1].textual   = NULL;
    x->surface[x->surface_len+1].pos       = POS+LEN;
    x->surface[x->surface_len+1].len       = 0;
    return x->surface_len++;
}

#define ADD_EXPANDED(x,ADR,FN,COM)  add_expanded_(&x,ADR,FN,COM)
#define ADD_TEXTUAL(x,TEXTUAL,POS,LEN) add_textual_(&x,TEXTUAL,POS,LEN)

void zero_expanded_address (x)
     struct expanded_address *x;
{
    x->addrs        = NULL;
    x->addrs_len    = 0;
    x->surface      = NULL;
    x->surface_len  = 0;
}

int aliases_to_expanded(x)
     struct expanded_address *x;
{
    int i;
    int tagged = 0;
    CONST int NEWPOS = x->addrs_len;
    
    for (i=0; i < message_count; i++) {
	if (ison(aliases[i]->status, TAGGED)) {
	    add_textual_(x,aliases[i]->alias,NEWPOS,0);
	    tagged++;
	}
    }
    
    if (tagged == 0) {
	add_textual_(x,aliases[current-1]->alias,NEWPOS,0);
    }

    return tagged;
}

static char * make_surface P_((struct addr_item ITEM));
static char * make_surface(ITEM)
     struct addr_item ITEM; 
{
    char * result = NULL;
    
    if (string_len(ITEM.fullname)) {
	struct string * temp = convert_string(display_charset,ITEM.fullname,1);
       	char * D = us2s(stream_from_string(temp,1,NULL)), *p;

	/* No fancy quotation stuff on textual form for editing */
	for (p = D; *p; p++) {	    	    
	    switch(*p) {
	    case '"': case '\\': 
		*p = '_';
		break;
	    }
	}

	result = strmcat(result,"\"");
	result = strmcat(result,D);
	result = strmcat(result,"\" ");
	free(D);
	free_string(&temp);
    }

    result = strmcat(result,"<");
    result = strmcat(result,ITEM.addr);
    result = strmcat(result,">");
    
    if (string_len(ITEM.comment)) {
	struct string * temp = convert_string(display_charset,ITEM.comment,1);
	char * D = us2s(stream_from_string(temp,1,NULL)), *p;

	/* No fancy quotation stuff on textual form for editing */
	for (p = D; *p; p++) {	    	    
	    switch(*p) {
	    case '"': case '\\': case '(': case ')':
		*p = '_';
		break;
	    }
	}

	result = strmcat(result," (");
	result = strmcat(result,D);
	result = strmcat(result,")");
	free(D);
	free_string(&temp);
		
    }

    return result;
}

void free_expanded_address(x)
     struct expanded_address *x;
{
    int i;
    
    if (x->addrs_len)
	free_addr_items(x->addrs);
    x->addrs = NULL;
    x->addrs_len = 0;
    
    if (x->surface_len) {
	for (i = 0; i < x->surface_len; i++) {
	    if (x->surface[i].textual) {
		free(x->surface[i].textual);
		x->surface[i].textual = NULL;
	    }
	}
	free(x->surface);
	x->surface = NULL;
	x->surface_len = 0;
    }
}

void copy_expanded_address (result,source) 
     struct expanded_address *result;
     struct expanded_address source;
{
    int i;
    free_expanded_address(result);
    
    for (i = 0; i < source.surface_len; i++) {
	int count = 0;
	int pos = result->addrs_len;
	int j;
	for (j = 0; j < source.surface[i].len; j++) {
	    CONST struct addr_item *ptr1 = & 
		(source.addrs[source.surface[i].pos+j]);
	    int p = add_expanded_(result,ptr1->addr,ptr1->fullname,
				  ptr1->comment);
	    if (0 == count)
		pos = p;
	    count++;
	}
	add_textual_(result,source.surface[i].textual,pos,count);      
    }
}

void dump_expanded_address(debuglevel,text,expanded)
     int debuglevel; 
     CONST char *text;
     struct expanded_address expanded;

{
    struct textual *ptr;
    int l = strlen(text);
    int LASTPOS = -1;

    DPRINT(Debug,debuglevel,
	   (&Debug, 
	    "%s: %d surfaces, %d addresses\n",
	    text, expanded.surface_len, expanded.addrs_len));
 
    for (ptr = expanded.surface; 
	 ptr < expanded.surface + expanded.surface_len; 
	 ptr++) {
	int j;
	if (!ptr->textual) {
	    DPRINT(Debug,debuglevel,
		   (&Debug, 
		    "%*s [%d] surface NULL! \t(%d addresses)\n",
		    l,"",ptr-expanded.surface,ptr->len));
	} else {
	    DPRINT(Debug,debuglevel,
		   (&Debug, 
		    "%*s [%d] surface=%s \t(%d addresses)\n",
		    l,"",ptr-expanded.surface,ptr->textual,
		    ptr->len));
	}
	if (ptr->pos != LASTPOS + 1) {     
	    DPRINT(Debug,debuglevel,
		   (&Debug, 
		    "%*s [%d] ERROR!  address pos = %d != %d (lastpost +1)\n",
		    l,"",ptr-expanded.surface, ptr->pos, LASTPOS+1));			
	}
	for (j = 0; j < ptr->len; j++) {
	    if (ptr->pos < 0 || ptr->pos >= expanded.addrs_len) {
		DPRINT(Debug,debuglevel,
		       (&Debug, 
			"%*s    %d [%d] ERROR, not range 0 - %d\n",
			l,"",j,ptr->pos,
			expanded.addrs_len-1));
	    } else {
		CONST struct addr_item *ptr1 = & (expanded.addrs[ptr->pos]);
		if (!ptr1->addr || !ptr1->fullname || !ptr1->comment) {
		    DPRINT(Debug,debuglevel,
			   (&Debug, 
			    "%*s    %d [%d] ERROR! NULL element!\n",
			    l,"",j,ptr->pos));
		} else {
		    DPRINT(Debug,debuglevel,
			   (&Debug, 			    
			    "%*s    %d [%d] addr=%s \tfullname=%S\tcomment=%S\n",
			    l,"",j,ptr->pos,
			    ptr1->addr,ptr1->fullname,
			    ptr1->comment));
		}
		LASTPOS = ptr->pos;
	    }
	}
    }
    DPRINT(Debug,debuglevel,
	   (&Debug, 
	    "%*s === end\n",l,""));
}

char * kludge_addr(char **addr) {
    char * ptr = *addr;
    int l = strlen(ptr);
    char *res;
    
    ptr = safe_realloc(ptr,l + 1 + 2 + l + 1);

    res = ptr + l + 1;

    res[0] = '<';
    strfcpy(res+1,ptr,l+1);
    res[l+1] = '>';
    res[l+2] = '\0';

    *addr = ptr;
    return res;
}

extern char **argv_from_headers (headers)
     struct mailing_headers * headers;
{
    int count = 
	headers->to.addrs_len + 
	headers->cc.addrs_len + headers->bcc.addrs_len;
    char **res;
    int idx = 0,i;
    struct addr_item *p;
        
    DPRINT(Debug,6,
	   (&Debug,  "argv_from_headers, count=%d\n",count));
    
    res = safe_malloc((count + 1) * sizeof (char *));
    
    dump_expanded_address(6,"argv_from_headers -- enter (to)",headers->to);

    for (p = headers->to.addrs; 
	 p < headers->to.addrs + headers->to.addrs_len;
	 p++) {
	if (p->addr[0] == '-' || p->addr[0] == '@' ||
	    p->addr[0] == '\0')
	    /* Modify p->addr so that there is space
	     * alloced also for <addr> form 
	     */
	    res[idx++] = kludge_addr(&p->addr);
	else
	    res[idx++] = p->addr;
    }

    dump_expanded_address(6,"argv_from_headers -- enter (cc)",headers->cc);

    for (p = headers->cc.addrs; 
	 p < headers->cc.addrs + headers->cc.addrs_len;
	 p++) {
	if (p->addr[0] == '-' || p->addr[0] == '@' ||
	    p->addr[0] == '\0')
	    /* Modify p->addrs so that there is space
	     * alloced also for <addr> form 
	     */
	    res[idx++] = kludge_addr(&p->addr);
	else
	    res[idx++] = p->addr;
    }

    dump_expanded_address(6,"argv_from_headers -- enter (bcc)",headers->bcc);

    for (p = headers->bcc.addrs; 
	 p < headers->bcc.addrs + headers->bcc.addrs_len;
	 p++) {
	if (p->addr[0] == '-' || p->addr[0] == '@' ||
	    p->addr[0] == '\0')
	    /* Modify p->addrs so that there is space
	     * alloced also for <addr> form 
	     */
	    res[idx++] = kludge_addr(&p->addr);
	else
	    res[idx++] = p->addr;
    }
    
    res[idx] = NULL;
    
    DPRINT(Debug,6,
	   (&Debug, "           idx=%d\n",idx));
    for (i = 0; i < idx; i++) 
	DPRINT(Debug,6,
	       (&Debug, "           [%d]=%s\n",i,res[i]));

    dump_expanded_address(7,"argv_from_headers -- leave (to)",headers->to);
    dump_expanded_address(7,"argv_from_headers -- leave (cc)",headers->cc);
    dump_expanded_address(7,"argv_from_headers -- leave (bcc)",headers->bcc);

    return res;
}


int argv_to_expanded(result,argv)
     struct expanded_address *result;
     char *argv[];
{
    int i,res;
    free_expanded_address(result);

    DPRINT(Debug,6,
	   (&Debug, "argv_to_expanded:"));
    for (i = 0;  argv[i]; i++) {
	DPRINT(Debug,6,
	       (&Debug, " [%d]=%s",i,argv[i]));
    }
    DPRINT(Debug,6,
	   (&Debug,"\n"));

    for (i = 0;  argv[i]; i++) {
	add_textual_(result,argv[i],0,0);
    }

    dump_expanded_address(6,"argv_to_expanded: before build_address_l()",
			  *result);

    /* And make address structures */
    res = build_address_l(result);

    dump_expanded_address(6,"argv_to_expanded: (result)",*result);

    DPRINT(Debug,6,
	   (&Debug, "argv_to_expanded=%d\n",res));
    return res;
}

void addr_to_expanded(result,addrs)
     struct expanded_address *result;
     struct addr_item *addrs;
{
    int i;
    free_expanded_address(result);

    DPRINT(Debug,6,
	   (&Debug ,"addr_to_expanded:"));
    if (!addrs) {
	DPRINT(Debug,6,
	       (&Debug ," -- NULL"));
    } else {
	for (i = 0;  
	     addrs[i].addr && addrs[i].fullname && addrs[i].comment; i++) {
	    DPRINT(Debug,6,
		   (&Debug, 		    
		    " [%d]: {addr=%s, fullname=%S, comment=%S}",
		    i,
		    addrs[i].addr, addrs[i].fullname, 
		    addrs[i].comment));
	    
	}
    }
    DPRINT(Debug,6,
	   (&Debug, "\n"));
    
    for (i = 0;  
	 addrs && addrs[i].addr && addrs[i].fullname && addrs[i].comment; 
	 i++) {
	int pos = add_expanded_(result,addrs[i].addr, 
				addrs[i].fullname, addrs[i].comment);
	add_textual_(result,NULL,pos,1);
    }

    dump_expanded_address(7,"addr_to_expanded: before build_address_l()",
			  *result);

    /* And make address structures */
    build_address_l(result);

    dump_expanded_address(6,"addr_to_expanded: (result)",*result);
}

void expanded_to_edit_buffer(buffer,size,expanded)
     char * buffer;
     int size;  
     struct expanded_address expanded;
{
    struct textual *ptr;
    buffer[0] = '\0';

    DPRINT(Debug,6,
	   (&Debug, "expanded_to_edit_buffer: size=%d\n",size));
    dump_expanded_address(6,"expanded_to_edit_buffer",expanded);

    for (ptr = expanded.surface; 
	 ptr < expanded.surface + expanded.surface_len; 
	 ptr++) {
	if (buffer[0]) 
	    strfcat(buffer,", ",size);
	strfcat(buffer,ptr->textual,size);
    }
    DPRINT(Debug,6,
	   (&Debug, "expanded_to_edit_buffer: (result) buffer=%s\n",
	    buffer));
}

void update_expanded_from_edit_buffer(expanded,buffer)
     struct expanded_address *expanded;
     CONST char *buffer;
{
    int i,next;
    struct expanded_address result;
    struct textual *ptr = expanded->surface;
    char ** tokenized = rfc822_tokenize(buffer);

    zero_expanded_address(&result);

    DPRINT(Debug,6,
	   (&Debug, "update_expanded_from_edit_buffer: buffer=%s\n",
	    buffer));
    dump_expanded_address(6,"expanded_to_edit_buffer: (initial)",*expanded);

    for (i = 0; tokenized[i]; i = next) {
	CONST int NEWPOS = result.addrs_len;
	char * surface = NULL;
	int q= 0, spacecount =  0, q_seen = 0;

	DPRINT(Debug,9,
	       (&Debug, 
		"expanded_to_edit_buffer: [%d]=\"%s\"\n",
		i,tokenized[i]));

	if (whitespace(tokenized[i][0]) ||
	    ',' == tokenized[i][0]) {
	    next = i+1;
	    continue;
	}
	for (next = i; tokenized[next]; next++) {
	    if ('<' == tokenized[next][0]) {
		q++;
		q_seen = 1;
	    } else if ('>' == tokenized[next][0])
		q--;
	    else if (!q && ',' == tokenized[next][0])
		break;
	    else if (!q && q_seen && 
		     !whitespace(tokenized[next][0]) &&
		     '(' != tokenized[next][0])
		break;
	    else if (!q && whitespace(tokenized[next][0]) &&
		     tokenized[next+1] && '(' == tokenized[next+1][0])
		/* Don't count whitespaces before comments */  ;
	    else if (!q && q_seen &&
		     whitespace(tokenized[i][0]))
		break;
	    else if (!q && whitespace(tokenized[next][0]))
		spacecount ++;

	    DPRINT(Debug,9,
		   (&Debug, 
		    "expanded_to_edit_buffer+ [%d]=\"%s\" q=%d\n",
		    next,tokenized[next],q));
	    
	    surface = strmcat(surface,tokenized[next]);     	       
	}

	DPRINT(Debug,9,
	       (&Debug, 
		"expanded_to_edit_buffer- spacecount=%d, q=seen=%d\n",
		spacecount,q_seen));

  
	if (surface && ptr < expanded->surface + expanded->surface_len &&
	    0 == strcmp(ptr->textual,surface)) {
	    int r;
	    int pos = NEWPOS;
	    int count = 0;
	    int j;
	    /* no change -- copy original */
      
	    for (j = 0; j < ptr->len; j++) {
		CONST struct addr_item *ptr1 = & (expanded->addrs[ptr->pos+j]);
		int p = ADD_EXPANDED(result,ptr1->addr,ptr1->fullname,
				     ptr1->comment);
		if (0 == count)
		    pos = p;
		count++;
	    }
	    r=ADD_TEXTUAL(result,ptr->textual,pos,count);
	    DPRINT(Debug,9,
		   (&Debug, 
		    "expanded_to_edit_buffer-> [%d] = %s (keep %d addresses)\n",
		    r,surface,count));
	    
	}

	/* Starting with - is alias expansion removing syntax */
	else if (tokenized[i][0] == '-') {
	    int r;
	    char * surface1 = NULL;
      
	    DPRINT(Debug,9,
		   (&Debug, 
		    "expanded_to_edit_buffer= resscan from %d\n",i));
			   
	    for (next = i; tokenized[next]; next++) {
		if ('<' == tokenized[next][0] ||
		    '>' == tokenized[next][0] ||
		    ',' == tokenized[next][0] ||
		    whitespace(tokenized[next][0]))
		    break;

		DPRINT(Debug,9,
		       (&Debug, 
			"expanded_to_edit_buffer+ [%d]=\"%s\"\n",
			next,tokenized[next]));
		
		surface1 = strmcat(surface1,tokenized[next]);     	       
	    }
	    
	    r=ADD_TEXTUAL(result,surface1,NEWPOS,0);
	    DPRINT(Debug,9,
		   (&Debug, 
		    "expanded_to_edit_buffer-> [%d] = %s\n",
		    r,surface1));
	    
	    if (surface1)
		free(surface1);
	    
	    /* word <address> */
	} else if (spacecount <= 1 && q_seen) {
	    int r = ADD_TEXTUAL(result,surface,NEWPOS,0);
	    DPRINT(Debug,9,
		   (&Debug, "expanded_to_edit_buffer-> [%d] = %s\n",
		    r,surface));
	} else {
	    char * surface1 = NULL;
	    int r;

	    DPRINT(Debug,9,
		   (&Debug, 
		    "expanded_to_edit_buffer= resscan from %d\n",i));
	    
	    for (next = i; tokenized[next]; next++) {
		if (!q && whitespace(tokenized[next][0]) &&
		    tokenized[next+1] && '(' == tokenized[next+1][0])
		    /* Don't break on whitespaces before comments */  ;
		else if ('<' == tokenized[next][0] ||
			 '>' == tokenized[next][0] ||
			 ',' == tokenized[next][0] ||
			 whitespace(tokenized[next][0]))
		    break;

		DPRINT(Debug,9,
		       (&Debug, 
			"expanded_to_edit_buffer+ [%d]=\"%s\"\n",
			next,tokenized[next]));

		surface1 = strmcat(surface1,tokenized[next]);     	       
	    }

	    r=ADD_TEXTUAL(result,surface1,NEWPOS,0);
	    DPRINT(Debug,9,
		   (&Debug, "expanded_to_edit_buffer-> [%d] = %s\n",
		    r,surface1));
	    
	    if (surface1)
		free(surface1);
	}

	if (ptr < expanded->surface + expanded->surface_len)
	    ptr++;
	if (surface)
	    free(surface);


	if (i == next) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmUnparseable,
			      "Unparseable (%s): %s"),
		      tokenized[next],buffer);
	    next++;
	}
    }

    dump_expanded_address(6,"expanded_to_edit_buffer: before build_address_l",
			  result);

    build_address_l(&result);

    free_expanded_address(expanded);
    *expanded = result;   /* put new (same?) result to place */

    if (tokenized)
	free(tokenized);

    dump_expanded_address(6,"expanded_to_edit_buffer: (result)",*expanded);
}

int make_from_addr(expanded)
     struct expanded_address *expanded;
{
    int res;
    int pos;
    struct string * comment = new_string(display_charset);
    struct string * name    = new_string2(display_charset,s2us(full_username));

    free_expanded_address(expanded);

    /* If on username is strange characters (specially if username
       is from some other user database backend than from /etc/passwd)
       then quote it...
    */
    if (NULL != strpbrk(username,
			":\"\\!#%&()=?',;.:")) {
	char * Q = elm_message(FRM("%Q"),username);

	DPRINT(Debug,6,
	       (&Debug, "make_from_addr: Quoting username: %s\n",Q));

	pos = add_expanded_(expanded,Q,name,comment);
	free(Q);
    } else
	pos = add_expanded_(expanded,username,name,comment);
#ifdef USE_DOMAIN
    expanded->addrs[pos].addr = strmcat(expanded->addrs[pos].addr,"@");
    expanded->addrs[pos].addr = strmcat(expanded->addrs[pos].addr, 
					hostfullname);
#endif
    add_textual_(expanded,NULL,pos,1);

    dump_expanded_address(6,"make_from_addr: before build_address_l",
			  *expanded);

    /* And make address structures */
    res = build_address_l(expanded);

    dump_expanded_address(6,"make_from_addr: (result)",*expanded);
        DPRINT(Debug,6,
	       (&Debug, "make_from_addr=%d\n",res));

    free_string(&name);
    free_string(&comment);

    return res;
}

int build_address_l(expanded)
     struct expanded_address *expanded;
{
    struct textual *ptr;
    int expands = 0;
    struct expanded_address result;
    int too_long = FALSE;

    dump_expanded_address(9,"build_address_l",*expanded);

    zero_expanded_address(&result);

    for (ptr = expanded->surface; 
	 ptr < expanded->surface + expanded->surface_len; 
	 ptr++) {
	CONST int NEWPOS = result.addrs_len;
	struct addr_item * aliases;

	if (!ptr->textual) {

	    if (ptr->len == 1) {
		/* If we have no textual presentation we are converting
		 * from struct addrs
		 */
		char *temp = make_surface(expanded->addrs[ptr->pos]);
		int pos = ADD_EXPANDED(result,
				       expanded->addrs[ptr->pos].addr,
				       expanded->addrs[ptr->pos].fullname,
				       expanded->addrs[ptr->pos].comment);
		ADD_TEXTUAL(result,temp,pos,1);
	
		free(temp);
	    } else {
		DPRINT(Debug,1,
		       (&Debug, 
			"build_address_l: SOFWARE ERROR: [%d]: textual=NULL, len=%d\n",
			ptr - expanded->surface, ptr->len));
	    }
	}

	else if (ptr->textual[0] == '-') {
	    /* Is also on result's remove list */
	    ADD_TEXTUAL(result,ptr->textual,NEWPOS,0);
	}

	else if (qstrpbrk(ptr->textual,"!@: <>,()") != NULL) {
	    char * temp = NULL;
	    if (ptr->len == 1) 
		temp = make_surface(expanded->addrs[ptr->pos]);

	    if (temp && 0 == strcmp(temp,ptr->textual)) {
		/* no change -- preserve original address */

		int pos = ADD_EXPANDED(result,
				       expanded->addrs[ptr->pos].addr,
				       expanded->addrs[ptr->pos].fullname,
				       expanded->addrs[ptr->pos].comment);
		ADD_TEXTUAL(result,temp,pos,1);

	    } else {
		/* generate addresses from textual 'surface' presentation */
		int pos = NEWPOS;
		int count = 0;
		struct addr_item * address =
		    break_down_address(ptr->textual, 
				       /* If user pastes encoded words from 
					* somewhere decode them also.
					*/
				       is_rfc1522(ptr->textual),
				       display_charset);
				 
		struct addr_item *ptr1;

		for (ptr1 = address; 
		     ptr1 && ptr1 -> addr && ptr1->fullname && ptr1->comment; 
		     ptr1++) {
		    int p;
		    
		    if (qstrpbrk(ptr1->addr,"!:@") == NULL) {
#ifdef USE_DOMAIN
			ptr1->addr = strmcat(ptr1->addr,"@");
			ptr1->addr = strmcat(ptr1->addr, hostfullname);
#endif
		    }

		    p = ADD_EXPANDED(result,ptr1->addr,
				      ptr1->fullname, ptr1->comment);
		    if (0 == count)
			pos = p;
		    count++;
		}
		ADD_TEXTUAL(result,ptr->textual,pos,count);
		if (address)
		    free_addr_items(address);
	    }

	    if (temp)
		free(temp);

	} 
	
	else if (NULL != (aliases = 
			  get_alias_address_l(ptr->textual, TRUE, &too_long))) {
	    struct addr_item *ptr1;
	    int pos = NEWPOS;
	    int count = 0;

	    expands = 1;

	    for (ptr1 = aliases; 
		 ptr1 && ptr1 -> addr && ptr1->fullname && ptr1->comment; 
		 ptr1++) {
		struct textual *ptr2;
		int p;

		/* scan words to be eleminated */
		for (ptr2 = expanded->surface; 
		     ptr2 < expanded->surface + expanded->surface_len; 
		     ptr2++) {
		    if (ptr2 -> textual &&
			ptr2 -> textual[0] == '-') {
			if (0 == strcmp(ptr1->addr,&(ptr2->textual[1])))
			    break;
		    }    
		}

		if (ptr2 && ptr2 < expanded->surface + expanded->surface_len)
		    /* Is on eliminating list -- don't add */
		    continue;

		p = ADD_EXPANDED(result,ptr1->addr,ptr1->fullname,
				 ptr1->comment);
		if (0 == count)
		    pos = p;
		count++;
	    }
	    ADD_TEXTUAL(result,ptr->textual,pos,count);

	    if (aliases)
		free_addr_items(aliases);
	} 

	else if (too_long) {
	    DPRINT(Debug,2,
		   (&Debug, "Overflowed alias expansion for %s\n", 
		    ptr->textual));
	    continue;             /* Don't process */
	}

	else if (valid_name(ptr->textual)) {
	    struct string * gecos  = NULL; 
	    struct string * comment = NULL;
	    int pos;

	    /* Preserve possible comment */
	    if (ptr->len == 1)
		gecos = expanded->addrs[ptr->pos].fullname;
	    if (ptr->len == 1)
		comment = expanded->addrs[ptr->pos].comment;


	    if (!gecos || !string_len(gecos)) {
		char * A = get_full_name(ptr->textual);
		if (gecos)
		    free_string(&gecos);
		if (A)
		    gecos = new_string2(display_charset,s2us(A));
	    }
	    
	    if (!gecos)
		gecos = new_string(display_charset);
	    if (!comment)
		comment = new_string(display_charset);
	       
	    pos = ADD_EXPANDED(result,ptr->textual,gecos,comment);
#ifdef USE_DOMAIN
	    result.addrs[pos].addr = strmcat(result.addrs[pos].addr,"@");
	    result.addrs[pos].addr = strmcat(result.addrs[pos].addr, hostfullname);
#endif
	    ADD_TEXTUAL(result,ptr->textual,pos,1);
	}

	else { 
	    struct string * gecos  = NULL; 
	    struct string * comment = NULL;
	    int pos; 

	    /* Preserve possible comment */
	    if (ptr->len == 1)
		gecos = expanded->addrs[ptr->pos].fullname;
	    if (ptr->len == 1)
		comment = expanded->addrs[ptr->pos].comment;

	    if (!gecos)
		gecos = new_string(display_charset);
	    if (!comment)
		comment = new_string(display_charset);

	    pos = ADD_EXPANDED(result,ptr->textual,gecos,comment);
#ifdef USE_DOMAIN
	    result.addrs[pos].addr = strmcat(result.addrs[pos].addr,"@");
	    result.addrs[pos].addr = strmcat(result.addrs[pos].addr, hostfullname);
#endif
	    ADD_TEXTUAL(result,ptr->textual,pos,1);
	    
	    if (check_only) 
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmAliasUnknown,
				  "(alias \"%s\" is unknown)"), 
			  ptr->textual);
	}
    }

    free_expanded_address(expanded);
    *expanded = result;   /* put new (same?) result to place */

    dump_expanded_address(9,"build_address_l: (result)",*expanded);
    DPRINT(Debug,9,
	   (&Debug,"build_address_l=%d\n",expands));
    
    return expands;
}

void write_addr_header(f,hdr_name,addr,top_encoding,enmime,hdr_charset)
     FILE *f;
     char *hdr_name;
     struct addr_item * addr;
     int top_encoding;
     int enmime;
     charset_t hdr_charset;
{
    struct addr_item *p;
    long POS = ftell(f);

#define LEN (ftell(f)-POS)
#define WRAP print_EOLN(f,top_encoding), (POS = ftell(f)), fputc(' ',f)

    fputs(hdr_name,f);
    fputs(": ",f);

    DPRINT(Debug,9,
	   (&Debug, "write_addr_header: (enmime=%d) %s:",
	    enmime,hdr_name));
    
    for (p = addr; p && p->fullname && p->addr && p->comment; p++) {
	CONST int al = strlen(p->addr);
	CONST int fn = string_len(p->fullname);
	CONST int cm = string_len(p->comment);

	DPRINT(Debug,9,
	       (&Debug, "\n          [%d] ",p-addr));
	
	if (p != addr) {
	    fputs(", ",f);
	    DPRINT(Debug,9,
		   (&Debug, ", "));
	}
	if (LEN > 70 || al + fn + cm + LEN > 76) {
	    WRAP;
	    DPRINT(Debug,9,
		   (&Debug,"[WRAP]\n          [%d] ",p-addr));
	}
	
	if (fn || ! p->addr[0] || '@' == p->addr[0]) {
	    if (fn) {
		char * buffer = string_to_hdr(HDR_PHRASE, p->fullname,
					      hdr_charset, enmime);
		char * c;

		DPRINT(Debug,9,
		       (&Debug,"{fullname quoted=%s}\n",
			buffer));
		DPRINT(Debug,9,
		       (&Debug, "\n          [%d] ",p-addr));
	       		
		for (c = buffer; *c != '\0'; c++) {
		    if (*c == '\n' || 
			(whitespace(*c) && (LEN > 120))) {
			WRAP;
			DPRINT(Debug,9,
			       (&Debug, "[WRAP]\n          [%d] ",
				p-addr));
		    } else {
			fputc(*c,f);
			DPRINT(Debug,9,
			       (&Debug, "%c",*c));
		    }
		}
		free(buffer);
	    }

	    if (LEN > 120 || (LEN > 70 && fn > 70)) {
		WRAP;
		DPRINT(Debug,9,
		       (&Debug, "[WRAP]\n          [%d] ",p-addr));
	    } else {
		fputc(' ',f);
		DPRINT(Debug,9,
		       (&Debug ," "));
	    }

	    fputc('<',f);
	    fputs(p->addr,f);
	    fputc('>',f);
	    DPRINT(Debug,9,
		   (&Debug, "<%s>",p->addr));
	} else {
	    fputs(p->addr,f);
	    DPRINT(Debug,9,
		   (&Debug ,"%s",p->addr));
	}
	if (cm) {
	    char * buffer = string_to_hdr(HDR_COMMENT, p->comment,
					  hdr_charset, enmime);
	    char * c;
	    
	    DPRINT(Debug,9,
		   (&Debug,"\n          [%d] ",p-addr));

	    if (LEN > 85) {
		DPRINT(Debug,9,
		       (&Debug, "[WRAP]\n          [%d] ",p-addr));
		WRAP;
	    } else {
		fputc(' ',f);
		DPRINT(Debug,9,
		       (&Debug ," "));
	    }
	    
	    DPRINT(Debug,9,
		   (&Debug, "\n          {comment encoded=%s}",buffer));
	    DPRINT(Debug,9,
		   (&Debug, "\n          [%d] ",p-addr));

	    fputc('(',f);			
	    DPRINT(Debug,9,
		   (&Debug, "("));
	    for (c = buffer; *c != '\0'; c++) {
		if (*c == '\n' || 
		    (whitespace(*c) && (LEN > 100))) {
		    WRAP;
		    DPRINT(Debug,9,
			   (&Debug, "[WRAP]\n          [%d] ",
			    p-addr));
		} else {
		    fputc(*c,f);
		    DPRINT(Debug,9,
			   (&Debug, "%c",*c));
		}
	    }
	    fputc(')',f);			
	    DPRINT(Debug,9,
		   (&Debug, ")"));
	    free(buffer);
	}
    }
    print_EOLN(f,top_encoding);
    DPRINT(Debug,9,
	   (&Debug, "[EOLN]\n"));
}

int check_8bit_addr(addr)
     struct addr_item * addr;
{
    struct addr_item *p;
    for (p = addr; p && p->fullname && p->addr && p->comment; p++) {
	if (!can_ascii_string(p->fullname))
	    return TRUE;
	if (!can_ascii_string(p->comment))
	    return TRUE;
    }
    return FALSE;
}

void write_text_header (f,hdr_name,text, top_encoding)
     FILE *f;
     char *hdr_name; 
     char * text;
     int top_encoding;
{
    long POS = ftell(f);
    char *c;
    fputs(hdr_name,f);
    fputs(": ",f);

    DPRINT(Debug,9,
	   (&Debug,"write_text_header: %s:",hdr_name));
    
    for (c = text; *c != '\0'; c++) {
	if (*c == '\n' || 
	    (whitespace(*c) && (LEN > 75))) {
	    WRAP;
	    DPRINT(Debug,9,
		   (&Debug,"[WRAP]\n          "));
	} else {
	    fputc(*c,f);
	    DPRINT(Debug,9,
		   (&Debug,"%c",*c));
	}
    }
    print_EOLN(f,top_encoding);    
    DPRINT(Debug,9,
	   (&Debug,"[EOLN]\n"));
}

#undef LEN
#undef WRAP

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
