case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac


echo "Extracting shared_libs/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
# $Id: Makefile.SH,v 1.7 2001/05/01 09:47:56 hurtta Exp $
#
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
#
#
MAKE            =       $make

!GROK!THIS!

modules=''
insmods=''
rmmods=''
allmods=''
cleanmods=''
uninstallmods=''
for domake in $shared_list ; do
	varname="\$${domake}_ok"
	if eval $test "X$varname" = "Xdefine" ; then
		modules="$modules ../shlib/libelmme-${domake}.so"
		insmods="$insmods $shlib/libelmme-${domake}.so$d_shared_rev"
		allmods="$allmods all-${domake}"
		cleanmods="$cleanmods clean-${domake}"
		uninstallmods="$uninstallmods uninstall-${domake}"
	else
		rmmods="$rmmods $shlib/libelmme-${domake}.so$d_shared_rev"
	fi
done

$cat >>Makefile <<SUBSMODULES

all:			Makefile $modules $allmods
install:		Makefile $insmods remove_not_configured
clean:			$cleanmods
uninstall:		$uninstallmods remove_not_configured remove_installed
	
SUBSMODULES

if $test "$rmmods" != "" ; then
	$cat >>Makefile <<SUBSMODULES
remove_not_configured:
	rm -f $rmmods

SUBSMODULES
else
	$cat >>Makefile <<SUBSMODULES
remove_not_configured:

SUBSMODULES
fi

if $test "$insmods" != "" ; then
	$cat >>Makefile <<SUBSMODULES
remove_installed:
	rm -f $insmods

SUBSMODULES
else
	$cat >>Makefile <<SUBSMODULES
remove_installed:

SUBSMODULES
fi

$cat >>Makefile <<'!NO!SUBS!'

Makefile: Makefile.SH ../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

lint:		

tags:

!NO!SUBS!

for domake in $shared_list ; do
$cat >>Makefile <<SUBSMODULES

../shlib/libelmme-${domake}.so: $domake/lib${domake}.a
	cd ${domake}; \$(MAKE) \$(MJ) -\$(MAKEFLAGS) ../../shlib/libelmme-${domake}.so

$domake/lib${domake}.a all-${domake}: 
	cd ${domake}; \$(MAKE) \$(MJ) -\$(MAKEFLAGS) all

$shlib/libelmme-${domake}.so$d_shared_rev: ../shlib/libelmme-${domake}.so
	cd ${domake}; \$(MAKE) \$(MJ) -\$(MAKEFLAGS) install

clean-${domake}:
	cd ${domake}; \$(MAKE) \$(MJ) -\$(MAKEFLAGS) clean

SUBSMODULES

done


