static char rcsid[] = "@(#)$Id: unicode.c,v 1.11 2001/06/16 18:56:13 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.11 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#include "headers.h"
#include "s_me.h"
#include "cs_imp.h"
#include "unidata.h"

DEBUG_VAR(Debug,__FILE__,"charset");

/* NOTE:

              UOP_printable   returns 0 if caharacter is not known to be
                              printable

              UOP_noctrl      returns 0 if character is known to be
                              control character
*/

/* Returns 0 if char not OK, otherwise char or converted char */
uint16 unicode_ch(ch,op)
     unsigned int ch; 
     enum unicode_op op; 
{
    struct mapped_data * XX = default_unidata();
   
    if (XX) {
	static int flip = 0;

	if (!flip) {
	    flip = 1;
	    DPRINT(Debug,4,(&Debug,
			    "unicode_ch called -- got unidata\n"));
	}

	if (ch <= 0xFFFF) {
	    struct character_information info;
	    uint16 dummy[1];
	    int Y ;

	    /* bzero is defined on hdrs/defs.h */
	    bzero((void *)&info, sizeof info);

	    Y = unicode_lookup_character(XX,ch,&info,dummy,0);
	    
	    if (Y < 0)  {       /* database bad */
		DPRINT(Debug,61,(&Debug,
				 "unicode_ch: failed to look at %04X -- database bad\n",
				 ch));
		goto fail;
	    }
	    if (Y == 0) {       /* failure (not valid character) */
		DPRINT(Debug,61,(&Debug,
				 "unicode_ch: failed to look at %04X -- not a valid character\n",
				 ch));
		goto bad;
	    }

	switch(op) {
	case UOP_none: 
	    break;
	case UOP_lowercase:
	    if (info.lower)
		ch = info.lower;
	    break;
	case UOP_noctrl: 
	    
	    /* Other, Control          */
	    if (info.character_type == CHARTYPE_Cc)
		ch = 0;
	    
	    /* Other, Not Assigned     */
	    else if (info.character_type == CHARTYPE_Cn)
		ch = 0;

	case UOP_printable:

	    /* Number                  */
	    if (info.character_type & CHARTYPE_Number)
		break;

	    /* Separator, Space        */
	    else if (info.character_type == CHARTYPE_Zs)
		break;

	    /* Letter                  */
	    else if (info.character_type & CHARTYPE_Letter)
		break;

	    /* Punctuation             */
	    else if (info.character_type & CHARTYPE_Punctuation)
		break;

	    /* Symbol                  */
	    else if (info.character_type & CHARTYPE_Symbol)
		break;

	    else
		ch = 0;
	    break;
	}


	} else { /* Invalid character */

	bad:
	    switch(op) {
	    case UOP_printable:     /* Invalid character is not printable */
	    case UOP_noctrl:        /* Consider invalid character as control */
		ch = 0;
	    }
	}

    } else {
	static int flip = 0;

	if (!flip) {
	    flip = 1;
	    DPRINT(Debug,4,(&Debug,
			    "unicode_ch called -- no unidata\n"));
	}



    fail:

	switch(op) {
	case UOP_none: 
	    break;
	case UOP_lowercase:
	    if (ch >= 0x0041 && ch <= 0x005A)               /* ASCII range  */
		ch = ( ch - 0x0041) + 0x0061;
	    else if (ch >= 0x00C0 && ch <= 0x00D6)          /* LATIN1 range */
		ch = ( ch - 0x00C0) + 0x00E0;
	    else if (ch >= 0x00D8 && ch <= 0x00DE)          /* LATIN1 range */
		ch = ( ch - 0x00D8) + 0x00F8;
	    break;
	case UOP_noctrl: 
	    if (ch <= 0x001F)                              /* ASCII ctrl range */
		ch = 0;
	    else if (ch >= 0x007F && ch <= 0x009F)
		ch = 0;
	    break;
	case UOP_printable:
	    if (ch >= 0x0020 && ch <= 0x007E)              /* ASCII range */
		break;
	    else if (ch >= 0x00A0 && 0x00FF)               /* Latin1 range */
		break;
	    else
		ch = 0;                          /* Not known if printable */
	    break;
	}
    }

    return ch;
}


/* ---------------------------------------------------------------------- */

struct mapped_data * default_unidata()
{
    static struct mapped_data * res = NULL;

    if (0 != strcmp(unidata_path,"none") && !res) {	
	static int tried = 0;

	if (!tried) {
	    DPRINT(Debug,4,(&Debug,
			    "Loading UNIDATA information ... (file %s)\n",
			    unidata_path));
	    if (!get_unidata(&res,unidata_path)) {
		DPRINT(Debug,4,(&Debug,
				"... loading of UNIDATA information failed\n"));
	    }
	    tried = 1;
	}
    }
    return res;
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
