static char rcsid[] = "@(#)$Id: gcos_name.c,v 1.6 2000/06/14 15:40:27 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** 

**/

#include "headers.h"

char * gcos_name(gcos_field, logname)
     char *logname, *gcos_field;
{
    /** Return the full name found in a passwd file gcos field **/

#ifdef BERKNAMES

    static char fullname[SLEN];
    char *fncp, *gcoscp, *lncp, *end;
    int first;

    /* full name is all chars up to first ',' (or whole gcos, if no ',') */
    /* replace any & with logname in upper case */

    for(fncp = fullname, gcoscp= gcos_field, end = fullname + sizeof fullname - 1;
        (*gcoscp != ',' && *gcoscp != '\0' && fncp < end);
	gcoscp++) {

	if(*gcoscp == '&') {
	    first = 1;
	    for(lncp = logname; *lncp && fncp < end; fncp++, lncp++)
#ifdef ASCII_CTYPE
		if (!isascii(*lncp))
		    *fncp='?';
		else
#endif
		    if (first) {
			first = 0;
			*fncp = toupper(*lncp);				    
		    } else
			*fncp = *lncp;
	} else {
	    *fncp++ = *gcoscp;
	}
    }
    
    *fncp = '\0';
    return(fullname);
#else
#ifdef USGNAMES
    
    char *firstcp, *lastcp;

    /* The last character of the full name is the one preceding the first
     * '('. If there is no '(', then the full name ends at the end of the
     * gcos field.
     */
    if(lastcp = index(gcos_field, '('))
	*lastcp = '\0';

    /* The first character of the full name is the one following the 
     * last '-' before that ending character. NOTE: that's why we
     * establish the ending character first!
     * If there is no '-' before the ending character, then the fullname
     * begins at the beginning of the gcos field.
     */
    if(firstcp = rindex(gcos_field, '-'))
	firstcp++;
    else
	firstcp = gcos_field;

    return(firstcp);

#else
    /* use full gcos field */
    return(gcos_field);
#endif
#endif
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
