/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.10 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#define	MIME_HEADER	"MIME-Version: 1.0"
#define	MIME_INCLUDE	"[include"

/* Encoding types */

#define	ENCODING_ILLEGAL	-1
#define	ENCODING_NONE	0
#define	ENCODING_7BIT	1
#define	ENCODING_8BIT	2
#define	ENCODING_BINARY	3
#define	ENCODING_QUOTED	4
#define	ENCODING_BASE64	5
#define	ENCODING_EXPERIMENTAL	6

/* Default charsets, which are a superset of US-ASCII, so we do not
   have to go out to metamail for us-ascii */

#define COMPAT_CHARSETS "ISO-8859-1 ISO-8859-2 ISO-8859-3 ISO-8859-4 ISO-8859-5 ISO-8859-7 ISO-8859-8 ISO-8859-9 KOI8-R ISO-8859-15"

/* These are for figuring out what the encoding on outgoing messages should
 * be.
 */
#define HAVE_8BIT 1
#define HAVE_CTRL 4
#define HAVE_BINARY 8

/* Possible major types in Content-Type field. */
#define MIME_TYPE_UNKNOWN	0
#define MIME_TYPE_APPLICATION	1
#define MIME_TYPE_AUDIO		2
#define MIME_TYPE_IMAGE		3
#define MIME_TYPE_MESSAGE	4
#define MIME_TYPE_MULTIPART	5
#define MIME_TYPE_TEXT		6
#define MIME_TYPE_VIDEO		7

/* Values for the "flag" field in "mimeinfo" */
#define MIME_RFC822      1
#define MIME_MIXED       2
#define MIME_DIGEST      4
#define MIME_ALTERNATIVE 8
#define MIME_SIGNED      16
#define MIME_ENCRYPTED   32

/* Content-Disposition */
#define DISP_INLINE	0
#define DISP_ATTACH	1

#define DISPOSITION(x) (x == DISP_INLINE ? "inline" : "attachment")
#define TYPE(x) (mime_types[(x)])
#define NONULL(x) (x ? x : "")
#define ENCODING(x) (x >= 0 ? mime_encode_names[x] : "<ILLEGAL>")
extern char *mime_encode_names[]; /* defined in mime.c */

struct mime_send_part {
    /* Information for text parts */
    int               encoding_part ;
    char *            encoding_part_text;  /* [include ..] produces */

    int               type_part;
    char *            type_part_text;      /* [include ..] produces */
    char *            subtype_part;
    char *            type_opts_part;

    int               disposition;
    char *            disposition_opts;
    
    struct string   * description;

    int               is_text;
    int               save_it_on_copy;
    charset_t         result_charset; /* Charset of text after conversion */

    long             start_loc, end_loc;
};

enum mailer_capab {  mailer_7bit=0, mailer_8bit=1, mailer_binary=2 };

typedef struct mime_send {    /* Mime parameters for this mail */
    enum mailer_capab  raw_level;

    /* Information for multipart  */
    int encoding_top; /* Encoding for top multipart type.
		       * ENCODING_8BIT:   add content_transfer_encoding: 8bit
		       *                  pass -B8BITMIME to mailer
		       * ENCODING_BINARY: add content_transfer_encoding: binary
		       *                  pass -BBINARYMIME to mailer
		       */
    char mime_boundary[STRING];
    char * type_opts_top;

    charset_t    hdr_charset;   /* to what charset headers should be flagged */
    int          encode_hdr;

    int                      top_parts_count;
    struct mime_send_part  * top_parts;

    int msg_is_multipart;

    /* not actually _MIME_ information ... */
    long cl_offset;
    long cl_start;
    long cl_end;

} mime_send_t;


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
