/*
   ELF: a general ELF tool

   Author : Samy Al Bahra
   Website: http://www.kerneled.com
   E-mail : samy@kerneled.com

   License: GPL (read COPYING for details)
   Copyright 2002-2003 Samy Al Bahra
*/


#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <readline/readline.h>
#include <readline/history.h>

#include <sehdr.h>
#include <define.h>
#include <command.h>

int main(int argc, char *argv[]){
  struct elf32_ehdr *ehdr;
  char *input, *command, *file;
  unsigned int x;
  int c, finish;

  int a_flag, c_flag, d_flag, e_flag, f_flag, m_flag, n_flag, o_flag, p_flag,
      r_flag, s_flag, t_flag, i_flag, u_flag, v_flag, x_flag, z_flag, A_flag,
      X_flag, I_flag, H_flag=1, Q_flag;


  a_flag=c_flag=d_flag=e_flag=f_flag=m_flag=n_flag=o_flag=p_flag=r_flag=s_flag=t_flag=\
    i_flag=u_flag=v_flag=x_flag=z_flag=A_flag=X_flag=I_flag=Q_flag=0;

  finish = 0;
	 
  while ((c = getopt(argc, argv, "acdefimnoprstuvxzhAHIXQ")) != -1) {
    switch(c) {
    case 'a':
      a_flag = 1;
      finish = 1;
      break;
    case 'c':
      c_flag = 1;
      finish = 1;
      break;
    case 'd':
      d_flag = 1;
      finish = 1;
      break;
    case 'e':
      e_flag = 1;
      finish = 1;
      break;
    case 'f':
      f_flag = 1;
      finish = 1;
      break;
    case 'i':
      i_flag = 1;
      finish = 1;
      break;
    case 'm':
      m_flag = 1;
      finish = 1;
      break;
    case 'n':
      n_flag = 1;
      finish = 1;
      break;
    case 'o':
      o_flag = 1;
      finish = 1;
      break;
    case 'p':
      p_flag = 1;
      finish = 1;
      break;
    case 'r':
      r_flag = 1;
      finish = 1;
      break;
    case 's':
      s_flag = 1;
      finish = 1;
      break;
    case 't':
      t_flag = 1;
      finish = 1;
      break;
    case 'u':
      u_flag = 1;
      finish = 1;
      break;
    case 'v':
      v_flag = 1;
      finish = 1;
      break;
    case 'x':
      x_flag = 1;
      finish = 1;
      break;
    case 'z':
      z_flag = 1;
      finish = 1;
      break;
      
    case 'A':
      a_flag = c_flag = d_flag = e_flag = f_flag = m_flag = 1;
      n_flag = o_flag = p_flag = r_flag = s_flag = t_flag = 1;
      i_flag = u_flag = v_flag = x_flag = z_flag = 1;
      finish = 1;
      break;
      
    case 'h':
      usage();
      exit(EXIT_FAILURE);
      
    case 'H':
      H_flag = 1;
      X_flag = I_flag = 0;
      break;
    case 'I':
      I_flag = 1;
      H_flag = X_flag = 0;
      break;
    case 'Q':
      Q_flag += 1;
      break;
    case 'X':
      X_flag = 1;
      H_flag = I_flag = 0;
      break;
      
    default:
      usage();
      exit(EXIT_FAILURE);
    }
  }
  
  if(!Q_flag){
    printf("%s (%s): Written by %s\n", NAME, VERSION, AUTHOR);
    printf("Released under the terms of the %s\n", LICENSE);
    printf("Report bugs to %s\n\n", EMAIL);
  }
  
  if(a_flag || c_flag || d_flag || e_flag || f_flag || m_flag || n_flag || o_flag || p_flag || r_flag || s_flag || t_flag || i_flag || u_flag || v_flag || x_flag || z_flag || Q_flag){
    if (optind >= argc){
      usage();
      exit(EXIT_FAILURE);
    }
    if (!Q_flag)
      printf("Loading file %s...\n", argv[optind]);
    if(is_elf(argv[optind])){
      fprintf(stderr, "ERROR: selected file is not an ELF file\n");
      exit(EXIT_FAILURE);
    }
    else {
      ehdr=get_ehdr(argv[optind]);
      if(!ehdr){
	printf("File could not be loaded...\n");
	exit(EXIT_FAILURE);
      }
    }
  }
  if (a_flag) {
    if (Q_flag < 2)
      printf("Operating system ABI: ");
    if (H_flag)
      printf("%s\n", ehdr->se_abi);
    else if (X_flag)
      printf("0x%02x\n", ehdr->e_ident[EI_OSABI]);
    else if (I_flag)
      printf("%d\n", ehdr->e_ident[EI_OSABI]);
  }
  if (c_flag) {
    if (Q_flag < 2)
      printf("Class object sizes: ");
    if (H_flag)
      printf("%s\n", ehdr->se_class);
    else if (X_flag)
      printf("0x%02x\n", ehdr->e_ident[EI_CLASS]);
    else if (I_flag)
      printf("%d\n", ehdr->e_ident[EI_CLASS]);
  }
  if (d_flag) {
    if (Q_flag < 2)
      printf("Data encoding: ");
    if (H_flag)
      printf("%s\n", ehdr->se_data);
    else if (X_flag)
      printf("0x%02x\n", ehdr->e_ident[EI_DATA]);
    else if (I_flag)
      printf("%d\n", ehdr->e_ident[EI_DATA]);
  }
  if (e_flag) {
    if (Q_flag < 2)
      printf("Virtual entry point: ");
    if (H_flag)
      printf("%#x\n", ehdr->e_entry);
    else if (X_flag)
      printf("%#x\n", ehdr->e_entry);
    else if (I_flag)
      printf("%d\n", ehdr->e_entry);
  }
  if (f_flag) {
    if (Q_flag < 2)
      printf("Processor-specific flags: ");
    if (H_flag)
      printf("%#x\n", ehdr->e_flags);
    else if (X_flag)
      printf("%#x\n", ehdr->e_flags);
    else if (I_flag)
      printf("%d\n", ehdr->e_flags);
  }
  if (i_flag) {
    if (Q_flag < 2)
      printf("ELF identification: ");
    if (H_flag) {
      for(x=0;x<EI_NIDENT;x++) printf("%02x ", ehdr->e_ident[x]);
      printf("\n");
    }
    else if (X_flag) {
      for(x=0;x<EI_NIDENT;x++) printf("%02x ", ehdr->e_ident[x]);
      printf("\n");
    }
    else if (I_flag) {
      for(x=0;x<EI_NIDENT;x++) printf("%d ", ehdr->e_ident[x]);
      printf("\n");
    }
  }
  if (m_flag) {
    if (Q_flag < 2)
      printf("Object file architecture: ");
    if (H_flag)
      printf("%s\n", ehdr->se_machine);
    else if (X_flag)
      printf("%#x\n", ehdr->e_machine);
    else if (I_flag)
      printf("%d\n", ehdr->e_machine);
  }
  if (n_flag) {
    if (Q_flag < 2)
      printf("Program header entry count: ");
    if (H_flag)
      printf("%d\n", ehdr->e_phnum);
    else if (X_flag)
      printf("%#x\n", ehdr->e_phnum);
    else if (I_flag)
      printf("%d\n", ehdr->e_phnum);
  }
  if (o_flag) {
    if (Q_flag < 2)
      printf("Section header entry size: ");
    if (H_flag)
      printf("%d\n", ehdr->e_shentsize);
    else if (X_flag)
      printf("%#x\n", ehdr->e_shentsize);
    else if (I_flag)
      printf("%d\n", ehdr->e_shentsize);
  }
  if (p_flag) {
    if (Q_flag < 2)
      printf("Program header offset: ");
    if (H_flag)
      printf("%d\n", ehdr->e_phoff);
    else if (X_flag)
      printf("%#x\n", ehdr->e_phoff);
    else if (I_flag)
      printf("%d\n", ehdr->e_phoff);
  }
  if (r_flag) {
    if (Q_flag < 2)
      printf("ELF header size: ");
    if (H_flag)
      printf("%d\n", ehdr->e_ehsize);
    else if (X_flag)
      printf("%#x\n", ehdr->e_ehsize);
    else if (I_flag)
      printf("%d\n", ehdr->e_ehsize);
  }
  if (s_flag) {
    if (Q_flag < 2)
      printf("Section header offset: ");
    if (H_flag)
      printf("%d\n", ehdr->e_shoff);
    else if (X_flag)
      printf("%#x\n", ehdr->e_shoff);
    else if (I_flag)
      printf("%d\n", ehdr->e_shoff);
  }
  if (t_flag) {
    if (Q_flag < 2)
      printf("Object file type: ");
    if (H_flag)
      printf("%s\n", ehdr->se_type);
    else if (X_flag)
      printf("%#x\n", ehdr->e_type);
    else if (I_flag)
      printf("%d\n", ehdr->e_type);
  }
  if (u_flag) {
    if (Q_flag < 2)
      printf("Section header entry count: ");
    if (H_flag)
      printf("%d\n", ehdr->e_shnum);
    else if (X_flag)
      printf("%#x\n", ehdr->e_shnum);
    else if (I_flag)
      printf("%d\n", ehdr->e_shnum);
  }
  if (v_flag) {
    if (Q_flag < 2)
      printf("ELF version: ");
    if (H_flag)
      printf("%s\n", ehdr->se_version);
    else if (X_flag)
      printf("%#x\n", ehdr->e_version);
    else if (I_flag)
      printf("%d\n", ehdr->e_version);
  }
  if (x_flag) {
    if (Q_flag < 2)
      printf("Section header str index: ");
    if (H_flag)
      printf("%d\n", ehdr->e_shstrndx);
    else if (X_flag)
      printf("%#x\n", ehdr->e_shstrndx);
    else if (I_flag)
      printf("%d\n", ehdr->e_shstrndx);
  }
  if (z_flag) {
    if (Q_flag < 2)
      printf("Program header entry size: ");
    if (H_flag)
      printf("%d\n", ehdr->e_phentsize);
    else if (X_flag)
      printf("%#x\n", ehdr->e_phentsize);
    else if (I_flag)
      printf("%d\n", ehdr->e_phentsize);
  }
  
  if (finish)
    return 0;
  
  
  if(argc==1)
    file=(char *)NULL;
  else if(argc==2){
    printf("Loading file %s...\n", argv[1]);
    if(is_elf(argv[1])){
      fprintf(stderr, "ERROR: selected file is not an ELF file\n");
      file=(char *)NULL;
    }
    else{
      ehdr=get_ehdr(argv[1]);
      if(!ehdr){
	printf("File could not be loaded...\n");
	file=(char *)NULL;
      }
      else{
	printf("File loaded successfully...\n");
	file=argv[1];
      }
    }
  }
  else{
    usage();
    exit(EXIT_FAILURE);
  }
  
  signal(SIGINT, quit);
  
  /* You think this parser is hackish? Well, so do I
     Look at the bright side, it works...
  */
  
  initrl();    
  for(;;){
    input=readline(PS);
    if(input && *input){
      add_history(input);
      command=(char *)stripwhite(input);
      
      if(!strcasecmp(command, "quit")){
	free(input);
	return 0;
      }
      else if(!strcasecmp(command, "help")){
	printf("List of user commands:\n\n");
	printf("file    -- load a new file into the ELF header cache\n");
	printf("info    -- display various ELF header information\n");
	printf("refresh -- refresh ELF header cache\n");
	printf("---------------------------------------------------------------------------\n");
	printf("shell   -- execute a command in the shell, using this alone spawns a shell\n");
	printf("---------------------------------------------------------------------------\n");     
	printf("help    -- display this help\n");
	printf("quit    -- exit elf\n");
      }
      else if(!strcasecmp(command, "help file"))
	printf("[file]: load a new file to analyze with ELF, argument should be a file. Using with no arguments prints current file\n");
      else if(!strcasecmp(command, "help info")){
	printf("[info]: generic command to display various ELF header information\n");
	printf("   info all       -- show all ELF header information\n");
	printf("   info ident     -- show ELF header ident\n");
	printf("   info class     -- show class object sizes\n");
	printf("   info data      -- show data encoding\n");
	printf("   info abi       -- show ELF header operating system ABI\n");
	printf("   info type      -- show ELF object file type\n");
	printf("   info machine   -- show ELF object file machine information\n");
	printf("   info version   -- show ELF version of object file\n");
	printf("   info entry     -- show virtual entry point of ELF object file\n");
	printf("   info phoff     -- show program header offset\n");
	printf("   info shoff     -- show section header offset\n");
	printf("   info flags     -- show processor specific flags of object file\n");
	printf("   info ehsize    -- show ELF header size\n");
	printf("   info phentsize -- show program header entry size\n");
	printf("   info phnum     -- show number of program header entries\n");
	printf("   info shentsize -- show section header entry size\n");
	printf("   info shnum     -- show number of section header entries\n");
	printf("   info shstrndx  -- show section header string table index\n");
      }
      else if(!strcasecmp(command, "help refresh"))
	printf("[refresh]: refresh ELF header cache of current file\n");
      else if(!strcasecmp(command, "help shell"))
	printf("[shell]: execute a shell command, with no arguments, spawn a child shell\n");
      else if(!strcasecmp(command, "help help"))
	printf("[help]: display the help options\n");
      else if(!strcasecmp(command, "help quit"))
	printf("[quit]: exit elf\n");
      else if(!strncasecmp(command, "help ", 5) && (strlen(command)>5))
	fprintf(stderr, "Undefined command: \"%s\".  Try \"help\".\n", command+5);
      else if(!strcasecmp(command, "shell")) 
	system(getenv("SHELL"));
      else if(!strncasecmp(command, "shell ", 6) && (strlen(command)>6))
	system(command+6);
      else if(!strcasecmp(command, "refresh"))
	ehdr=get_ehdr(argv[1]);
      else if(!strcasecmp(command, "info"))
	fprintf(stderr, "Missing fields.  Please use \"help info\".\n");
      else if(!strcasecmp(command, "file")){
	if(!file)
	  printf("No object file is loaded.\n");
	else
	  printf("The file \"%s\" is loaded.\n", file);
      }
      else if(!strncasecmp(command, "file ", 5) && (strlen(command)>5)){
	if(file) free(file);
	file=strdup(command+5);
	printf("Loading file %s...\n", file);
	ehdr=get_ehdr(file);
	if(!ehdr){
	  printf("File could not be loaded...\n");
	  file=(char *)NULL;
	}
	else printf("File loaded successfully...\n");
      }
      else if(!file){
	fprintf(stderr, "No object file is loaded.  Please use the \"file\" command to load one.\n");
	continue;
      }
      else if(!strcasecmp(command, "info all")){
	printf("ELF identification ---------| ");
	for(x=0;x<EI_NIDENT;x++) printf("%02x ", ehdr->e_ident[x]);
	printf("\n");
	printf("Class object sizes ----------> %s\n", ehdr->se_class);
	printf("Data encoding ---------------> %s\n", ehdr->se_data);
	printf("Operating system ABI --------> %s\n", ehdr->se_abi);
	printf("Object file type -----------| %s\n", ehdr->se_type);
	printf("Object file architecture ---| %s\n", ehdr->se_machine);
	printf("ELF version ----------------| %s\n", ehdr->se_version);
	printf("Virtual entry point --------| %#x\n", ehdr->e_entry);
	printf("Program header offset ------| %d (bytes into file)\n", ehdr->e_phoff);
	printf("Section header offset ------| %d (bytes into file)\n", ehdr->e_shoff);
	printf("Processor-specific flags ---| %#x\n", ehdr->e_flags);
	printf("ELF header size ------------| %d (bytes)\n", ehdr->e_ehsize);
	printf("Program header entry size --| %d (bytes)\n", ehdr->e_phentsize);
	printf("Program header entry count -| %d\n", ehdr->e_phnum);
	printf("Section header entry size --| %d (bytes)\n", ehdr->e_shentsize);
	printf("Section header entry count -| %d\n", ehdr->e_shnum);
	printf("Section header str index ---| %d\n", ehdr->e_shstrndx);
      }
      else if(!strcasecmp(command, "info ident") || !strcasecmp(command, "info hex ident") || !strcasecmp(command, "info hum ident")){
	for(x=0;x<EI_NIDENT;x++) printf("%02x ", ehdr->e_ident[x]);
	printf("\n");
      }
      else if(!strcasecmp(command, "info int ident")){
	for(x=0;x<EI_NIDENT;x++) printf("%d ", ehdr->e_ident[x]);
	printf("\n");
      }
      else if(!strcasecmp(command, "info class") || !strcasecmp(command, "info hum class"))
	printf("%s\n", ehdr->se_class);
      else if(!strcasecmp(command, "info int class"))
	printf("%d\n", ehdr->e_ident[EI_CLASS]);
      else if(!strcasecmp(command, "info hex class"))
	printf("0x%02x\n", ehdr->e_ident[EI_CLASS]);
      else if(!strcasecmp(command, "info data") || !strcasecmp(command, "info hum data"))
	printf("%s\n", ehdr->se_data);
      else if(!strcasecmp(command, "info int data"))
	printf("%d\n", ehdr->e_ident[EI_DATA]);
      else if(!strcasecmp(command, "info hex data"))
	printf("0x%02x\n", ehdr->e_ident[EI_DATA]);
      else if(!strcasecmp(command, "info abi") || !strcasecmp(command, "info hum abi"))
	printf("%s\n", ehdr->se_abi);
      else if(!strcasecmp(command, "info int abi"))
	printf("%d\n", ehdr->e_ident[EI_OSABI]);
      else if(!strcasecmp(command, "info hex abi"))
	printf("0x%02x\n", ehdr->e_ident[EI_OSABI]);
      else if(!strcasecmp(command, "info type") || !strcasecmp(command, "info hum type"))
	printf("%s\n", ehdr->se_type);
      else if(!strcasecmp(command, "info int type"))
	printf("%d\n", ehdr->e_type);
      else if(!strcasecmp(command, "info hex type"))
	printf("%#x\n", ehdr->e_type);
      else if(!strcasecmp(command, "info machine") || !strcasecmp(command, "info hum machine"))
	printf("%s\n", ehdr->se_machine);
      else if(!strcasecmp(command, "info int machine"))
	printf("%d\n", ehdr->e_machine);
      else if(!strcasecmp(command, "info hex machine"))
	printf("%#x\n", ehdr->e_machine);
      else if(!strcasecmp(command, "info version") || !strcasecmp(command, "info hum version"))
	printf("%s\n", ehdr->se_version);
      else if(!strcasecmp(command, "info int version"))
	printf("%d\n", ehdr->e_version);
      else if(!strcasecmp(command, "info hex version"))
	printf("%#x\n", ehdr->e_version);
      else if(!strcasecmp(command, "info entry") || !strcasecmp(command, "info hum entry") || !strcasecmp(command, "info hex entry"))
	printf("%#x\n", ehdr->e_entry);
      else if(!strcasecmp(command, "info int entry"))
	printf("%d\n", ehdr->e_entry);
      else if(!strcasecmp(command, "info phoff") || !strcasecmp(command, "info int phoff") || !strcasecmp(command, "info hum phoff"))
	printf("%d\n", ehdr->e_phoff);
      else if(!strcasecmp(command, "info hex phoff"))
	printf("%#x\n", ehdr->e_phoff);
      else if(!strcasecmp(command, "info shoff") || !strcasecmp(command, "info int shoff") || !strcasecmp(command, "info hum shoff"))
	printf("%d\n", ehdr->e_shoff);
      else if(!strcasecmp(command, "info hex shoff"))
	printf("%#x\n", ehdr->e_shoff);
      else if(!strcasecmp(command, "info flags") || !strcasecmp(command, "info hex flags") || !strcasecmp(command, "info hum flags"))
	printf("%#x\n", ehdr->e_flags);
      else if(!strcasecmp(command, "info int flags"))
	printf("%d\n", ehdr->e_flags);
      else if(!strcasecmp(command, "info ehsize") || !strcasecmp(command, "info int ehsize") || !strcasecmp(command, "info hum ehsize"))
	printf("%d\n", ehdr->e_ehsize);
      else if(!strcasecmp(command, "info hex ehsize"))
	printf("%#x\n", ehdr->e_ehsize);
      else if(!strcasecmp(command, "info phentsize") || !strcasecmp(command, "info int phentsize") || !strcasecmp(command, "info hum phentsize"))
	printf("%d\n", ehdr->e_phentsize);
      else if(!strcasecmp(command, "info hex phentsize"))
	printf("%#x\n", ehdr->e_phentsize);
      else if(!strcasecmp(command, "info phnum") || !strcasecmp(command, "info int phnum") || !strcasecmp(command, "info hum phnum"))
	printf("%d\n", ehdr->e_phnum);
      else if(!strcasecmp(command, "info hex phnum"))
	printf("%#x\n", ehdr->e_phnum);
      else if(!strcasecmp(command, "info shentsize") || !strcasecmp(command, "info int shentsize") || !strcasecmp(command, "info hum shentsize"))
	printf("%d\n", ehdr->e_shentsize);
      else if(!strcasecmp(command, "info hex shentsize"))
	printf("%#x\n", ehdr->e_shentsize);
      else if(!strcasecmp(command, "info shnum") || !strcasecmp(command, "info int shnum") || !strcasecmp(command, "info hum shnum"))
	printf("%d\n", ehdr->e_shnum);
      else if(!strcasecmp(command, "info hex shnum"))
	printf("%#x\n", ehdr->e_shnum);
      else if(!strcasecmp(command, "info shstrndx") || !strcasecmp(command, "info int shstrndx") || !strcasecmp(command, "info hum shstrndx"))
	printf("%d\n", ehdr->e_shstrndx);
      else if(!strcasecmp(command, "info hex shstrndx"))
	printf("%#x\n", ehdr->e_shstrndx);
      else if(!strncasecmp(command, "info ", 5) && strlen(command)>5)
	fprintf(stderr, "Undefined field: \"%s\".  Try \"help info\".\n", command+5);
      else
	fprintf(stderr, "Undefined command: \"%s\".  Try \"help\".\n", command);
      free(input);
    }
    else{
      putchar('\n');
      exit(EXIT_FAILURE);
    }
  }
}


char **find_command(char *name){
  register int i;
  
  for(i=0;commands[i];i+=2)
    if(!strcmp(name, commands[i]))
      return (&commands[i]);
  return (char **)NULL;
}


void initrl(void){
  rl_attempted_completion_function=(CPPFunction *)completion;
}


char **completion(char *text, int start, int end){
  char **matches=(char **)NULL;
  
  if(!start) matches=(char **)completion_matches(text, match);
  return matches;
}

char *match(char *text, int state){
  static int i, len;
  
  if(!state){
    i=0;
    len=strlen(text);
  }
  
  while(commands[i+=2]){
    if(!strncmp(commands[i], text, len)) 
      return(strdup(commands[i]));
  }
  
  return (char *)NULL;
}

static void *stripwhite(char *input){
  static char command[100];
  register int space=0;
  int x, y;
  
  bzero(command, sizeof(command));
  
  for(x=0, y=0;input[x]!=0, y<sizeof(command);x++, y++){
    if(input[x]==' '){
      while(input[++x]==' ');
      if(space) command[y++]=' ';
      command[y]=input[x];
    }
    else{
      command[y]=input[x];
      space=1;
    }
  }
  if(command[strlen(command)-1]==' ') command[strlen(command)-1]='\0';
  return (char *)command;
}


static void quit(int sig){
  printf("Quit\n%s", PS);
}

static void usage(void){
  fprintf(stderr, "Usage: elf -[acdefmnoprstiuvxzAXIHQ] [file]\n\n");
}


