/* Header for module pastrix, generated by p2c */

#ifndef PASTRIX_H
#define PASTRIX_H


/* following headers are taken from: (note: it is only a small subset
 * of the original file) */

/* Header file for code generated by "p2c", the Pascal-to-C translator */

/* "p2c"  Copyright (C) 1989, 1990, 1991 Free Software Foundation.
 * By Dave Gillespie, daveg@csvax.cs.caltech.edu.  Version 1.20.
 * This file may be copied, modified, etc. in any way.  It is not restricted
 * by the licence agreement accompanying p2c itself.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/* The following definitions work only on twos-complement machines */
#ifndef SHORT_MAX
# define SHORT_MAX  ((short)(((unsigned short) -1) >> 1))
# define SHORT_MIN  (~SHORT_MAX)
#endif

#ifndef __NetBSD__
#ifndef INT_MAX
# define INT_MAX    ((int)(((unsigned int) -1) >> 1))
# define INT_MIN    (~INT_MAX)
#endif

#ifndef LONG_MAX
# define LONG_MAX   ((long)(((unsigned long) -1) >> 1))
# define LONG_MIN   (~LONG_MAX)
#endif
#endif

#ifndef SEEK_SET
# define SEEK_SET   0
# define SEEK_CUR   1
# define SEEK_END   2
#endif

#define maxlonginteger LONG_MAX

#ifndef boolean
  typedef unsigned char boolean;
#endif

#ifndef true
# define true    1
# define false   0
#endif

#ifndef TRUE
# define TRUE    1
# define FALSE   0
#endif

/* end of needed p2c.h definitions */


#define TICKSPERSEC	200	/* the 200 Hz counter */

#include "filesys.h" /* includes localised file system access for dpbox */

#define tab             '\t'

#ifdef __macos__
#include <time.h>
#else
#include <sys/time.h>
#endif

#if defined(__linux__) || defined(__NetBSD__)
#include <signal.h>
#define DP_SIGHUP SIGHUP
#define DP_SIGTSTP SIGTSTP
#define DP_SIGTTIN SIGTTIN
#define DP_SIGTTOU SIGTTOU
#define DP_SIGPIPE SIGPIPE
#define DP_SIGKILL SIGKILL
#define DP_SIGTERM SIGTERM
#define DP_SIGSEGV SIGSEGV
#include <sys/wait.h>
#define DP_WNOHANG WNOHANG
#endif

#ifdef __macos__
#include <signal.h>
#define DP_SIGHUP SIGABRT
#define DP_SIGTSTP 1
#define DP_SIGTTIN 2
#define DP_SIGTTOU 3
#define DP_SIGPIPE 4
#define DP_SIGKILL 5
#define DP_SIGTERM SIGTERM
#define DP_SIGSEGV SIGABRT
#define DP_WNOHANG 6
#endif

extern short dp_randomize(short low, short hiw);
extern long searchbyte(char what, char *start, long size);
extern long maxavail__(void);
extern void RESETA(void);
extern void RESTART(void);
extern void WATCHDOG(short mode, short timer);
extern void VBLTIMER(short mode);
extern long GETVBLTIMER(void);
extern void NOCRITIC(boolean on);
extern char RAM_INIT(unsigned short size);
extern void RAM_EXIT(void);
extern void klang(short nr);
extern long statclock(void);
extern void mtpause(void);

#ifdef __macos__
extern int fork();
extern int kill(pid_t pid, int signal);
extern void setsid();
extern int waitpid(pid_t pid, int *res, int flag);
#endif

extern char *mymemmem(register char *haystack, register long haystacksize,
      	      	      register char *needle, register long needlesize);
extern char *strsub(register char *ret, register char *s, register int pos, register int len);
extern int strpos2(char *s, register char *pat, register int pos);
extern void strdelete(register char *s, register int pos, register int len);
extern void strinsert(register char *src, register char *dst, register int pos);
extern void del_allblanks(register char *s);
extern void del_leadblanks(char *s);
extern void del_lastblanks(char *s);
extern void lspacing(char *txt, short l);
extern void rspacing(char *txt, short l);
extern char upcase_(char ch);
extern char lowcase(char ch);
extern void upper(char *s);
extern void lower(char *s);
extern void strcpyupper(char *outs, char *ins);
extern void strcpylower(char *outs, char *ins);
extern boolean zahl(char *s);
extern boolean azahl(char *s);
extern boolean rzahl(char *s);
extern long hatoi(char *s);
extern long batoi(char *s);
extern void int2hstr(long i, char *s);
extern void int2hchar(short i, char *c1, char *c2);
extern void hstr2str(char *h, char *s);
extern void str2hstr(char *s, char *h);
extern void del_mulblanks(char *s);
extern short count_words(char *s);
extern void get_quoted(register char *inp, register char *outp);
extern void get_pquoted(register char **inp, register char *outp);
extern void get_word(char *inp, register char *outp);
extern void get_pword(char **inp, register char *outp);
extern char *del_comment(char *z, char c);
extern void get_lline(char *buf, long *posi, long ende, char *zeile, short maxlen);
#define get_line(a, b, c, d) get_lline(a, b, c, d, 255)
extern void next_line(char *buf, long *posi, long ende);
extern void prev_line(char *buf, long *posi);
extern void put_line(char *buf, long *posi, const char *zeile);
extern void umlaut1(char *txt);
extern void umlaut2(char *txt);
extern void ersetze(char *oldstr, char *newstr, char *txt);
extern void gkdeutsch(char *name);
extern void sfbread(boolean aslongaspossible, char *name, char **puffer, long *size);

#define cut(string, size) string[size] = '\0'
#define nstrcpy(a, b, n) if (strncpy(a, b, n) != NULL) a[n] = '\0'
#define nstrcat(a, b, n) if (strncat(a, b, n) != NULL) a[n] = '\0'
#define maxram() 0x7fffffffL
#ifdef __macos__
extern long memavail__(void);
#else
#define memavail__() 8000000L
#define maxavail__() 8000000L
#endif
#define move_b(quelle, ziel, size) memmove(ziel, quelle, size)

#if defined(__linux__) || defined(__NetBSD__)
extern long get_cpuusage(void);
extern long get_memusage(void);
#else
#define get_cpuusage() statclock()
#define get_memusage() 0
#endif

#endif

