#ifndef SERIAL_H
#define SERIAL_H
/*
  Prototypes for PC/SHARC serial communications functions

  (C) 1998 PinPoint Corporation
  This software is available for unlimited personal use and may only
  be redistributed in unmodified form.  Above all, this notice may
  not be modified or removed.
  Contact tim.wall@pinpointco.com for commercial use
  */
typedef enum { BaudNone,Baud300,Baud1200,Baud2400,Baud4800,Baud9600,
               Baud19200,Baud38400,Baud57600,Baud115200 } baud_t;

/* always check for DSPReady() before issuing a DSP command 
   otherwise, if the DSP has a long heartbeat, the command may
   time out */
/* default to 5 second before DSP times out on a send/receive pair */
#define DEFAULT_TIMEOUT 5.0 

extern int DSPInUse (void);
extern int DSPInit (int port, baud_t speed, int verbose, float timeout);
extern void DSPSync (void);
extern void DSPClose (void);
extern int DSPVerify (char *, unsigned short, int);
extern int DSPRead (unsigned long addr, unsigned long *buf, int len);
extern void DSPWrite (unsigned long addr, unsigned long *data, int len);
extern void DSPSpeed (baud_t baud_code);
extern void DSPWrite48 (unsigned long addr, unsigned char *data, int len);
extern void DSPRead48 (unsigned long addr, unsigned char *buf, int len);
extern void DSPRun (void);
extern void DSPResetCPU (void);
extern void DSPDebug (int level);
extern int DSPReady (void);

#endif // SERIAL_H
