#ifndef HOST_H
#define HOST_H

/*
   host services designed to replace those in libdh.a, since those are rather
   flakey.
 */

#include <stdio.h>

#define HAS_HOST_SERVICES       0
#define USE_RTSCTS              1

#undef main
#undef printf
#undef kbhit
#undef getch

#define exit dh_exit                /* some dh functions we use */
#define sprintf dh_sprintf
#define printf dh_printf
#define kbhit dh_kbhit
#define getch dh_getch

/* host services */
#define MSG_NONE  0x0
#define MSG_PRINT 0x1
#define MSG_EXIT  0x2

extern int getch (void);
extern int kbhit (void);
extern void prints (char *);
extern void exit (int);

extern void delay (int usecs);
extern void alive (void);
extern void stack_test_init (void);
extern void stack_check (void);

extern unsigned long led_period;

#define set_led(state) \
do { if (state) asm ("bit clr astat FLG2;"); \
    else asm ("bit set astat FLG2;"); } while(0)

#define set_led0(state) \
do { if (state) asm ("bit clr astat FLG3;"); \
    else asm ("bit set astat FLG3;"); } while(0)

/* Somewhere in your init, set _mcr to point to the UART register base + 4 */
/* The UART register base can be calculated as follows.
   MSIZE is the MSIZE value written to SYSCON (0x0 - 0xF)

   unsigned MS0_BASE = 0x400000ul;
   unsigned MS1_BASE = MS0_BASE + (0x2000ul << MSIZE);
   volatile unsigned _mcr = (unsigned *)MS1_BASE + 4;
   */   
#ifdef USE_RTSCTS
extern volatile unsigned *_mcr;
#define set_RTS() (*_mcr = 2)
#define clear_RTS() (*_mcr = 0)
#else
#define set_RTS()
#define clear_RTS()
#endif

#endif /* HOST_H */
