/* coff routines -- upload a file to the dsp, look up symbols, etc 

  (C) 1998 PinPoint Corporation
  This software is available for unlimited personal use and may only
  be redistributed in unmodified form.  Above all, this notice may
  not be modified or removed.
  Contact tim.wall@pinpointco.com for commercial use

 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "coff21k.h"
#include "serial.h"

unsigned long sym_lookup (FILE *fp, char *sym);
int upload (FILE *fp, int baud, int verbose);

#if 0
int
main (int argc, char *argv[])
{
    FILE *fp = fopen (argv[1], "rb");
    if (!sym_lookup (fp, argv[2]))
        fprintf (stderr, "%s not found\n", argv[2]);
    fclose (fp);
    exit (0);
}
#endif

int
upload (FILE *fp, int baud, int verbose)
{    
    unsigned long sect_start ;
    int nsects;
    int sect;
    struct filehdr fhdr;
    SCNHDR shdr;
    int pm;
    int text;
    char name[SEC_NAME_LEN+1];
	int word;

    if (verbose)
    { printf ("Uploading file to DSP...");fflush (stdout); }

    DSPInit (1, baud, verbose, DEFAULT_TIMEOUT);
    /* stop any program which might be running */
    DSPResetCPU ();
    DSPSync ();
    
    /* parse the file and section headers */
#define MAXBUF 1024
    fseek (fp, 0L, SEEK_SET);
    fread ((char *)&fhdr, sizeof (fhdr), 1, fp);

    /* skip the optional header, if any */
    if (fhdr.f_opthdr != 0)
        fseek (fp, fhdr.f_opthdr, SEEK_CUR);
    sect_start = ftell (fp);
    nsects = fhdr.f_nscns;
    
    for (sect=0;sect < nsects;sect++)
    {
        long total = 0;
        unsigned long addr;

        fseek (fp, sect_start + sect*sizeof(shdr), SEEK_SET);
        fread ((char *)&shdr, sizeof(shdr), 1, fp);
        
        if (shdr.s_size == 0)
            continue;

        pm = (shdr.s_flags & 0x1); 
        text = (shdr.s_flags & 0x80);
        sprintf (name, "%s", shdr.s_name);
        name[SEC_NAME_LEN] = 0;
        if (verbose)
        {
            printf ("Section %8s @ 0x%lx, len %#6lx (%s)...",
                    name, shdr.s_paddr, shdr.s_size, 
                    pm ? "PM" : "DM");
            fflush (stdout);
        }
                
/* MAXCHUNK must be divisible by 30 (5 and 6) and less than 0x10000 (32k) */
#define MAXCHUNK (1024*30)
                
        addr = shdr.s_paddr;
        while (total < shdr.s_size)
        {
            long chunksize = ((shdr.s_size - total < MAXCHUNK) ?
                              (shdr.s_size - total) : MAXCHUNK);
            unsigned char *buf = (unsigned char *)malloc (chunksize);
            if (!buf)
            {
                fprintf (stderr, "Can't allocate %ld bytes\n", chunksize);
                DSPClose ();
                return -1;
            }
        
            /* seek to beginning of section data */
            fseek (fp, shdr.s_scnptr + total, SEEK_SET);
            fread (buf, 1, chunksize, fp);
            
            /* upload to the DSP */
            if (text)
            {
                int nwords = chunksize / 6;

                /* reverse the byte ordering */
                for (word=0;word < nwords;word++)
                {
                    /* swap first four */
                    unsigned char tmp1 = buf[word*6];
                    unsigned char tmp2 = buf[word*6+1];
                    unsigned char tmp3;
                    buf[word*6] = buf[word*6+3];
                    buf[word*6+1] = buf[word*6+2];
                    buf[word*6+3] = tmp1;
                    buf[word*6+2] = tmp2;
                    /* swap next two */
                    tmp3 = buf[word*6+4];
                    buf[word*6+4] = buf[word*6+5];
                    buf[word*6+5] = tmp3;
                }
                DSPWrite48 (addr, (unsigned char *)buf, nwords);
                total += chunksize;
                addr += nwords;
            }
            else
            {
                /* eliminate empty bytes: PM uses 6 bytes, DM uses 5 bytes */
                int divisor = (pm ? 6 : 5);
                int nwords = chunksize/divisor;
                int byte;
                
                for (word=0;word < nwords;word++)
                    for (byte=0;byte < 4;byte++)
                        buf[word*4+byte] = buf[word*divisor+byte];
                
                /* reverse the byte ordering */
                for (word=0;word < nwords;word++)
                {
                    unsigned char tmp1 = buf[word*4];
                    unsigned char tmp2 = buf[word*4+1];
                    buf[word*4] = buf[word*4+3];
                    buf[word*4+1] = buf[word*4+2];
                    buf[word*4+2] = tmp2;
                    buf[word*4+3] = tmp1;
                }
                DSPWrite (addr, (unsigned long *)buf, nwords);
                total += chunksize;
                addr += nwords;

            }

            free (buf);

        }
        if (verbose)
            printf ("done\n");
    }

    DSPRun ();
    DSPClose ();

    return 0;
}

unsigned long
sym_lookup (FILE *fp, char *sym)
{
    struct filehdr fhdr;
    unsigned long symtab_size;
    SYMTBL *symtable;
    unsigned long addr = 0;
    long length, i;
    char namestr[256];

    fseek (fp, 0L, SEEK_END);
    length = ftell (fp);
    fseek (fp, 0L, SEEK_SET);
    fread ((char *)&fhdr, sizeof (fhdr), 1, fp);

    /* skip the optional header, if any */
    if (fhdr.f_opthdr != 0)
        fseek (fp, fhdr.f_opthdr, SEEK_CUR);

    /* parse the symbol table for the requested symbol */
    symtab_size = length - fhdr.f_symptr;
    symtable = (SYMTBL *)malloc (symtab_size);
    fseek (fp, fhdr.f_symptr, SEEK_SET);
    fread (symtable, symtab_size, 1, fp);

    for (i=0;i<fhdr.f_nsyms;i++)
    {
        SYMTBL entry;
        memcpy ((char *)&entry, (char *)symtable + i * SYMESZ, SYMESZ);

        /* see if name is in the stringtable */
        if (entry.n_name[0] == 0)
        {
            sprintf (namestr, "%s",
                     (char *)symtable + fhdr.f_nsyms*SYMESZ + entry.n_offset);
        }
        else
        {
            strncpy (namestr, entry.n_name, 8);
            namestr[8] = 0;
        }

        if (strcmp (sym, namestr) == 0)
        {
            addr = entry.n_value;
            break;
        }
        if (entry.n_numaux)
            i += entry.n_numaux;
    }

    return addr;
}

