/***********************************************************
        Copyright 1991, 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/




#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: math.c,v 1.5 1994/08/13 01:55:26 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "Error.h"



long StringToNumber(string, base)
     char *string;
     int base;
{
  long number;

  if (string == NULL)
    {
      FatalError(E_BADSTRING,
		 "Attempt to convert NULL string to a number.\n");
    }

  if (PROGRAM_ErrorNo == E_NULL)
    {
      errno = 0;
      number = strtol(string, NULL, base);
      if (errno != 0)
	{
	  FatalError(E_BADSTRING,
		     "Unable to convert string %s to a  number.\n", string);
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? number : -1;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/util/RCS/math.c,v $ */
