/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef _DEPOT_ERROR_H
#define _DEPOT_ERROR_H

/* $Id: Error.h,v 1.7 1995/02/09 18:15:59 ww0r Exp $
 * 
 * Author: Sohan C. Ramakrishna Pillai
 */

#define E_NULL		0

/* generic errors */
#define E_USAGE		1
#define E_BADPATHNAME	2
#define E_BADRANGE	3
#define E_COMPRESSFAILED	4
#define E_DECOMPRESSFAILED	5

/* Util errors */
#define E_OUTOFMEMORY		51
#define E_BADSTRING		52
#define E_BADSTRINGARRAY	53
#define E_BADSTRINGSET		54
#define E_FGETUNSIGNEDFAILED	55
#define E_FGETLONGFAILED	56
#define E_FGETSTRINGFAILED	57
#define E_BADUSERNAME		58
#define E_BADGROUPNAME		59

/* syscall errors */
#define E_LSEEKFAILED	101
#define E_CHOWNFAILED	102
#define E_CHMODFAILED	103
#define E_UTIMEFAILED	104
#define E_UTIMESFAILED	104
#define E_STATFAILED	105
#define E_FSEEKFAILED   106

#define E_OPENFAILED	110
#define E_FOPENFAILED	111
#define E_READFAILED	112
#define E_WRITEFAILED	113
#define E_COPYFAILED	114
#define E_RENAMEFAILED	115
#define E_MKDIRFAILED	116
#define E_LINKFAILED	117
#define E_SYMLINKFAILED	118
#define E_UNLINKFAILED	119
#define E_READLINKFAILED 120
#define E_OPENDIRFAILED 121
#define E_RMDIRFAILED	122
#define E_CHDIRFAILED	123
#define E_VFORKFAILED	124
#define E_FORKFAILED	125
#define E_FDOPENFAILED	126
#define E_PIPEFAILED	127
#define E_WAITPIDFAILED 128
#define E_CLOSEFAILED   129
#define E_DUPFAILED     130

/* Lock module errors */
#define E_CANTLOCK	201
#define E_BADLOCKFILE	202
#define E_BADUSER	204
#define E_NOLOCK	205
#define E_FOOLPROOFLOCK	206

/* FileOps module errors */
#define E_GETSTATUSFAILED	251
#define E_SETSTATUSFAILED	252
#define E_RMPATHFAILED		253

/* FileSystemImage module errors */
#define E_BADFILESYSTEMIMAGE	301
#define E_GETFSIDFAILED		302
#define E_BADIMAGEPATHNAME	303
#define E_FSIMAGELOCATEFAILED	304

/* Hint module errors */
#define E_NULLHINT	351
#define E_NULLHINTDB	352
#define E_BADHINTDB	353
#define E_BADHINTNAME	354
#define E_BADHINTID	355
#define E_HINTWRITEFAILED	356
#define E_BADHINTPATHPREFIX	357

/* HintService module errors */
#define E_PATHLESSHINT	376
#define E_BADHINTS	377

/* Preference module errors */
#define E_PREFERENCEPARSE	401
#define E_PREFWRITEFAILED	402
#define E_BADPREFERENCEDB	403
#define E_NULLPREFERENCEDB	404
#define E_BADPREFERENCE		405
#define E_NULLPREFERENCE	406
#define E_UNKNOWNPREFERENCE	407
#define E_PREFSETFAILED		408
#define E_PREFGETFAILED		409
#define E_BADPREFID		410
#define E_BADPREFTYPE		411
#define E_BADPREFNAME		412
#define E_BADPREFVALUE		413

/* DepotConf module errors */
#define E_DEPOTCONFPARSE	451
#define E_COLLDEPOTCONFPARSE	452
#define E_GLBLDEPOTCONFPARSE	453
#define E_BADDEPOTCONFSPECNAME	454
#define E_BADDEPOTCONFSPEC	455
#define E_BADDEPOTCONFVALUE	456
#define E_BADDEPOTCONFCOMMAND	457
#define E_BADDEPOTCONFDB	458
#define E_NULLDEPOTCONFDB	459

/* TargetDB module errors */
#define E_TARGETDBVERSION	500
#define E_NULLTARGETDB		501
#define E_TARGETDBREADFAILED	502
#define E_TARGETDBWRITEFAILED	503
#define E_BADTARGETDBFILE	504
#define E_BADTARGETNAME		505
#define E_BADTARGETSOURCE	506
#define E_BADTARGETSOURCELIST	507
#define E_BADTARGETSOURCEPATH	508
#define E_BADTARGETPATH		509
#define E_BADTARGETDBCHILDNAME	510
#define E_BADTARGETFILESTATUS	511
#define E_NOSUCHTARGETDBCHILD	512
#define E_BADTARGETDBCHILDINDEX	513
#define E_TARGETSOURCECONFLICT	514
#define E_TARGETUIDCONFLICT	515
#define E_TARGETGIDCONFLICT	516
#define E_MODEMASKCONFLICT	517
#define E_BADSOURCEUPDTSPEC	518
#define E_BADTARGETUPDTSPEC	519
#define E_SPECIALVIOLATION	520
#define E_BADHARDLINKSOURCE	521

/* Collection module errors */
/* #define E_COLLECTIONPLACEHOLDER	601 - Unused! */
#define E_NULLCOLLECTION	602
#define E_BADCOLLECTION		603
#define E_NODEPOTCONFSPEC	604
#define E_NULLTARGET		605
#define E_BADTARGET		606
#define E_NULLSOURCE		607
#define E_BADFILESTATUSINFO	608
#define E_BADFSIMAGETYPE	609
#define E_BADFSIMAGENODE	610
#define E_BADFILESTATUSTYPE	611
#define E_BADCOMMANDTARGET	612

#define E_NULLSEARCHPATH	640
#define E_FREECOLLECTION	641

/* CollectionList module errors */
#define E_NULLCOLLECTIONLIST	651
#define E_BADCOLLECTIONLIST	652
#define E_BADCOLLECTIONID	653
#define E_NULLCOLLECTIONNAME	654

/* DepotDB module errors */
#define E_NULLDEPOTDB		701
#define E_DEPOTDBOPENFAILED	702
#define E_DEPOTDBCLOSEFAILED	703
#define E_DEPOTDBVERSION	704
#define E_BADDEPOTDBFILE	705
#define E_DEPOTDBREADFAILED	706
#define E_DEPOTDBWRITEFAILED	707

/* Command module errors */
#define E_NULLCOMMANDLABEL	801
#define E_BADCOMMANDLABEL	802
#define E_BADEXECFILE		803
#define E_NOEXECFILE		804
#define E_EXECFAILED		805

/* File system related errors */
#define E_AFSPROBLEM		901

/* Depot command-interface errors */
#define E_NAMETOOLONG		1001
#define E_UNNAMEDCOLLLISTFILE	1002
#define E_BADCOLLECTIONLISTFILE	1003
#define E_NOPATHTOCOLLECTION	1004
#define E_BADDEPOTCOLLECTIONLIST 1005

#endif /* _DEPOT_ERROR_H */
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/util/RCS/Error.h,v $ */
