/***********************************************************
        Copyright 1991, 1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: Error.c,v 1.11 1995/02/09 18:15:33 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "Error.h"

char        *__DepotErrorInfoFile;
unsigned int __DepotErrorInfoLineNo;
int PROGRAM_ErrorNo;

typedef struct depoterror
{
    int status;
      char *description;
} DEPOTERROR;

static DEPOTERROR DepotErrorList[] =
{
  { E_NULL,		"No error" },
  { E_USAGE,		"Bad usage" },
  { E_BADPATHNAME,	"Bad path name" },
  { E_BADRANGE,		"Bad range" },
  { E_OUTOFMEMORY,	"Memory allocation failed - out of memory" },
  { E_BADSTRING,	"Bad string" },
  { E_BADSTRINGARRAY,	"Bad string array" },
  { E_BADSTRINGSET,	"Bad string set" },
  { E_FGETUNSIGNEDFAILED,	"Call to efgetunsigned() failed" },
  { E_FGETLONGFAILED,	"Call to efgetlong() failed" },
  { E_FGETSTRINGFAILED,	"Call to efgetstring() failed" },
  { E_BADUSERNAME,	"Bad user name" },
  { E_BADGROUPNAME,	"Bad group name" },
  { E_LSEEKFAILED,	"Call to lseek(2) failed" },
  { E_CHOWNFAILED,	"Call to chown(2) failed" },
  { E_CHMODFAILED,	"Call to chmod(2) failed" },
  { E_UTIMEFAILED,	"Call to utime(3) failed" },
  { E_UTIMESFAILED,	"Call to utimes(2) failed" },
  { E_STATFAILED,	"Call to stat(2) failed" },
  { E_FSEEKFAILED,	"Call to fseek(3s) failed" },
  { E_OPENFAILED,	"Call to open(2) failed" },
  { E_FOPENFAILED,	"Call to fopen(3) failed" },
  { E_READFAILED,	"Call to read(2) failed" },
  { E_WRITEFAILED,	"Call to write(2) failed" },
  { E_COPYFAILED,	"Call to copy() failed" },
  { E_RENAMEFAILED,	"Call to rename(2) failed" },
  { E_MKDIRFAILED,	"Call to mkdir(2) failed" },
  { E_LINKFAILED,	"Call to link(2) failed" },
  { E_SYMLINKFAILED,	"Call to symlink(2) failed" },
  { E_UNLINKFAILED,	"Call to unlink(2) failed" },
  { E_READLINKFAILED,	"Call to readlink(2) failed" },
  { E_OPENDIRFAILED,	"Call to opendir(3) failed" },
  { E_RMDIRFAILED,	"Call to rmdir(2) failed" },
  { E_CHDIRFAILED,	"Call to chdir(2) failed" },
  { E_VFORKFAILED,	"Call to vfork(2) failed" },
  { E_FORKFAILED,	"Call to fork(2) failed" },
  { E_FDOPENFAILED,	"Call to fdopen(3) failed" },
  { E_PIPEFAILED,	"Call to pipe(2) failed" },
  { E_WAITPIDFAILED,	"Call to waitpid(2) failed" },
  { E_DUPFAILED,        "Call to dup(2)/dup2(2) failed"},
  { E_DECOMPRESSFAILED, "Uncompression failed"},
  { E_COMPRESSFAILED,   "Compression failed"},
  { E_CANTLOCK,		"Lock operation failed" },
  { E_BADLOCKFILE,	"Attempt to query lock failed" },
  { E_BADUSER,		"Depot operation invoked by unknown user" },
  { E_NOLOCK,		"Lock operation failed" },
  { E_FOOLPROOFLOCK,	"Attempt to pick a lock failed" },
  { E_GETSTATUSFAILED,	"Call to File_GetStatus() failed" },
  { E_SETSTATUSFAILED,	"Call to File_SetStatus() failed" },
  { E_RMPATHFAILED,	"Call to File_RemovePath() failed" },
  { E_BADFILESYSTEMIMAGE,	"Bad file system image" },
  { E_GETFSIDFAILED,	"Call to FileSystem_GetFSInfo() failes" },
  { E_BADIMAGEPATHNAME,	"Bad path in file system image" },
  { E_FSIMAGELOCATEFAILED,	"Could not locate path in file system image" },
  { E_NULLHINT,		"Unexpected NULL hint" },
  { E_NULLHINTDB,	"Unexpected NULL hint database" },
  { E_BADHINTDB,	"Bad hint database" },
  { E_BADHINTNAME,	"Bad name in hint" },
  { E_BADHINTID,	"Bad id in hint" },
  { E_HINTWRITEFAILED,	"Error while writing hint database" },
  { E_BADHINTPATHPREFIX,"Bad prefix to path in hint" },
  { E_PATHLESSHINT,	"NULL path in hint" },
  { E_BADHINTS,		"Corrupted hint database" },
  { E_PREFERENCEPARSE,	"Error parsing preference file" },
  { E_PREFWRITEFAILED,	"Error while writing preference file" },
  { E_BADPREFERENCEDB,	"Bad preference database" },
  { E_NULLPREFERENCEDB,	"Unexpected NULL preference database" },
  { E_BADPREFERENCE,	"Bad preference" },
  { E_NULLPREFERENCE,	"Unexpected NULL preference" },
  { E_UNKNOWNPREFERENCE,"Unknown preference option" },
  { E_PREFSETFAILED,	"Attempt to set value of a preference option failed" },
  { E_PREFGETFAILED,	"Attempt to get value of a preference option failed" },
  { E_BADPREFID,	"Bad preference option id" },
  { E_BADPREFTYPE,	"Bad preference value type" },
  { E_BADPREFNAME,	"Bad preference name" },
  { E_BADPREFVALUE,	"Bad preference value" },
  { E_DEPOTCONFPARSE,	"Error parsing depot configuration file" },
  { E_COLLDEPOTCONFPARSE,"Error parsing depot configuration file for collection" },
  { E_GLBLDEPOTCONFPARSE,"Error parsing global depot configuration file" },
  { E_BADDEPOTCONFSPECNAME,	"Bad depot.conf specification name" },
  { E_BADDEPOTCONFSPEC,	"Bad depot.conf specification" },
  { E_BADDEPOTCONFVALUE,"Bad depot.conf value" },
  { E_BADDEPOTCONFCOMMAND,	"Bad depot.conf command" },
  { E_BADDEPOTCONFDB,	"Bad depot configuration database" },
  { E_NULLDEPOTCONFDB,	"Unexpected NULL depot configuration database" },
  { E_TARGETDBVERSION,	"Incompatible target database version" },
  { E_NULLTARGETDB,	"Unexpected NULL target database" },
  { E_TARGETDBREADFAILED,"Attempt to read target database file failed" },
  { E_TARGETDBWRITEFAILED,"Attempt to write target database file failed" },
  { E_BADTARGETDBFILE,	"Bad target database file" },
  { E_BADTARGETNAME,	"Bad target name" },
  { E_BADTARGETSOURCE,	"Bad source for target" },
  { E_BADTARGETSOURCELIST,	"Bad list of sources for target" },
  { E_BADTARGETSOURCEPATH,	"Bad sourcepath for target" },
  { E_BADTARGETPATH,	"Bad target path" },
  { E_BADTARGETDBCHILDNAME,	"Bad name of child in target database" },
  { E_BADTARGETFILESTATUS,	"Bad target file status in target database" },
  { E_NOSUCHTARGETDBCHILD,	"Non-existent child name in target database" },
  { E_BADTARGETDBCHILDINDEX,	"Bad index to child node in target database" },
  { E_TARGETSOURCECONFLICT,	"Conflicting sources in target database" },
  { E_TARGETUIDCONFLICT,"Conflicting uids to set in target database" },
  { E_TARGETGIDCONFLICT,"Conflicting gids to set in target database" },
  { E_MODEMASKCONFLICT,	"Conflicting mode masks in target database" },
  { E_BADSOURCEUPDTSPEC,"Unknown update specification for source in target database" },
  { E_BADTARGETUPDTSPEC,"Unknown update specification for target in target database" },
  { E_SPECIALVIOLATION,	"Attempt to update special file" },
  { E_BADHARDLINKSOURCE,	"Bad source to make hard link to" },
  /* { E_COLLECTIONPLACEHOLDER,	"" }, - Unused! */
  { E_NULLCOLLECTION,	"Unexpected NULL collection" },
  { E_BADCOLLECTION,	"Bad collection" },
  { E_NODEPOTCONFSPEC,	"No configuration specified for collection" },
  { E_NULLTARGET,	"No target specified" },
  { E_BADTARGET,	"Bad target specified" },
  { E_NULLSOURCE,	"Unexpected NULL source" },
  { E_BADFILESTATUSINFO,"Bad file status information" },
  { E_BADFSIMAGETYPE,	"Bad type specified in file system image" },
  { E_BADFSIMAGENODE,	"Bad file system image node" },
  { E_BADFILESTATUSTYPE,"Bad type specified in file status" },
  { E_BADCOMMANDTARGET,	"Bad command target" },
  { E_NULLSEARCHPATH,	"NULL search path" },
  { E_FREECOLLECTION,	"Attempt to free NULL collection" },
  { E_NULLCOLLECTIONLIST,"Unexpected NULL collection list" },
  { E_BADCOLLECTIONLIST,"Bad collection list" },
  { E_BADCOLLECTIONID,	"Bad collection id" },
  { E_NULLCOLLECTIONNAME,"Unexpected NULL collection name" },
  { E_NULLDEPOTDB,	"Unexpected NULL depot database" },
  { E_DEPOTDBOPENFAILED,"Could not open deopt database" },
  { E_DEPOTDBCLOSEFAILED,"Could not close depot database" },
  { E_DEPOTDBVERSION,	"Incomptaible depot database version" },
  { E_BADDEPOTDBFILE,	"Bad depot database file" },
  { E_DEPOTDBREADFAILED,	"Error while reading depot database file" },
  { E_DEPOTDBWRITEFAILED,	"Error while writing depot database file" },
  { E_NULLCOMMANDLABEL,	"Unexpected NULL command label" },
  { E_BADCOMMANDLABEL,	"Bad command label" },
  { E_BADEXECFILE,	"Bad executable file" },
  { E_NOEXECFILE,	"No executable file found" },
  { E_EXECFAILED,	"Command execution exited abnormally" },
  { E_AFSPROBLEM,	"Attempt to fetch file system info failed due to some problem with the file system" },
  { E_NAMETOOLONG,	"Name too long" },
  { E_UNNAMEDCOLLLISTFILE,"File with list of collections not specified" },
  { E_BADCOLLECTIONLISTFILE,"Error while reading list of collections from file" },
  { E_NOPATHTOCOLLECTION,	"Could not locate path to collection" },
  { E_BADDEPOTCOLLECTIONLIST,	"Corrupted collection list" },
};


void 
__FatalError(va_alist)
va_dcl
{
  va_list ap;
  char *fmt;

  va_start(ap);

  if (PROGRAM_ErrorNo == E_NULL)
    PROGRAM_ErrorNo = va_arg(ap, int);
  else
    (void) va_arg(ap, int); /* skip the first argument */
  fmt = va_arg(ap, char *);
  (void)fprintf(stderr,"Depot Error: %s:%d: ",__DepotErrorInfoFile, 
		__DepotErrorInfoLineNo);
  (void)vfprintf(stderr, fmt, ap);
  fflush(stderr);
  va_end(ap);

  return;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/018/src/lib/util/RCS/Error.c,v $ */
